/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.providers;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.api.core.Page;
import org.apache.wiki.api.exceptions.NoRequiredPropertyException;
import org.apache.wiki.api.exceptions.ProviderException;
import org.apache.wiki.api.providers.PageProvider;
import org.apache.wiki.api.search.QueryItem;
import org.apache.wiki.api.search.SearchResult;
import org.apache.wiki.api.spi.Wiki;
import org.apache.wiki.cache.CacheInfo;
import org.apache.wiki.cache.CachingManager;
import org.apache.wiki.parser.MarkupParser;
import org.apache.wiki.render.RenderingManager;
import org.apache.wiki.util.ClassUtil;
import org.apache.wiki.util.TextUtil;

public class CachingProvider
implements PageProvider {
    private static final Logger LOG = LogManager.getLogger(CachingProvider.class);
    private CachingManager cachingManager;
    private PageProvider provider;
    private Engine engine;
    private final AtomicBoolean allRequested = new AtomicBoolean();
    private final AtomicLong pages = new AtomicLong(0L);

    public void initialize(Engine engine, Properties properties) throws NoRequiredPropertyException, IOException {
        String classname;
        LOG.debug("Initing CachingProvider");
        this.engine = engine;
        this.cachingManager = (CachingManager)this.engine.getManager(CachingManager.class);
        this.cachingManager.registerListener("jspwiki.pageCache", "expired", new Object[]{this.allRequested});
        try {
            classname = TextUtil.getRequiredProperty((Properties)properties, (String)"jspwiki.pageProvider");
        }
        catch (NoSuchElementException e) {
            throw new NoRequiredPropertyException(e.getMessage(), "jspwiki.pageProvider");
        }
        try {
            this.provider = (PageProvider)ClassUtil.buildInstance((String)"org.apache.wiki.providers", (String)classname);
            LOG.debug("Initializing real provider class {}", (Object)this.provider);
            this.provider.initialize(engine, properties);
        }
        catch (ReflectiveOperationException e) {
            LOG.error("Unable to instantiate provider class {}", (Object)classname, (Object)e);
            throw new IllegalArgumentException("illegal provider class", e);
        }
    }

    private Page getPageInfoFromCache(String name) throws ProviderException {
        if (name == null) {
            return null;
        }
        return (Page)this.cachingManager.get("jspwiki.pageCache", (Serializable)((Object)name), () -> this.provider.getPageInfo(name, -1));
    }

    public boolean pageExists(String pageName, int version) {
        Page p;
        if (pageName == null) {
            return false;
        }
        try {
            p = this.getPageInfoFromCache(pageName);
        }
        catch (ProviderException e) {
            LOG.info("Provider failed while trying to check if page exists: {}", (Object)pageName);
            return false;
        }
        if (p != null) {
            int latestVersion = p.getVersion();
            if (version == latestVersion || version == -1) {
                return true;
            }
            return this.provider.pageExists(pageName, version);
        }
        try {
            return this.getPageInfo(pageName, version) != null;
        }
        catch (ProviderException e) {
            LOG.info("Provider failed while retrieving {}", (Object)pageName);
            return false;
        }
    }

    public boolean pageExists(String pageName) {
        Page p;
        if (pageName == null) {
            return false;
        }
        try {
            p = this.getPageInfoFromCache(pageName);
        }
        catch (ProviderException e) {
            LOG.info("Provider failed while trying to check if page exists: {}", (Object)pageName);
            return false;
        }
        if (p != null) {
            return true;
        }
        if (this.pages.get() < this.cachingManager.info("jspwiki.pageCache").getMaxElementsAllowed()) {
            return false;
        }
        return this.provider.pageExists(pageName);
    }

    public String getPageText(String pageName, int version) throws ProviderException {
        Page p;
        if (pageName == null) {
            return null;
        }
        String result = version == -1 ? this.getTextFromCache(pageName) : ((p = this.getPageInfoFromCache(pageName)) != null && p.getVersion() == version ? this.getTextFromCache(pageName) : this.provider.getPageText(pageName, version));
        return result;
    }

    private String getTextFromCache(String pageName) throws ProviderException {
        if (pageName == null) {
            return null;
        }
        return (String)this.cachingManager.get("jspwiki.pageTextCache", (Serializable)((Object)pageName), () -> {
            if (this.pageExists(pageName)) {
                return this.provider.getPageText(pageName, -1);
            }
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putPageText(Page page, String text) throws ProviderException {
        CachingProvider cachingProvider = this;
        synchronized (cachingProvider) {
            this.provider.putPageText(page, text);
            page.setLastModified(new Date());
            this.cachingManager.remove("jspwiki.pageCache", (Serializable)((Object)page.getName()));
            this.cachingManager.remove("jspwiki.pageTextCache", (Serializable)((Object)page.getName()));
            this.cachingManager.remove("jspwiki.pageHistoryCache", (Serializable)((Object)page.getName()));
            this.getPageInfoFromCache(page.getName());
        }
        this.pages.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Page> getAllPages() throws ProviderException {
        TreeSet<Page> all;
        if (!this.allRequested.get()) {
            all = this.provider.getAllPages();
            CachingProvider cachingProvider = this;
            synchronized (cachingProvider) {
                for (Page p : all) {
                    this.cachingManager.put("jspwiki.pageCache", (Serializable)((Object)p.getName()), (Object)p);
                }
                this.allRequested.set(true);
            }
            this.pages.set(all.size());
        } else {
            List keys = this.cachingManager.keys("jspwiki.pageCache");
            all = new TreeSet<Page>();
            for (String key : keys) {
                Page cachedPage = (Page)this.cachingManager.get("jspwiki.pageCache", (Serializable)((Object)key), () -> null);
                if (cachedPage == null) continue;
                all.add(cachedPage);
            }
        }
        if (this.cachingManager.enabled("jspwiki.pageCache") && this.pages.get() >= this.cachingManager.info("jspwiki.pageCache").getMaxElementsAllowed()) {
            LOG.warn("seems {} can't hold all pages from your page repository, so we're delegating on the underlying provider instead. Please consider increasing your cache sizes on the ehcache configuration file to avoid this behaviour", (Object)"jspwiki.pageCache");
            return this.provider.getAllPages();
        }
        return all;
    }

    public Collection<Page> getAllChangedSince(Date date) {
        return this.provider.getAllChangedSince(date);
    }

    public int getPageCount() throws ProviderException {
        return this.provider.getPageCount();
    }

    public Collection<SearchResult> findPages(QueryItem[] query) {
        return this.provider.findPages(query);
    }

    private void refreshMetadata(Page page) {
        if (page != null && !page.hasMetadata()) {
            RenderingManager mgr = (RenderingManager)this.engine.getManager(RenderingManager.class);
            try {
                String data = this.provider.getPageText(page.getName(), page.getVersion());
                Context ctx = Wiki.context().create(this.engine, page);
                MarkupParser parser = mgr.getParser(ctx, data);
                parser.parse();
            }
            catch (Exception ex) {
                LOG.debug("Failed to retrieve variables for wikipage {}", (Object)page);
            }
        }
    }

    public Page getPageInfo(String pageName, int version) throws ProviderException {
        Page cached = this.getPageInfoFromCache(pageName);
        int latestcached = cached != null ? cached.getVersion() : Integer.MIN_VALUE;
        Page page = version == -1 || version == latestcached ? cached : this.provider.getPageInfo(pageName, version);
        this.refreshMetadata(page);
        return page;
    }

    public List<Page> getVersionHistory(String pageName) throws ProviderException {
        if (pageName == null) {
            return null;
        }
        return (List)this.cachingManager.get("jspwiki.pageHistoryCache", (Serializable)((Object)pageName), () -> this.provider.getVersionHistory(pageName));
    }

    public synchronized String getProviderInfo() {
        CacheInfo pageCacheInfo = this.cachingManager.info("jspwiki.pageCache");
        CacheInfo pageHistoryCacheInfo = this.cachingManager.info("jspwiki.pageHistoryCache");
        return "Real provider: " + this.provider.getClass().getName() + ". Page cache hits: " + pageCacheInfo.getHits() + ". Page cache misses: " + pageCacheInfo.getMisses() + ". History cache hits: " + pageHistoryCacheInfo.getHits() + ". History cache misses: " + pageHistoryCacheInfo.getMisses();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteVersion(String pageName, int version) throws ProviderException {
        CachingProvider cachingProvider = this;
        synchronized (cachingProvider) {
            int latestcached;
            Page cached = this.getPageInfoFromCache(pageName);
            int n = latestcached = cached != null ? cached.getVersion() : Integer.MIN_VALUE;
            if (version == -1 || version == latestcached) {
                this.cachingManager.remove("jspwiki.pageCache", (Serializable)((Object)pageName));
                this.cachingManager.remove("jspwiki.pageTextCache", (Serializable)((Object)pageName));
            }
            this.provider.deleteVersion(pageName, version);
            this.cachingManager.remove("jspwiki.pageHistoryCache", (Serializable)((Object)pageName));
        }
        if (version == -1) {
            this.pages.decrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deletePage(String pageName) throws ProviderException {
        CachingProvider cachingProvider = this;
        synchronized (cachingProvider) {
            this.cachingManager.put("jspwiki.pageCache", (Serializable)((Object)pageName), null);
            this.cachingManager.put("jspwiki.pageTextCache", (Serializable)((Object)pageName), null);
            this.cachingManager.put("jspwiki.pageHistoryCache", (Serializable)((Object)pageName), null);
            this.provider.deletePage(pageName);
        }
        this.pages.decrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void movePage(String from, String to) throws ProviderException {
        this.provider.movePage(from, to);
        CachingProvider cachingProvider = this;
        synchronized (cachingProvider) {
            this.cachingManager.remove("jspwiki.pageCache", (Serializable)((Object)from));
            this.cachingManager.remove("jspwiki.pageTextCache", (Serializable)((Object)from));
            this.cachingManager.remove("jspwiki.pageHistoryCache", (Serializable)((Object)from));
            LOG.debug("Removing to page {} from cache", (Object)to);
            this.cachingManager.remove("jspwiki.pageCache", (Serializable)((Object)to));
            this.cachingManager.remove("jspwiki.pageTextCache", (Serializable)((Object)to));
            this.cachingManager.remove("jspwiki.pageHistoryCache", (Serializable)((Object)to));
        }
    }

    public PageProvider getRealProvider() {
        return this.provider;
    }
}

