/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.geosparql.spatial.task;

import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.jena.geosparql.spatial.task.BasicTask;
import org.apache.jena.geosparql.spatial.task.TaskState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TaskThread
extends Thread
implements BasicTask {
    private static final Logger logger = LoggerFactory.getLogger(TaskThread.class);
    private final AtomicBoolean requestingCancel;
    private Object cancelLock = new Object();
    private TaskState state = TaskState.CREATED;
    private BasicTask.TaskListener<BasicTask> taskListener;
    private boolean isComplete = false;
    private Throwable throwable;
    private String label;
    private String statusMessage;
    private long creationTime = -1L;
    private long startTime = -1L;
    private long cancelTime = -1L;
    private long endTime = -1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateState(TaskState state) {
        Object object = this.cancelLock;
        synchronized (object) {
            this.state = state;
            if (this.taskListener != null) {
                try {
                    this.taskListener.onStateChange(this);
                }
                catch (Throwable t) {
                    logger.warn("Listener raised an exception.", t);
                }
            }
        }
    }

    public TaskThread(String label, BasicTask.TaskListener<BasicTask> taskListener) {
        this(label, taskListener, new AtomicBoolean());
    }

    public TaskThread(String label, BasicTask.TaskListener<BasicTask> taskListener, AtomicBoolean requestingCancel) {
        this.label = label;
        this.taskListener = taskListener;
        this.requestingCancel = Objects.requireNonNull(requestingCancel);
        this.creationTime = System.currentTimeMillis();
        this.updateState(TaskState.CREATED);
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public TaskState getTaskState() {
        return this.state;
    }

    @Override
    public Throwable getThrowable() {
        return this.throwable;
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public long getEndTime() {
        return this.endTime;
    }

    @Override
    public long getAbortTime() {
        return this.cancelTime;
    }

    protected void setStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
    }

    @Override
    public String getStatusMessage() {
        return this.statusMessage;
    }

    protected void beforeRun() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        Object object = this.cancelLock;
        synchronized (object) {
            if (!TaskState.CREATED.equals((Object)this.state)) {
                throw new IllegalStateException("Can only start tasks in CREATED state, but this task is in state: " + String.valueOf((Object)this.state));
            }
            this.startTime = System.currentTimeMillis();
            this.updateState(TaskState.STARTING);
        }
        this.runInternal();
    }

    public final void runInternal() {
        try {
            this.checkCancelled();
            this.beforeRun();
            this.checkCancelled();
            this.runActual();
        }
        catch (Throwable t) {
            this.throwable = t;
            this.updateState(TaskState.TERMINATING);
            throw new RuntimeException(t);
        }
        finally {
            this.endTime = System.currentTimeMillis();
            this.isComplete = true;
            try {
                this.doAfterRun();
            }
            finally {
                this.updateState(TaskState.TERMINATED);
            }
        }
    }

    public abstract void runActual() throws Exception;

    protected void requestCancel() {
        if (TaskState.CREATED.equals((Object)this.state)) {
            this.throwable = new CancellationException();
            this.updateState(TaskState.TERMINATED);
        } else {
            this.updateState(TaskState.ABORTING);
            this.interrupt();
        }
    }

    protected void doAfterRun() {
    }

    protected void checkCancelled() {
        if (this.isAborting()) {
            throw new CancellationException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abort() {
        Object object = this.cancelLock;
        synchronized (object) {
            if (!this.requestingCancel.get()) {
                this.requestingCancel.set(true);
                this.cancelTime = System.currentTimeMillis();
                if (!this.isComplete) {
                    this.requestCancel();
                }
            }
        }
    }

    @Override
    public boolean isAborting() {
        return this.requestingCancel.get();
    }

    @Override
    public boolean isTerminated() {
        return !this.isAlive();
    }
}

