/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.rabbitmq;

import jakarta.inject.Inject;
import java.util.Optional;
import org.apache.james.backends.rabbitmq.RabbitMQServerVersion;
import org.apache.james.backends.rabbitmq.ReactorRabbitMQChannelPool;
import org.apache.james.backends.rabbitmq.SimpleConnectionPool;
import org.apache.james.core.healthcheck.ComponentName;
import org.apache.james.core.healthcheck.HealthCheck;
import org.apache.james.core.healthcheck.Result;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class RabbitMQHealthCheck
implements HealthCheck {
    private static final RabbitMQServerVersion MINIMAL_VERSION = RabbitMQServerVersion.of("3.8.1");
    private static final ComponentName COMPONENT_NAME = new ComponentName("RabbitMQ backend");
    private final SimpleConnectionPool connectionPool;
    private final ReactorRabbitMQChannelPool rabbitChannelPoolImpl;

    @Inject
    public RabbitMQHealthCheck(SimpleConnectionPool connectionPool, ReactorRabbitMQChannelPool rabbitChannelPoolImpl) {
        this.connectionPool = connectionPool;
        this.rabbitChannelPoolImpl = rabbitChannelPoolImpl;
    }

    public ComponentName componentName() {
        return COMPONENT_NAME;
    }

    public Mono<Result> check() {
        try {
            return Flux.concat((Publisher[])new Publisher[]{this.connectionPool.tryConnection(), this.rabbitChannelPoolImpl.tryChannel()}).reduce((Object)true, (a, b) -> a != false && b != false).flatMap(channelOpen -> {
                if (channelOpen.booleanValue()) {
                    return this.checkVersion();
                }
                return Mono.just((Object)Result.unhealthy((ComponentName)COMPONENT_NAME, (String)"The created connection was not opened"));
            }).onErrorResume(e -> Mono.just((Object)Result.unhealthy((ComponentName)COMPONENT_NAME, (String)"Unhealthy RabbitMQ instances: could not establish a connection", (Throwable)e)));
        }
        catch (Exception e2) {
            return Mono.just((Object)Result.unhealthy((ComponentName)COMPONENT_NAME, (String)"Unhealthy RabbitMQ instances: could not establish a connection", (Throwable)e2));
        }
    }

    private Mono<? extends Result> checkVersion() {
        return this.connectionPool.version().map(Optional::of).defaultIfEmpty(Optional.empty()).flatMap(version -> {
            boolean isCompatible = version.map(fetchedVersion -> fetchedVersion.isAtLeast(MINIMAL_VERSION)).orElse(false);
            if (!isCompatible) {
                String versionCompatibilityError = String.format("RabbitMQ version(%s) is not compatible with the required one(%s)", version.map(RabbitMQServerVersion::asString).orElse("no versions fetched"), MINIMAL_VERSION.asString());
                return Mono.just((Object)Result.unhealthy((ComponentName)COMPONENT_NAME, (String)versionCompatibilityError));
            }
            return Mono.just((Object)Result.healthy((ComponentName)COMPONENT_NAME));
        });
    }
}

