/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils.windowing.window;

import org.apache.iotdb.db.utils.windowing.api.Window;
import org.apache.iotdb.db.utils.windowing.window.EvictableBatchList;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.write.UnSupportedDataTypeException;

public class WindowImpl
implements Window {
    private final int size;
    private final TSDataType dataType;
    private long[] timestamps = null;
    private int[] intValues = null;
    private long[] longValues = null;
    private float[] floatValues = null;
    private double[] doubleValues = null;
    private boolean[] booleanValues = null;
    private Binary[] binaryValues = null;

    public WindowImpl(EvictableBatchList list, int begin, int size) {
        this.size = size;
        this.dataType = list.getDataType();
        this.init(list, begin);
    }

    private void init(EvictableBatchList list, int begin) {
        int i;
        this.timestamps = new long[this.size];
        for (i = 0; i < this.size; ++i) {
            this.timestamps[i] = list.getTimeByIndex(begin + i);
        }
        switch (this.dataType) {
            case INT32: 
            case DATE: {
                this.intValues = new int[this.size];
                for (i = 0; i < this.size; ++i) {
                    this.intValues[i] = list.getIntByIndex(begin + i);
                }
                break;
            }
            case INT64: 
            case TIMESTAMP: {
                this.longValues = new long[this.size];
                for (i = 0; i < this.size; ++i) {
                    this.longValues[i] = list.getLongByIndex(begin + i);
                }
                break;
            }
            case FLOAT: {
                this.floatValues = new float[this.size];
                for (i = 0; i < this.size; ++i) {
                    this.floatValues[i] = list.getFloatByIndex(begin + i);
                }
                break;
            }
            case DOUBLE: {
                this.doubleValues = new double[this.size];
                for (i = 0; i < this.size; ++i) {
                    this.doubleValues[i] = list.getDoubleByIndex(begin + i);
                }
                break;
            }
            case BOOLEAN: {
                this.booleanValues = new boolean[this.size];
                for (i = 0; i < this.size; ++i) {
                    this.booleanValues[i] = list.getBooleanByIndex(begin + i);
                }
                break;
            }
            case TEXT: 
            case BLOB: 
            case STRING: {
                this.binaryValues = new Binary[this.size];
                for (i = 0; i < this.size; ++i) {
                    this.binaryValues[i] = list.getBinaryByIndex(begin + i);
                }
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(this.dataType.toString());
            }
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public TSDataType getDataType() {
        return this.dataType;
    }

    @Override
    public long getTime(int index) {
        return this.timestamps[index];
    }

    @Override
    public int getInt(int index) {
        return this.intValues[index];
    }

    @Override
    public long getLong(int index) {
        return this.longValues[index];
    }

    @Override
    public float getFloat(int index) {
        return this.floatValues[index];
    }

    @Override
    public double getDouble(int index) {
        return this.doubleValues[index];
    }

    @Override
    public boolean getBoolean(int index) {
        return this.booleanValues[index];
    }

    @Override
    public Binary getBinary(int index) {
        return this.binaryValues[index];
    }

    @Override
    public long[] getTimeArray() {
        return this.timestamps;
    }

    @Override
    public int[] getIntArray() {
        return this.intValues;
    }

    @Override
    public long[] getLongArray() {
        return this.longValues;
    }

    @Override
    public float[] getFloatArray() {
        return this.floatValues;
    }

    @Override
    public double[] getDoubleArray() {
        return this.doubleValues;
    }

    @Override
    public boolean[] getBooleanArray() {
        return this.booleanValues;
    }

    @Override
    public Binary[] getBinaryArray() {
        return this.binaryValues;
    }

    @Override
    public void setInt(int index, int value) {
        this.intValues[index] = value;
    }

    @Override
    public void setLong(int index, long value) {
        this.longValues[index] = value;
    }

    @Override
    public void setFloat(int index, float value) {
        this.floatValues[index] = value;
    }

    @Override
    public void setDouble(int index, double value) {
        this.doubleValues[index] = value;
    }

    @Override
    public void setBoolean(int index, boolean value) {
        this.booleanValues[index] = value;
    }

    @Override
    public void setBinary(int index, Binary value) {
        this.binaryValues[index] = value;
    }
}

