/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.schemaregion.attribute.update;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.iotdb.db.schemaengine.schemaregion.attribute.DeviceAttributeStore;
import org.apache.iotdb.db.schemaengine.schemaregion.attribute.update.RewritableByteArrayOutputStream;
import org.apache.iotdb.db.schemaengine.schemaregion.attribute.update.UpdateClearContainer;
import org.apache.iotdb.db.schemaengine.schemaregion.attribute.update.UpdateContainer;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.apache.tsfile.utils.ReadWriteIOUtils;

@ThreadSafe
public class UpdateDetailContainer
implements UpdateContainer {
    static final long MAP_SIZE = RamUsageEstimator.shallowSizeOfInstance(ConcurrentHashMap.class);
    public static final long LIST_SIZE = RamUsageEstimator.shallowSizeOfInstance(ArrayList.class);
    static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(UpdateClearContainer.class) + MAP_SIZE;
    private final ConcurrentMap<String, ConcurrentMap<List<String>, ConcurrentMap<String, Binary>>> updateMap = new ConcurrentHashMap<String, ConcurrentMap<List<String>, ConcurrentMap<String, Binary>>>();

    public ConcurrentMap<String, ConcurrentMap<List<String>, ConcurrentMap<String, Binary>>> getUpdateMap() {
        return this.updateMap;
    }

    @Override
    public long updateAttribute(String tableName, String[] deviceId, Map<String, Binary> updatedAttributes) {
        AtomicLong result = new AtomicLong(0L);
        this.updateMap.compute(tableName, (name, value) -> {
            if (Objects.isNull(value)) {
                result.addAndGet(RamUsageEstimator.HASHTABLE_RAM_BYTES_PER_ENTRY + RamUsageEstimator.sizeOf((String)name) + MAP_SIZE);
                value = new ConcurrentHashMap<List, ConcurrentMap>();
            }
            value.compute(Arrays.asList(deviceId), (device, attributes) -> {
                if (Objects.isNull(attributes)) {
                    result.addAndGet(RamUsageEstimator.HASHTABLE_RAM_BYTES_PER_ENTRY + UpdateDetailContainer.sizeOfList(device) + MAP_SIZE);
                    attributes = new ConcurrentHashMap<String, Binary>();
                }
                for (Map.Entry updateAttribute : updatedAttributes.entrySet()) {
                    attributes.compute((String)updateAttribute.getKey(), (k, v) -> {
                        if (Objects.isNull(v)) {
                            result.addAndGet(RamUsageEstimator.sizeOf((String)k) + RamUsageEstimator.HASHTABLE_RAM_BYTES_PER_ENTRY);
                        }
                        result.addAndGet(UpdateDetailContainer.sizeOf((Binary)updateAttribute.getValue()) - (Objects.nonNull(v) ? UpdateDetailContainer.sizeOf(v) : 0L));
                        return (Binary)updateAttribute.getValue();
                    });
                }
                return attributes;
            });
            return value;
        });
        return result.get();
    }

    @Override
    public byte[] getUpdateContent(@Nonnull AtomicInteger limitBytes, @Nonnull AtomicBoolean hasRemaining) {
        RewritableByteArrayOutputStream outputStream = new RewritableByteArrayOutputStream();
        try {
            this.serializeWithLimit(outputStream, limitBytes, hasRemaining);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return outputStream.toByteArray();
    }

    @Override
    public long invalidate(String tableName) {
        AtomicLong result = new AtomicLong(0L);
        this.handleTableRemoval(tableName, result);
        return result.get();
    }

    @Override
    public long invalidate(@Nonnull String[] pathNodes) {
        AtomicLong result = new AtomicLong(0L);
        this.updateMap.compute(pathNodes[2], (name, value) -> {
            if (Objects.isNull(value)) {
                return null;
            }
            value.compute(Arrays.asList(pathNodes).subList(3, pathNodes.length), (device, attributes) -> {
                if (Objects.nonNull(attributes)) {
                    result.addAndGet(RamUsageEstimator.HASHTABLE_RAM_BYTES_PER_ENTRY + UpdateDetailContainer.sizeOfList(device) + UpdateDetailContainer.sizeOfMapEntries(attributes));
                }
                return null;
            });
            if (value.isEmpty()) {
                result.addAndGet(RamUsageEstimator.HASHTABLE_RAM_BYTES_PER_ENTRY + RamUsageEstimator.sizeOf((String)name) + MAP_SIZE);
                return null;
            }
            return value;
        });
        return result.get();
    }

    @Override
    public long invalidate(String tableName, String attributeName) {
        AtomicLong result = new AtomicLong(0L);
        long keyEntrySize = RamUsageEstimator.sizeOf((String)attributeName) + RamUsageEstimator.HASHTABLE_RAM_BYTES_PER_ENTRY;
        this.updateMap.compute(tableName, (name, value) -> {
            if (Objects.isNull(value)) {
                return null;
            }
            Iterator it = value.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                Binary attributeValue = (Binary)((ConcurrentMap)entry.getValue()).remove(attributeName);
                if (Objects.nonNull(attributeValue)) {
                    result.addAndGet(keyEntrySize + UpdateDetailContainer.sizeOf(attributeValue));
                }
                if (!((ConcurrentMap)entry.getValue()).isEmpty()) continue;
                result.addAndGet(RamUsageEstimator.HASHTABLE_RAM_BYTES_PER_ENTRY + UpdateDetailContainer.sizeOfList((List)entry.getKey()) + MAP_SIZE);
                it.remove();
            }
            if (value.isEmpty()) {
                result.addAndGet(RamUsageEstimator.HASHTABLE_RAM_BYTES_PER_ENTRY + RamUsageEstimator.sizeOf((String)name) + MAP_SIZE);
                return null;
            }
            return value;
        });
        return result.get();
    }

    private void serializeWithLimit(RewritableByteArrayOutputStream outputStream, AtomicInteger limitBytes, AtomicBoolean hasRemaining) throws IOException {
        ReadWriteIOUtils.write((byte)1, (OutputStream)outputStream);
        int mapSizeOffset = outputStream.skipInt();
        int mapEntryCount = 0;
        for (Map.Entry tableEntry : this.updateMap.entrySet()) {
            byte[] tableEntryBytes = ((String)tableEntry.getKey()).getBytes(TSFileConfig.STRING_CHARSET);
            int newSize = 8 + tableEntryBytes.length;
            if (limitBytes.get() < newSize) {
                outputStream.rewrite(mapEntryCount, mapSizeOffset);
                hasRemaining.set(true);
                return;
            }
            limitBytes.addAndGet(-newSize);
            ++mapEntryCount;
            outputStream.writeWithLength(tableEntryBytes);
            int deviceSizeOffset = outputStream.skipInt();
            int deviceEntryCount = 0;
            for (Map.Entry deviceEntry : ((ConcurrentMap)tableEntry.getValue()).entrySet()) {
                byte[][] deviceIdBytes = (byte[][])((List)deviceEntry.getKey()).stream().map(str -> Objects.nonNull(str) ? str.getBytes(TSFileConfig.STRING_CHARSET) : null).toArray(x$0 -> new byte[x$0][]);
                newSize = 4 * (deviceIdBytes.length + 2) + Arrays.stream(deviceIdBytes).map(bytes -> Objects.nonNull(bytes) ? ((byte[])bytes).length : 0).reduce(0, Integer::sum);
                if (limitBytes.get() < newSize) {
                    outputStream.rewrite(mapEntryCount, mapSizeOffset);
                    outputStream.rewrite(deviceEntryCount, deviceSizeOffset);
                    hasRemaining.set(true);
                    return;
                }
                limitBytes.addAndGet(-newSize);
                ++deviceEntryCount;
                ReadWriteIOUtils.write((int)((List)deviceEntry.getKey()).size(), (OutputStream)outputStream);
                for (byte[] node : deviceIdBytes) {
                    outputStream.writeWithLength(node);
                }
                int attributeOffset = outputStream.skipInt();
                int attributeCount = 0;
                for (Map.Entry attributeKV : ((ConcurrentMap)deviceEntry.getValue()).entrySet()) {
                    byte[] keyBytes = ((String)attributeKV.getKey()).getBytes(TSFileConfig.STRING_CHARSET);
                    byte[] valueBytes = attributeKV.getValue() != Binary.EMPTY_VALUE ? ((Binary)attributeKV.getValue()).getValues() : null;
                    newSize = 8 + keyBytes.length + (Objects.nonNull(valueBytes) ? valueBytes.length : 0);
                    if (limitBytes.get() < newSize) {
                        outputStream.rewrite(mapEntryCount, mapSizeOffset);
                        outputStream.rewrite(deviceEntryCount, deviceSizeOffset);
                        outputStream.rewrite(attributeCount, attributeOffset);
                        hasRemaining.set(true);
                        return;
                    }
                    limitBytes.addAndGet(-newSize);
                    outputStream.writeWithLength(keyBytes);
                    outputStream.writeWithLength(valueBytes);
                    ++attributeCount;
                }
                outputStream.rewrite(((ConcurrentMap)deviceEntry.getValue()).size(), attributeOffset);
            }
            outputStream.rewrite(((ConcurrentMap)tableEntry.getValue()).size(), deviceSizeOffset);
        }
        outputStream.rewrite(this.updateMap.size(), mapSizeOffset);
    }

    @Override
    public Pair<Long, Boolean> updateSelfByCommitContainer(UpdateContainer commitContainer) {
        AtomicLong result = new AtomicLong(0L);
        if (commitContainer instanceof UpdateDetailContainer) {
            ((UpdateDetailContainer)commitContainer).updateMap.forEach((table, commitMap) -> {
                if (!this.updateMap.containsKey(table)) {
                    return;
                }
                ConcurrentMap thisDeviceMap = (ConcurrentMap)this.updateMap.get(table);
                commitMap.forEach((device, attributes) -> {
                    if (!thisDeviceMap.containsKey(device)) {
                        return;
                    }
                    Map thisAttributes = (Map)thisDeviceMap.get(device);
                    attributes.forEach((k, v) -> {
                        if (!thisAttributes.containsKey(k)) {
                            return;
                        }
                        Binary thisV = (Binary)thisAttributes.get(k);
                        if (Objects.equals(thisV, v)) {
                            result.addAndGet(RamUsageEstimator.sizeOf((String)k) + UpdateDetailContainer.sizeOf(thisV) + RamUsageEstimator.HASHTABLE_RAM_BYTES_PER_ENTRY);
                            thisAttributes.remove(k);
                        }
                    });
                    if (thisAttributes.isEmpty()) {
                        result.addAndGet(RamUsageEstimator.HASHTABLE_RAM_BYTES_PER_ENTRY + UpdateDetailContainer.sizeOfList(device) + MAP_SIZE);
                        thisDeviceMap.remove(device);
                    }
                });
                if (thisDeviceMap.isEmpty()) {
                    result.addAndGet(RamUsageEstimator.HASHTABLE_RAM_BYTES_PER_ENTRY + RamUsageEstimator.sizeOf((String)table) + MAP_SIZE);
                    this.updateMap.remove(table);
                }
            });
        } else {
            ((UpdateClearContainer)commitContainer).getTableNames().forEach(tableName -> this.handleTableRemoval((String)tableName, result));
        }
        return new Pair((Object)result.get(), (Object)this.updateMap.isEmpty());
    }

    private void handleTableRemoval(String tableName, AtomicLong result) {
        ConcurrentMap deviceMap = (ConcurrentMap)this.updateMap.remove(tableName);
        if (Objects.nonNull(deviceMap)) {
            result.addAndGet((long)deviceMap.size() * (RamUsageEstimator.HASHTABLE_RAM_BYTES_PER_ENTRY + MAP_SIZE) + deviceMap.entrySet().stream().mapToLong(entry -> UpdateDetailContainer.sizeOfList((List)entry.getKey()) + UpdateDetailContainer.sizeOfMapEntries((Map)entry.getValue())).reduce(0L, Long::sum));
        }
    }

    private static long sizeOfList(@Nonnull List<String> input) {
        return input.stream().map(RamUsageEstimator::sizeOf).reduce(LIST_SIZE, Long::sum);
    }

    public static long sizeOfMapEntries(@Nonnull Map<String, Binary> map) {
        return (long)map.size() * RamUsageEstimator.HASHTABLE_RAM_BYTES_PER_ENTRY + map.entrySet().stream().mapToLong(innerEntry -> RamUsageEstimator.sizeOf((String)((String)innerEntry.getKey())) + UpdateDetailContainer.sizeOf((Binary)innerEntry.getValue())).reduce(0L, Long::sum);
    }

    public static long sizeOf(Binary value) {
        return value == Binary.EMPTY_VALUE ? 0L : value.ramBytesUsed();
    }

    @Override
    public void serialize(OutputStream outputStream) throws IOException {
        ReadWriteIOUtils.write((byte)1, (OutputStream)outputStream);
        ReadWriteIOUtils.write((int)this.updateMap.size(), (OutputStream)outputStream);
        for (Map.Entry tableEntry : this.updateMap.entrySet()) {
            ReadWriteIOUtils.write((String)((String)tableEntry.getKey()), (OutputStream)outputStream);
            ReadWriteIOUtils.write((int)((ConcurrentMap)tableEntry.getValue()).size(), (OutputStream)outputStream);
            for (Map.Entry deviceEntry : ((ConcurrentMap)tableEntry.getValue()).entrySet()) {
                ReadWriteIOUtils.write((int)((List)deviceEntry.getKey()).size(), (OutputStream)outputStream);
                for (String node : (List)deviceEntry.getKey()) {
                    ReadWriteIOUtils.write((String)node, (OutputStream)outputStream);
                }
                DeviceAttributeStore.write((Map)deviceEntry.getValue(), outputStream);
            }
        }
    }

    @Override
    public void deserialize(InputStream inputStream) throws IOException {
        int tableSize = ReadWriteIOUtils.readInt((InputStream)inputStream);
        for (int i = 0; i < tableSize; ++i) {
            String tableName = ReadWriteIOUtils.readString((InputStream)inputStream);
            int deviceSize = ReadWriteIOUtils.readInt((InputStream)inputStream);
            ConcurrentHashMap deviceMap = new ConcurrentHashMap(deviceSize);
            for (int j = 0; j < deviceSize; ++j) {
                int nodeSize = ReadWriteIOUtils.readInt((InputStream)inputStream);
                ArrayList<String> deviceId = new ArrayList<String>(nodeSize);
                for (int k = 0; k < nodeSize; ++k) {
                    deviceId.add(ReadWriteIOUtils.readString((InputStream)inputStream));
                }
                deviceMap.put(deviceId, (ConcurrentMap)DeviceAttributeStore.readMap(inputStream, true));
            }
            this.updateMap.put(tableName, deviceMap);
        }
    }

    UpdateClearContainer degrade() {
        return new UpdateClearContainer(this.updateMap.keySet());
    }
}

