/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.broker.config;

import io.moquette.broker.Server;
import io.moquette.broker.config.IConfig;
import io.moquette.broker.config.MemoryConfig;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Locale;
import java.util.Properties;
import java.util.function.Consumer;

public class FluentConfig {
    private Server server;
    private TLSConfig tlsConfig;
    private final Properties configAccumulator = new Properties();
    private final CreationKind creationKind;

    public FluentConfig() {
        this.initializeDefaultValues();
        this.creationKind = CreationKind.API;
    }

    public FluentConfig(Server server) {
        this.initializeDefaultValues();
        this.creationKind = CreationKind.SERVER;
        this.server = server;
    }

    private void initializeDefaultValues() {
        this.configAccumulator.put("port", Integer.toString(1883));
        this.configAccumulator.put("host", "0.0.0.0");
        this.configAccumulator.put("password_file", "");
        this.configAccumulator.put("peer_certificate_as_username", Boolean.FALSE.toString());
        this.configAccumulator.put("allow_anonymous", Boolean.TRUE.toString());
        this.configAccumulator.put("authenticator_class", "");
        this.configAccumulator.put("authorizator_class", "");
        this.configAccumulator.put("netty.mqtt.message_size", String.valueOf(8092));
        this.configAccumulator.put("persistent_queue_type", PersistentQueueType.SEGMENTED.name().toLowerCase(Locale.ROOT));
        this.configAccumulator.put("data_path", "data/");
        this.configAccumulator.put("persistence_enabled", Boolean.TRUE.toString());
        this.configAccumulator.put("buffer_flush_millis", BufferFlushKind.IMMEDIATE.name().toLowerCase(Locale.ROOT));
    }

    public FluentConfig host(String host) {
        this.configAccumulator.put("host", host);
        return this;
    }

    public FluentConfig port(int port) {
        FluentConfig.validatePort(port);
        this.configAccumulator.put("port", Integer.toString(port));
        return this;
    }

    public FluentConfig websocketPort(int port) {
        FluentConfig.validatePort(port);
        this.configAccumulator.put("websocket_port", Integer.toString(port));
        return this;
    }

    private static void validatePort(int port) {
        if (port > 65535 || port < 0) {
            throw new IllegalArgumentException("Port must be in range [0.65535]");
        }
    }

    public FluentConfig dataPath(String dataPath) {
        this.configAccumulator.put("data_path", dataPath);
        return this;
    }

    public FluentConfig dataPath(Path dataPath) {
        this.configAccumulator.put("data_path", dataPath.toAbsolutePath().toString());
        return this;
    }

    public FluentConfig enablePersistence() {
        this.configAccumulator.put("persistence_enabled", "true");
        return this;
    }

    public FluentConfig disablePersistence() {
        this.configAccumulator.put("persistence_enabled", "false");
        return this;
    }

    public FluentConfig persistentQueueType(PersistentQueueType type) {
        this.configAccumulator.put("persistent_queue_type", type.name().toLowerCase(Locale.ROOT));
        return this;
    }

    public FluentConfig enablePeerCertificateAsUsername() {
        this.configAccumulator.put("peer_certificate_as_username", "true");
        return this;
    }

    public FluentConfig disablePeerCertificateAsUsername() {
        this.configAccumulator.put("peer_certificate_as_username", "false");
        return this;
    }

    public FluentConfig disallowAnonymous() {
        this.configAccumulator.put("allow_anonymous", "false");
        return this;
    }

    public FluentConfig aclFile(String aclPath) {
        this.configAccumulator.put("acl_file", aclPath);
        return this;
    }

    public FluentConfig passwordFile(String passwordFilePath) {
        this.configAccumulator.put("password_file", passwordFilePath);
        return this;
    }

    public FluentConfig bufferFlushMillis(int value) {
        this.configAccumulator.put("buffer_flush_millis", Integer.valueOf(value).toString());
        return this;
    }

    public FluentConfig bufferFlushMillis(BufferFlushKind value) {
        this.configAccumulator.put("buffer_flush_millis", value.name().toLowerCase(Locale.ROOT));
        return this;
    }

    public FluentConfig persistentClientExpiration(String expiration) {
        this.configAccumulator.put("persistent_client_expiration", expiration);
        return this;
    }

    public FluentConfig sessionQueueSize(int value) {
        this.configAccumulator.put("session_queue_size", Integer.valueOf(value).toString());
        return this;
    }

    public FluentConfig disableTelemetry() {
        this.configAccumulator.put("telemetry_enabled", "false");
        return this;
    }

    public FluentConfig enableTelemetry() {
        this.configAccumulator.put("telemetry_enabled", "true");
        return this;
    }

    public FluentConfig receiveMaximum(int receiveMaximum) {
        this.configAccumulator.put("receive_maximum", Integer.valueOf(receiveMaximum).toString());
        return this;
    }

    public FluentConfig topicAliasMaximum(int topicAliasMaximum) {
        this.configAccumulator.put("topic_alias_maximum", Integer.valueOf(topicAliasMaximum).toString());
        return this;
    }

    public FluentConfig serverKeepAlive(Duration keepAliveSeconds) {
        int seconds = (int)keepAliveSeconds.toMillis() / 1000;
        this.configAccumulator.put("server_keep_alive", seconds + "s");
        return this;
    }

    public FluentConfig withTLS(Consumer<TLSConfig> tlsBlock) {
        this.tlsConfig = new TLSConfig();
        tlsBlock.accept(this.tlsConfig);
        this.configAccumulator.put("ssl_port", Integer.toString(this.tlsConfig.sslPort));
        this.configAccumulator.put("ssl_provider", this.tlsConfig.getSslProvider());
        this.configAccumulator.put("jks_path", this.tlsConfig.getJksPath());
        this.configAccumulator.put("key_store_type", this.tlsConfig.getKeyStoreType());
        this.configAccumulator.put("key_store_password", this.tlsConfig.keyStorePassword);
        this.configAccumulator.put("key_manager_password", this.tlsConfig.keyManagerPassword);
        return this;
    }

    public IConfig build() {
        if (this.creationKind != CreationKind.API) {
            throw new IllegalStateException("Can't build a configuration started directly by the server, use startServer method instead");
        }
        return new MemoryConfig(this.configAccumulator);
    }

    public Server startServer() throws IOException {
        if (this.creationKind != CreationKind.SERVER) {
            throw new IllegalStateException("Can't start a sever from a configuration used in API mode, use build method instead");
        }
        this.server.startServer(new MemoryConfig(this.configAccumulator));
        return this.server;
    }

    public class TLSConfig {
        private SSLProvider providerType;
        private KeyStoreType keyStoreType;
        private String keyStorePassword;
        private String keyManagerPassword;
        private String jksPath;
        private int sslPort;

        private TLSConfig() {
        }

        public void port(int port) {
            this.sslPort = port;
            FluentConfig.validatePort(port);
        }

        public void sslProvider(SSLProvider providerType) {
            this.providerType = providerType;
        }

        public void jksPath(String jksPath) {
            this.jksPath = jksPath;
        }

        public void jksPath(Path jksPath) {
            this.jksPath(jksPath.toAbsolutePath().toString());
        }

        public void keyStoreType(KeyStoreType keyStoreType) {
            this.keyStoreType = keyStoreType;
        }

        public void keyStorePassword(String keyStorePassword) {
            this.keyStorePassword = keyStorePassword;
        }

        public void keyManagerPassword(String keyManagerPassword) {
            this.keyManagerPassword = keyManagerPassword;
        }

        private String getSslProvider() {
            return this.providerType.name().toLowerCase(Locale.ROOT);
        }

        private String getJksPath() {
            return this.jksPath;
        }

        private String getKeyStoreType() {
            return this.keyStoreType.name().toLowerCase(Locale.ROOT);
        }
    }

    private static enum CreationKind {
        API,
        SERVER;

    }

    public static enum KeyStoreType {
        JKS,
        JCEKS,
        PKCS12;

    }

    public static enum SSLProvider {
        SSL,
        OPENSSL,
        OPENSSL_REFCNT;

    }

    public static enum PersistentQueueType {
        H2,
        SEGMENTED;

    }

    public static enum BufferFlushKind {
        IMMEDIATE,
        FULL;

    }
}

