import { jsx as _jsx } from "react/jsx-runtime";
import { BeeTableHeaderVisibility, BeeTableOperation, generateUuid, } from "@kie-tools/boxed-expression-component/dist/api";
import { StandaloneBeeTable } from "@kie-tools/boxed-expression-component/dist/table/BeeTable/StandaloneBeeTable";
import { SelectionPart, useBeeTableCoordinates, useBeeTableSelectableCellRef, useBeeTableSelectionDispatch, } from "@kie-tools/boxed-expression-component/dist/selection/BeeTableSelectionContext";
import * as React from "react";
import { useCallback, useMemo, useReducer, useEffect, useRef, useState } from "react";
import "@kie-tools/boxed-expression-component/dist/@types/react-table";
import { ResizerStopBehavior } from "@kie-tools/boxed-expression-component/dist/resizing/ResizingWidthsContext";
import { AutoField } from "@kie-tools/uniforms-patternfly/dist/esm";
import { useField } from "uniforms";
import { AUTO_ROW_ID, DEFAULT_COLUMN_MIN_WIDTH, } from "../uniforms/UnitablesJsonSchemaBridge";
import getObjectValueByPath from "lodash/get";
import { useUnitablesContext, useUnitablesRow } from "../UnitablesContext";
import moment from "moment";
import { X_DMN_TYPE } from "@kie-tools/extended-services-api";
const LIST_ADD_WIDTH = 63;
const LIST_DEL_WIDTH = 61;
const NESTED_LIST_DEL_WIDTH = 63;
const LIST_IDX_WIDTH = 61;
export function UnitablesBeeTable({ id, i18n, columns, rows, scrollableParentRef, rowWrapper, onRowAdded, onRowDuplicated, onRowReset, onRowDeleted, configs, setWidth, bridge, }) {
    const beeTableOperationConfig = useMemo(() => [
        {
            group: i18n.terms.selection.toUpperCase(),
            items: [
                { name: i18n.terms.copy, type: BeeTableOperation.SelectionCopy },
                { name: i18n.terms.copy, type: BeeTableOperation.SelectionCut },
                { name: i18n.terms.copy, type: BeeTableOperation.SelectionPaste },
            ],
        },
        {
            group: i18n.rows,
            items: [
                { name: i18n.rowOperations.insertAbove, type: BeeTableOperation.RowInsertAbove },
                { name: i18n.rowOperations.insertBelow, type: BeeTableOperation.RowInsertBelow },
                { name: i18n.rowOperations.duplicate, type: BeeTableOperation.RowDuplicate },
                { name: i18n.rowOperations.reset, type: BeeTableOperation.RowReset },
                { name: i18n.rowOperations.delete, type: BeeTableOperation.RowDelete },
            ],
        },
    ], [i18n]);
    const allowedOperations = useCallback((conditions) => {
        var _a, _b;
        return [
            BeeTableOperation.SelectionCopy,
            ...(((_b = (_a = conditions.selection.active) === null || _a === void 0 ? void 0 : _a.rowIndex) !== null && _b !== void 0 ? _b : -1) > -1
                ? [
                    BeeTableOperation.SelectionCut,
                    BeeTableOperation.SelectionPaste,
                    BeeTableOperation.RowInsertAbove,
                    BeeTableOperation.RowInsertBelow,
                    BeeTableOperation.RowDuplicate,
                    BeeTableOperation.RowReset,
                ]
                : []),
            ...(rows.length > 1 ? [BeeTableOperation.RowDelete] : []),
        ];
    }, [rows.length]);
    const uuid = useMemo(() => {
        return generateUuid();
    }, []);
    const columnsCount = useMemo(() => columns.reduce((acc, column) => acc + (column.insideProperties ? column.insideProperties.length : 1), 1), [columns]);
    const cellComponentByColumnAccessor = React.useMemo(() => {
        return columns.reduce((acc, column) => {
            if (column.insideProperties) {
                for (const insideProperty of column.insideProperties) {
                    acc[getColumnAccessor(insideProperty)] = (props) => (_jsx(UnitablesBeeTableCell, { ...props, joinedName: insideProperty.joinedName, rowCount: rows.length, columnCount: columnsCount }));
                }
            }
            else {
                acc[getColumnAccessor(column)] = (props) => (_jsx(UnitablesBeeTableCell, { ...props, joinedName: column.joinedName, rowCount: rows.length, columnCount: columnsCount }));
            }
            return acc;
        }, {});
    }, [columns, rows.length, columnsCount]);
    const setColumnWidth = useCallback((fieldName) => (newWidthAction) => {
        const newWidth = typeof newWidthAction === "function" ? newWidthAction(0) : newWidthAction;
        setWidth(newWidth !== null && newWidth !== void 0 ? newWidth : 0, fieldName);
        return newWidth;
    }, [setWidth]);
    const recursiveCalculateListFieldWidth = useCallback((columnName, row) => {
        const field = bridge.getField(columnName);
        const listInput = getObjectValueByPath(row, columnName);
        if (listInput && Array.isArray(listInput)) {
            if (listInput.length === 0) {
                return DEFAULT_COLUMN_MIN_WIDTH;
            }
            return listInput.reduce((length, _, index) => {
                if (field.items.properties) {
                    return (LIST_IDX_WIDTH +
                        Object.entries(field.items.properties).reduce((length, [fieldKey, fieldProperty]) => {
                            if (fieldProperty.type === "array") {
                                return (length +
                                    LIST_ADD_WIDTH +
                                    recursiveCalculateListFieldWidth(`${columnName}.${index}.${fieldKey}`, row) +
                                    1);
                            }
                            return length + bridge.getFieldDataType(fieldProperty).width + 1;
                        }, length) +
                        NESTED_LIST_DEL_WIDTH);
                }
                return LIST_IDX_WIDTH + length + bridge.getFieldDataType(field.items).width + NESTED_LIST_DEL_WIDTH;
            }, 0);
        }
        if (listInput === undefined) {
            return DEFAULT_COLUMN_MIN_WIDTH;
        }
        return bridge.getFieldDataType(field).width + LIST_DEL_WIDTH;
    }, [bridge]);
    const calculateListFieldWidth = useCallback((columnName) => {
        return rows.reduce((width, row) => {
            const rowWidth = LIST_ADD_WIDTH + recursiveCalculateListFieldWidth(columnName, row);
            if (rowWidth > width) {
                return rowWidth;
            }
            return width;
        }, 0);
    }, [recursiveCalculateListFieldWidth, rows]);
    const beeTableColumns = useMemo(() => {
        return columns.map((column) => {
            var _a, _b;
            if (column.insideProperties) {
                return {
                    originalId: uuid + `field-${column.name}`,
                    label: column.name,
                    accessor: getColumnAccessor(column),
                    dataType: column.dataType,
                    isRowIndexColumn: false,
                    width: undefined,
                    columns: column.insideProperties.flatMap((insideProperty) => {
                        var _a, _b, _c;
                        let minWidth = (_a = insideProperty.minWidth) !== null && _a !== void 0 ? _a : insideProperty.width;
                        let width = (_c = (_b = getObjectValueByPath(configs, insideProperty.joinedName)) === null || _b === void 0 ? void 0 : _b.width) !== null && _c !== void 0 ? _c : DEFAULT_COLUMN_MIN_WIDTH;
                        if (insideProperty.type === "array") {
                            width = calculateListFieldWidth(insideProperty.joinedName);
                            minWidth = calculateListFieldWidth(insideProperty.joinedName);
                        }
                        return {
                            originalId: uuid + `field-${insideProperty.joinedName}`,
                            label: insideProperty.name,
                            accessor: getColumnAccessor(insideProperty),
                            dataType: insideProperty.dataType,
                            isRowIndexColumn: false,
                            width,
                            setWidth: setColumnWidth(insideProperty.joinedName),
                            minWidth,
                        };
                    }),
                };
            }
            else {
                let minWidth = column.width;
                let width = (_b = (_a = getObjectValueByPath(configs, column.name)) === null || _a === void 0 ? void 0 : _a.width) !== null && _b !== void 0 ? _b : column.width;
                if (column.type === "array") {
                    width = calculateListFieldWidth(column.joinedName);
                    minWidth = calculateListFieldWidth(column.joinedName);
                }
                return {
                    originalId: uuid + `field-${column.name}-parent`,
                    label: "",
                    accessor: getColumnAccessor(column) + "-parent",
                    dataType: undefined,
                    isRowIndexColumn: false,
                    width: undefined,
                    columns: [
                        {
                            originalId: uuid + `field-${column.name}`,
                            label: column.name,
                            accessor: getColumnAccessor(column),
                            dataType: column.dataType,
                            isRowIndexColumn: false,
                            width,
                            setWidth: setColumnWidth(column.name),
                            minWidth,
                        },
                    ],
                };
            }
        });
    }, [columns, uuid, configs, setColumnWidth, calculateListFieldWidth]);
    const getColumnKey = useCallback((column) => {
        var _a;
        return (_a = column.originalId) !== null && _a !== void 0 ? _a : column.id;
    }, []);
    const getRowKey = useCallback((row) => {
        return row.original.id;
    }, []);
    return (_jsx(StandaloneBeeTable, { cellComponentByColumnAccessor: cellComponentByColumnAccessor, scrollableParentRef: scrollableParentRef, getColumnKey: getColumnKey, getRowKey: getRowKey, tableId: id, isEditableHeader: false, headerLevelCountForAppendingRowIndexColumn: 1, headerVisibility: BeeTableHeaderVisibility.AllLevels, operationConfig: beeTableOperationConfig, allowedOperations: allowedOperations, columns: beeTableColumns, rows: rows, enableKeyboardNavigation: true, shouldRenderRowIndexColumn: true, shouldShowRowsInlineControls: true, shouldShowColumnsInlineControls: false, onRowAdded: onRowAdded, onRowDuplicated: onRowDuplicated, onRowReset: onRowReset, onRowDeleted: onRowDeleted, rowWrapper: rowWrapper, resizerStopBehavior: ResizerStopBehavior.SET_WIDTH_ALWAYS }));
}
function getColumnAccessor(c) {
    return `field-${c.joinedName}`;
}
function UnitablesBeeTableCell({ joinedName, rowCount, columnCount, }) {
    var _a, _b, _c, _d;
    const [{ field, onChange: onFieldChange, name: fieldName }] = useField(joinedName, {});
    const cellRef = useRef(null);
    const [autoFieldKey, forceUpdate] = useReducer((x) => x + 1, 0);
    const { containerCellCoordinates } = useBeeTableCoordinates();
    const { isBeeTableChange } = useUnitablesContext();
    const { submitRow, rowInputs } = useUnitablesRow((_a = containerCellCoordinates === null || containerCellCoordinates === void 0 ? void 0 : containerCellCoordinates.rowIndex) !== null && _a !== void 0 ? _a : 0);
    const fieldInput = useMemo(() => getObjectValueByPath(rowInputs, fieldName), [rowInputs, fieldName]);
    const [isSelectFieldOpen, setIsSelectFieldOpen] = useState(false);
    const fieldCharacteristics = useMemo(() => {
        if (!field) {
            return;
        }
        return {
            xDmnType: field["x-dmn-type"],
            isEnum: !!field.enum,
            isList: field.type === "array",
        };
    }, [field]);
    const previousFieldInput = useRef(fieldInput);
    useEffect(() => {
        previousFieldInput.current = fieldInput;
    }, [fieldInput]);
    const setValue = useCallback((newValue) => {
        var _a;
        isBeeTableChange.current = true;
        const newValueWithoutSymbols = (_a = newValue === null || newValue === void 0 ? void 0 : newValue.replace(/\r/g, "")) !== null && _a !== void 0 ? _a : "";
        if (field.enum) {
            if (field.enum.findIndex((value) => value === newValueWithoutSymbols) >= 0) {
                onFieldChange(newValueWithoutSymbols);
            }
            else {
                onFieldChange(field.placeholder);
            }
            forceUpdate();
        }
        else if (field.type === "string") {
            if (field.format === "time") {
                if (moment(newValueWithoutSymbols, [moment.HTML5_FMT.TIME, moment.HTML5_FMT.TIME_SECONDS], true).isValid()) {
                    onFieldChange(newValueWithoutSymbols);
                }
                else {
                    onFieldChange("");
                }
            }
            else if (field.format === "date") {
                if (moment(newValueWithoutSymbols, [moment.HTML5_FMT.DATE]).isValid()) {
                    onFieldChange(newValueWithoutSymbols);
                }
                else {
                    onFieldChange("");
                }
            }
            else if (field.format === "date-time") {
                const valueAsNumber = Date.parse(newValueWithoutSymbols);
                if (!isNaN(valueAsNumber)) {
                    onFieldChange(newValueWithoutSymbols);
                }
                else {
                    onFieldChange("");
                }
            }
            else {
                onFieldChange(newValueWithoutSymbols);
            }
        }
        else if (field.type === "number") {
            const numberValue = parseFloat(newValueWithoutSymbols);
            onFieldChange(isNaN(numberValue) ? undefined : numberValue);
        }
        else if (field.type === "boolean") {
            onFieldChange(newValueWithoutSymbols === "true");
        }
        else if (field.type === "array") {
        }
        else if (field.type === "object" && typeof newValue !== "object") {
        }
        else {
            onFieldChange(newValue);
        }
        submitRow();
    }, [isBeeTableChange, field.enum, field.type, field.placeholder, field.format, submitRow, onFieldChange]);
    const { isActive, isEditing } = useBeeTableSelectableCellRef((_b = containerCellCoordinates === null || containerCellCoordinates === void 0 ? void 0 : containerCellCoordinates.rowIndex) !== null && _b !== void 0 ? _b : 0, (_c = containerCellCoordinates === null || containerCellCoordinates === void 0 ? void 0 : containerCellCoordinates.columnIndex) !== null && _c !== void 0 ? _c : 0, setValue, useCallback(() => `${fieldInput !== null && fieldInput !== void 0 ? fieldInput : ""}`, [fieldInput]));
    const { mutateSelection } = useBeeTableSelectionDispatch();
    const navigateVertically = useCallback((args) => {
        mutateSelection({
            part: SelectionPart.ActiveCell,
            columnCount: () => columnCount,
            rowCount,
            deltaColumns: 0,
            deltaRows: args.isShiftPressed ? -1 : 1,
            isEditingActiveCell: false,
            keepInsideSelection: true,
        });
    }, [mutateSelection, rowCount, columnCount]);
    const setEditingCell = useCallback((isEditing) => {
        mutateSelection({
            part: SelectionPart.ActiveCell,
            columnCount: () => columnCount,
            rowCount,
            deltaColumns: 0,
            deltaRows: 0,
            isEditingActiveCell: isEditing,
            keepInsideSelection: true,
        });
    }, [mutateSelection, rowCount, columnCount]);
    const onKeyDown = useCallback((e) => {
        var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s, _t, _u, _v, _w, _x, _y, _z;
        if (e.key.toLowerCase() === "tab") {
            if (fieldCharacteristics === null || fieldCharacteristics === void 0 ? void 0 : fieldCharacteristics.isList) {
                const uniformsComponents = (_a = cellRef.current) === null || _a === void 0 ? void 0 : _a.querySelectorAll('[id^="uniforms-"]');
                if (uniformsComponents === undefined) {
                    setEditingCell(false);
                    return;
                }
                const uniformComponentTargetIndex = Array.from(uniformsComponents !== null && uniformsComponents !== void 0 ? uniformsComponents : []).findIndex((component) => component.id === e.target.id);
                if (uniformComponentTargetIndex < 0) {
                    (_b = (uniformsComponents === null || uniformsComponents === void 0 ? void 0 : uniformsComponents.item(1)).parentElement) === null || _b === void 0 ? void 0 : _b.focus();
                    setEditingCell(true);
                    e.stopPropagation();
                    return;
                }
                const nextUniformsComponent = e.shiftKey
                    ? uniformsComponents[uniformComponentTargetIndex - 1]
                    : uniformsComponents[uniformComponentTargetIndex + 1];
                if (nextUniformsComponent === undefined) {
                    setEditingCell(false);
                    return;
                }
                if (nextUniformsComponent.tagName.toLowerCase() === "input" ||
                    nextUniformsComponent.tagName.toLowerCase() === "button") {
                    (_c = nextUniformsComponent.parentElement) === null || _c === void 0 ? void 0 : _c.focus();
                    setEditingCell(true);
                    submitRow();
                    e.stopPropagation();
                    return;
                }
                if (nextUniformsComponent.tagName.toLowerCase() === "div") {
                    nextUniformsComponent === null || nextUniformsComponent === void 0 ? void 0 : nextUniformsComponent.focus();
                    setEditingCell(true);
                    submitRow();
                    e.stopPropagation();
                    return;
                }
            }
            submitRow();
            setEditingCell(false);
            if (fieldCharacteristics === null || fieldCharacteristics === void 0 ? void 0 : fieldCharacteristics.isEnum) {
                setIsSelectFieldOpen((prev) => {
                    var _a, _b, _c;
                    if (prev) {
                        (_c = (_b = (_a = cellRef.current) === null || _a === void 0 ? void 0 : _a.getElementsByTagName("button")) === null || _b === void 0 ? void 0 : _b[0]) === null || _c === void 0 ? void 0 : _c.click();
                    }
                    return false;
                });
            }
            return;
        }
        if (e.key.toLowerCase() === "escape") {
            e.stopPropagation();
            onFieldChange(previousFieldInput.current);
            (_d = cellRef.current) === null || _d === void 0 ? void 0 : _d.focus();
            setEditingCell(false);
            if (fieldCharacteristics === null || fieldCharacteristics === void 0 ? void 0 : fieldCharacteristics.isEnum) {
                setIsSelectFieldOpen((prev) => {
                    var _a, _b, _c;
                    if (prev) {
                        (_c = (_b = (_a = cellRef.current) === null || _a === void 0 ? void 0 : _a.getElementsByTagName("button")) === null || _b === void 0 ? void 0 : _b[0]) === null || _c === void 0 ? void 0 : _c.click();
                    }
                    return false;
                });
            }
            return;
        }
        if (e.key.toLowerCase() === "enter") {
            if (fieldCharacteristics === null || fieldCharacteristics === void 0 ? void 0 : fieldCharacteristics.isList) {
                e.stopPropagation();
                e.preventDefault();
                const uniformsComponents = (_e = cellRef.current) === null || _e === void 0 ? void 0 : _e.querySelectorAll('[id^="uniforms-"]');
                if (!uniformsComponents) {
                    return;
                }
                const reversedUniformsComponents = Array.from(uniformsComponents).reverse();
                const reversedUniformComponentTargetIndex = reversedUniformsComponents.findIndex((component) => component.contains(e.target));
                const uniformsComponent = reversedUniformsComponents[reversedUniformComponentTargetIndex];
                if (!uniformsComponent) {
                    const selectFieldUl = (_f = document.querySelectorAll(`ul[name^="${fieldName}."]`)) === null || _f === void 0 ? void 0 : _f.item(0);
                    if (selectFieldUl && selectFieldUl.contains(e.target)) {
                        setIsSelectFieldOpen(false);
                        submitRow();
                        (_k = (_j = (_h = (_g = cellRef.current) === null || _g === void 0 ? void 0 : _g.querySelector(`[id=${selectFieldUl.id}]`)) === null || _h === void 0 ? void 0 : _h.getElementsByTagName("button")) === null || _j === void 0 ? void 0 : _j.item(0)) === null || _k === void 0 ? void 0 : _k.focus();
                    }
                    else if (uniformsComponents[1].tagName.toLowerCase() === "button") {
                        (_l = uniformsComponents[1]) === null || _l === void 0 ? void 0 : _l.focus();
                    }
                }
                else {
                    if (uniformsComponent.tagName.toLowerCase() === "button") {
                        uniformsComponent === null || uniformsComponent === void 0 ? void 0 : uniformsComponent.click();
                        if (reversedUniformComponentTargetIndex === 0) {
                            if (uniformsComponents[1].tagName.toLowerCase() === "button") {
                                (_m = uniformsComponents[1]) === null || _m === void 0 ? void 0 : _m.focus();
                            }
                        }
                        submitRow();
                    }
                    if (uniformsComponent.tagName.toLowerCase() === "div") {
                        setIsSelectFieldOpen(true);
                    }
                }
                return;
            }
            e.stopPropagation();
            if (fieldCharacteristics === null || fieldCharacteristics === void 0 ? void 0 : fieldCharacteristics.isEnum) {
                (_q = (_p = (_o = cellRef.current) === null || _o === void 0 ? void 0 : _o.getElementsByTagName("button")) === null || _p === void 0 ? void 0 : _p[0]) === null || _q === void 0 ? void 0 : _q.click();
                setIsSelectFieldOpen((prev) => {
                    if (prev === true) {
                        submitRow();
                    }
                    return !prev;
                });
                setEditingCell(!isEditing);
                return;
            }
            if (!isEditing) {
                const inputField = (_r = cellRef.current) === null || _r === void 0 ? void 0 : _r.getElementsByTagName("input");
                if (inputField && inputField.length > 0) {
                    (_s = inputField === null || inputField === void 0 ? void 0 : inputField[0]) === null || _s === void 0 ? void 0 : _s.focus();
                    setEditingCell(true);
                    return;
                }
            }
            submitRow();
            setEditingCell(false);
            navigateVertically({ isShiftPressed: e.shiftKey });
            return;
        }
        if (isEditModeTriggeringKey(e)) {
            e.stopPropagation();
            setEditingCell(true);
            if (!(fieldCharacteristics === null || fieldCharacteristics === void 0 ? void 0 : fieldCharacteristics.isList) &&
                !isEditing &&
                e.target.tagName.toLowerCase() !== "input") {
                const inputField = (_u = (_t = cellRef.current) === null || _t === void 0 ? void 0 : _t.getElementsByTagName("input")) === null || _u === void 0 ? void 0 : _u[0];
                if (e.code.toLowerCase() === "space" && (fieldCharacteristics === null || fieldCharacteristics === void 0 ? void 0 : fieldCharacteristics.xDmnType) === X_DMN_TYPE.BOOLEAN) {
                    inputField === null || inputField === void 0 ? void 0 : inputField.click();
                    submitRow();
                    return;
                }
                inputField === null || inputField === void 0 ? void 0 : inputField.select();
            }
            if (fieldCharacteristics === null || fieldCharacteristics === void 0 ? void 0 : fieldCharacteristics.isList) {
                if (e.code.toLowerCase() === "space" &&
                    ((_w = (_v = e.target) === null || _v === void 0 ? void 0 : _v.tagName) === null || _w === void 0 ? void 0 : _w.toLowerCase()) === "input" &&
                    ((_x = e.target) === null || _x === void 0 ? void 0 : _x.type) === "checkbox") {
                    e.preventDefault();
                    e.target.click();
                    submitRow();
                    return;
                }
                if (e.code.toLowerCase() === "space" && ((_z = (_y = e.target) === null || _y === void 0 ? void 0 : _y.tagName) === null || _z === void 0 ? void 0 : _z.toLowerCase()) === "button") {
                    e.preventDefault();
                    if (e.target.id.match(/^uniforms-/g)) {
                        return;
                    }
                    setIsSelectFieldOpen(true);
                    return;
                }
            }
        }
        if (isEditing) {
            e.stopPropagation();
        }
    }, [isEditing, submitRow, setEditingCell, fieldCharacteristics, onFieldChange, navigateVertically, fieldName]);
    useEffect(() => {
        var _a, _b;
        if (!isActive) {
            return;
        }
        if (fieldCharacteristics === null || fieldCharacteristics === void 0 ? void 0 : fieldCharacteristics.isList) {
            if (isSelectFieldOpen) {
                setTimeout(() => {
                    var _a, _b, _c, _d;
                    (_d = (_c = (_b = (_a = document.querySelectorAll(`ul[name^="${fieldName}."]`)) === null || _a === void 0 ? void 0 : _a[0]) === null || _b === void 0 ? void 0 : _b.getElementsByTagName("button")) === null || _c === void 0 ? void 0 : _c.item(0)) === null || _d === void 0 ? void 0 : _d.focus();
                }, 0);
            }
        }
        else if (fieldCharacteristics === null || fieldCharacteristics === void 0 ? void 0 : fieldCharacteristics.isEnum) {
            if (isSelectFieldOpen) {
                setTimeout(() => {
                    var _a, _b, _c, _d, _e;
                    const selectOptions = (_b = (_a = document.getElementsByName(fieldName)) === null || _a === void 0 ? void 0 : _a[0]) === null || _b === void 0 ? void 0 : _b.getElementsByTagName("button");
                    (_e = (_d = (_c = Array.from(selectOptions !== null && selectOptions !== void 0 ? selectOptions : [])) === null || _c === void 0 ? void 0 : _c.filter((selectOption) => { var _a; return selectOption.innerText === ((_a = cellRef.current) === null || _a === void 0 ? void 0 : _a.innerText); })) === null || _d === void 0 ? void 0 : _d[0]) === null || _e === void 0 ? void 0 : _e.focus();
                }, 0);
            }
            else {
                (_a = cellRef.current) === null || _a === void 0 ? void 0 : _a.focus();
            }
        }
        if (!isEditing) {
            (_b = cellRef.current) === null || _b === void 0 ? void 0 : _b.focus();
        }
    }, [fieldName, isActive, isEditing, fieldCharacteristics === null || fieldCharacteristics === void 0 ? void 0 : fieldCharacteristics.isList, fieldCharacteristics === null || fieldCharacteristics === void 0 ? void 0 : fieldCharacteristics.isEnum, isSelectFieldOpen]);
    const onBlur = useCallback((e) => {
        var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l;
        if (fieldCharacteristics === null || fieldCharacteristics === void 0 ? void 0 : fieldCharacteristics.isList) {
            if (e.target.tagName.toLowerCase() === "button" &&
                ((_a = e.relatedTarget) === null || _a === void 0 ? void 0 : _a.tagName.toLowerCase()) === "button") {
                const selectFieldUl = document.querySelectorAll(`ul[name^="${fieldName}."]`).item(0);
                if (selectFieldUl && !(selectFieldUl === null || selectFieldUl === void 0 ? void 0 : selectFieldUl.contains(e.relatedTarget))) {
                    (_c = (_b = cellRef.current) === null || _b === void 0 ? void 0 : _b.querySelector(`[id="${selectFieldUl === null || selectFieldUl === void 0 ? void 0 : selectFieldUl.id}"]`)) === null || _c === void 0 ? void 0 : _c.click();
                    setIsSelectFieldOpen(false);
                }
            }
            submitRow();
            return;
        }
        if (e.target.tagName.toLowerCase() === "div") {
            if (((_e = (_d = e.target.getElementsByTagName("input")) === null || _d === void 0 ? void 0 : _d.length) !== null && _e !== void 0 ? _e : 0) > 0) {
                submitRow();
            }
        }
        if (e.target.tagName.toLowerCase() === "input") {
            submitRow();
        }
        if (e.target.tagName.toLowerCase() === "button" ||
            ((_f = e.relatedTarget) === null || _f === void 0 ? void 0 : _f.tagName.toLowerCase()) === "button") {
            const selectOptions = (_h = (_g = document.getElementsByName(fieldName)) === null || _g === void 0 ? void 0 : _g[0]) === null || _h === void 0 ? void 0 : _h.getElementsByTagName("button");
            if (((_j = selectOptions === null || selectOptions === void 0 ? void 0 : selectOptions.length) !== null && _j !== void 0 ? _j : 0) > 0 && ((_l = (_k = e.relatedTarget) === null || _k === void 0 ? void 0 : _k.tagName) === null || _l === void 0 ? void 0 : _l.toLowerCase()) === "td") {
                e.target.click();
                setIsSelectFieldOpen(false);
            }
            submitRow();
        }
    }, [fieldName, fieldCharacteristics === null || fieldCharacteristics === void 0 ? void 0 : fieldCharacteristics.isList, submitRow]);
    const onClick = useCallback((e) => {
        var _a, _b;
        if (e.detail === 0) {
            return;
        }
        if (e.isTrusted &&
            (fieldCharacteristics === null || fieldCharacteristics === void 0 ? void 0 : fieldCharacteristics.isList) &&
            (e.target.tagName.toLowerCase() === "path" ||
                e.target.tagName.toLowerCase() === "svg" ||
                e.target.tagName.toLowerCase() === "button")) {
            const selectField = document.querySelectorAll(`ul[name^="${fieldName}."]`).item(0);
            if (selectField === null || selectField === void 0 ? void 0 : selectField.contains(e.target)) {
                setIsSelectFieldOpen((prev) => !prev);
            }
            submitRow();
            return;
        }
        if (e.isTrusted && e.target.tagName.toLowerCase() === "button") {
            setIsSelectFieldOpen((prev) => {
                if (prev === true) {
                    submitRow();
                }
                return !prev;
            });
            setEditingCell(!isEditing);
        }
        if (!isEditing && e.isTrusted && e.target.tagName.toLowerCase() === "input") {
            const inputField = (_a = cellRef.current) === null || _a === void 0 ? void 0 : _a.getElementsByTagName("input");
            if (inputField && inputField.length > 0) {
                (_b = inputField === null || inputField === void 0 ? void 0 : inputField[0]) === null || _b === void 0 ? void 0 : _b.focus();
                setEditingCell(true);
                return;
            }
        }
    }, [fieldName, isEditing, fieldCharacteristics === null || fieldCharacteristics === void 0 ? void 0 : fieldCharacteristics.isList, setEditingCell, submitRow]);
    return (_jsx("div", { style: { outline: "none" }, tabIndex: -1, ref: cellRef, onKeyDown: onKeyDown, onBlur: onBlur, onClick: onClick, children: _jsx(AutoField, { name: joinedName, form: `${AUTO_ROW_ID}-${(_d = containerCellCoordinates === null || containerCellCoordinates === void 0 ? void 0 : containerCellCoordinates.rowIndex) !== null && _d !== void 0 ? _d : 0}`, style: { height: "60px" } }, joinedName + autoFieldKey) }));
}
function isEditModeTriggeringKey(e) {
    if (e.altKey || e.ctrlKey || e.metaKey) {
        return false;
    }
    return /^[\d\w ()[\]{},.\-_'"/?<>+\\|]$/.test(e.key);
}
//# sourceMappingURL=UnitablesBeeTable.js.map