import { jsx as _jsx } from "react/jsx-runtime";
import { useMemo } from "react";
import TaskInboxContext from "./TaskInboxContext";
import { TaskInboxGatewayApiImpl } from "./TaskInboxGatewayApi";
import { GraphQLTaskInboxQueries } from "./TaskInboxQueries";
import { useKogitoAppContext } from "@kie-tools/runtime-tools-components/dist/contexts/KogitoAppContext";
export const TaskInboxContextProvider = ({ apolloClient, children }) => {
    const appContext = useKogitoAppContext();
    const gatewayApi = useMemo(() => new TaskInboxGatewayApiImpl(new GraphQLTaskInboxQueries(apolloClient), () => appContext.getCurrentUser()), [apolloClient, appContext]);
    return _jsx(TaskInboxContext.Provider, { value: gatewayApi, children: children });
};
export default TaskInboxContextProvider;
//# sourceMappingURL=TaskInboxContextProvider.js.map