import { jsx as _jsx } from "react/jsx-runtime";
import { useEffect, useState } from "react";
import _ from "lodash";
import { generateFormData } from "../utils/TaskFormDataUtils";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
import { FormRenderer } from "@kie-tools/runtime-tools-components/dist/components/FormRenderer";
const TaskFormRenderer = ({ userTask, formData, formSchema, enabled, phases, submit, ouiaId, ouiaSafe, }) => {
    const [selectedPhase, setSelectedPhase] = useState();
    const [formActions, setFormActions] = useState([]);
    useEffect(() => {
        if (phases) {
            const actions = phases.map((phase) => {
                return {
                    name: phase,
                    execute: () => {
                        setSelectedPhase(phase);
                    },
                };
            });
            setFormActions(actions);
        }
    }, []);
    const isReadOnly = () => {
        if (!enabled || formActions.length === 0) {
            return true;
        }
        if (userTask.completed) {
            return true;
        }
        if (_.isEmpty(phases)) {
            return true;
        }
        return false;
    };
    const doSubmit = (data) => {
        submit(selectedPhase, data);
    };
    return (_jsx("div", { ...componentOuiaProps(ouiaId, "task-form-renderer", ouiaSafe), children: _jsx(FormRenderer, { formSchema: formSchema, model: formData || generateFormData(userTask), readOnly: isReadOnly(), onSubmit: doSubmit, formActions: formActions }) }));
};
export default TaskFormRenderer;
//# sourceMappingURL=TaskFormRenderer.js.map