import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import Moment from "react-moment";
import { Card, CardBody, CardHeader } from "@patternfly/react-core/dist/js/components/Card";
import { Button } from "@patternfly/react-core/dist/js/components/Button";
import { Title } from "@patternfly/react-core/dist/js/components/Title";
import { Form, FormGroup } from "@patternfly/react-core/dist/js/components/Form";
import { Text, TextVariants } from "@patternfly/react-core/dist/js/components/Text";
import { LevelDownAltIcon } from "@patternfly/react-icons/dist/js/icons/level-down-alt-icon";
import { LevelUpAltIcon } from "@patternfly/react-icons/dist/js/icons/level-up-alt-icon";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
import { ProcessInstanceIconCreator, getProcessInstanceDescription, } from "../../../../processList/envelope/components/utils/ProcessListUtils";
import { EndpointLink } from "@kie-tools/runtime-tools-components/dist/components/EndpointLink";
import { ItemDescriptor } from "@kie-tools/runtime-tools-components/dist/components/ItemDescriptor";
const ProcessDetailsPanel = ({ processInstance, driver, ouiaId, ouiaSafe }) => {
    return (_jsxs(Card, { ...componentOuiaProps(ouiaId ? ouiaId : processInstance.id, "process-details", ouiaSafe), children: [_jsx(CardHeader, { children: _jsx(Title, { headingLevel: "h3", size: "xl", children: "Details" }) }), _jsx(CardBody, { children: _jsxs(Form, { children: [_jsx(FormGroup, { label: "Name", fieldId: "name", children: _jsx(Text, { component: TextVariants.p, children: processInstance.processName }) }), processInstance.businessKey && (_jsx(FormGroup, { label: "Business key", fieldId: "businessKey", children: _jsx(Text, { component: TextVariants.p, children: processInstance.businessKey }) })), _jsx(FormGroup, { label: "State", fieldId: "state", children: _jsx(Text, { component: TextVariants.p, children: ProcessInstanceIconCreator(processInstance.state) }) }), _jsx(FormGroup, { label: "Id", fieldId: "id", children: _jsx(Text, { component: TextVariants.p, className: "kogito-management-console--u-WordBreak", children: processInstance.id }) }), processInstance.serviceUrl ? (_jsx(FormGroup, { label: "Endpoint", fieldId: "endpoint", children: _jsx(Text, { component: TextVariants.p, className: "kogito-management-console--u-WordBreak", children: _jsx(EndpointLink, { serviceUrl: processInstance.serviceUrl, isLinkShown: true }) }) })) : (""), _jsx(FormGroup, { label: "Start", fieldId: "start", children: processInstance.start ? (_jsx(Text, { component: TextVariants.p, children: _jsx(Moment, { fromNow: true, children: new Date(`${processInstance.start}`) }) })) : ("") }), processInstance.lastUpdate && (_jsx(FormGroup, { label: "Last Updated", fieldId: "lastUpdate", children: _jsx(Text, { component: TextVariants.p, children: _jsx(Moment, { fromNow: true, children: new Date(`${processInstance.lastUpdate}`) }) }) })), processInstance.end && (_jsx(FormGroup, { label: "End", fieldId: "end", children: _jsx(Text, { component: TextVariants.p, children: _jsx(Moment, { fromNow: true, children: new Date(`${processInstance.end}`) }) }) })), processInstance.parentProcessInstance !== null && (_jsx(FormGroup, { label: "Parent Process", fieldId: "parent", children: _jsx("div", { children: _jsx(Button, { "data-testid": "open-parent-process", variant: "link", icon: _jsx(LevelUpAltIcon, {}), onClick: () => {
                                        driver.openProcessInstanceDetails(processInstance.parentProcessInstance.id);
                                    }, ...componentOuiaProps(ouiaId ? ouiaId : processInstance.parentProcessInstance.id, "process-details", ouiaSafe), children: _jsx(ItemDescriptor, { itemDescription: getProcessInstanceDescription(processInstance.parentProcessInstance) }) }) }) })), processInstance.childProcessInstances && processInstance.childProcessInstances.length !== 0 && (_jsx(FormGroup, { label: "Sub Processes", fieldId: "child", children: processInstance.childProcessInstances.map((child) => (_jsx("div", { children: _jsx(Button, { variant: "link", icon: _jsx(LevelDownAltIcon, {}), onClick: () => {
                                        driver.openProcessInstanceDetails(child.id);
                                    }, ...componentOuiaProps(ouiaId ? ouiaId : child.id, "process-details", ouiaSafe), children: _jsx(ItemDescriptor, { itemDescription: getProcessInstanceDescription(child) }) }) }, child.id))) }))] }) })] }));
};
export default ProcessDetailsPanel;
//# sourceMappingURL=ProcessDetailsPanel.js.map