import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import React, { useState } from "react";
import { ToolbarFilter, ToolbarGroup, ToolbarItem, ToolbarToggleGroup, Toolbar, ToolbarContent, } from "@patternfly/react-core/dist/js/components/Toolbar";
import { Button } from "@patternfly/react-core/dist/js/components/Button";
import { Tooltip } from "@patternfly/react-core/dist/js/components/Tooltip";
import { TextInput } from "@patternfly/react-core/dist/js/components/TextInput";
import { InputGroup } from "@patternfly/react-core/dist/js/components/InputGroup";
import { FilterIcon } from "@patternfly/react-icons/dist/js/icons/filter-icon";
import { SyncIcon } from "@patternfly/react-icons/dist/js/icons/sync-icon";
import _ from "lodash";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
var Category;
(function (Category) {
    Category["CUSTOM_DASHBOARD_NAME"] = "Custom Dashboard name";
})(Category || (Category = {}));
const CustomDashboardListToolbar = ({ applyFilter, filterDashboardNames, setFilterDashboardNames, ouiaSafe, ouiaId, }) => {
    const [dashboardNameInput, setDashboardNameInput] = useState("");
    const doResetFilter = () => {
        applyFilter({
            customDashboardNames: [],
        });
        setFilterDashboardNames([]);
    };
    const doRefresh = () => {
        applyFilter({
            customDashboardNames: [...filterDashboardNames],
        });
    };
    const onEnterClicked = (event) => {
        if (event.key === "Enter") {
            dashboardNameInput.length > 0 && doApplyFilter();
        }
    };
    const onDeleteFilterGroup = (categoryName, value) => {
        const newFilterDashboardNames = [...filterDashboardNames];
        if (categoryName === Category.CUSTOM_DASHBOARD_NAME) {
            _.remove(newFilterDashboardNames, (status) => {
                return status === value;
            });
            setFilterDashboardNames(newFilterDashboardNames);
            applyFilter({
                customDashboardNames: newFilterDashboardNames,
            });
        }
    };
    const doApplyFilter = () => {
        const newDashboardNames = [...filterDashboardNames];
        if (dashboardNameInput && !newDashboardNames.includes(dashboardNameInput)) {
            newDashboardNames.push(dashboardNameInput);
            setFilterDashboardNames(newDashboardNames);
        }
        setDashboardNameInput("");
        applyFilter({
            customDashboardNames: newDashboardNames,
        });
    };
    const toggleGroupItems = (_jsx(React.Fragment, { children: _jsxs(ToolbarGroup, { variant: "filter-group", children: [_jsx(ToolbarFilter, { chips: filterDashboardNames, deleteChip: onDeleteFilterGroup, categoryName: Category.CUSTOM_DASHBOARD_NAME, children: _jsx(InputGroup, { children: _jsx(TextInput, { name: "customDashboardName", id: "customDashboardName", type: "search", "aria-label": "Dashboard name", onChange: setDashboardNameInput, onKeyPress: onEnterClicked, placeholder: "Filter by dashboard name", value: dashboardNameInput, "data-testid": "search-input" }) }) }, "input-customDashboard-name"), _jsx(ToolbarItem, { children: _jsx(Button, { id: "apply-filter", variant: "primary", onClick: doApplyFilter, "data-testid": "apply-filter", children: "Apply Filter" }) })] }) }));
    const toolbarItems = (_jsxs(React.Fragment, { children: [_jsx(ToolbarToggleGroup, { toggleIcon: _jsx(FilterIcon, {}), breakpoint: "xl", children: toggleGroupItems }), _jsx(ToolbarGroup, { variant: "icon-button-group", children: _jsx(ToolbarItem, { children: _jsx(Tooltip, { content: "Refresh", children: _jsx(Button, { variant: "plain", onClick: doRefresh, id: "refresh", "data-testid": "refresh", children: _jsx(SyncIcon, {}) }) }) }) })] }));
    return (_jsx(Toolbar, { id: "custom-dashboard-list-with-filter", className: "pf-m-toggle-group-container", collapseListedFiltersBreakpoint: "xl", clearAllFilters: doResetFilter, clearFiltersButtonText: "Reset to default", ...componentOuiaProps(ouiaId, "custom-dashboard-list-toolbar", ouiaSafe), children: _jsx(ToolbarContent, { children: toolbarItems }) }));
};
export default CustomDashboardListToolbar;
//# sourceMappingURL=CustomDashboardListToolbar.js.map