import { Node } from "./Node";
export class TokenTree {
    constructor() {
        this.root = new Node();
    }
    addName(tokens) {
        let current = this.root;
        for (const token of tokens) {
            let next = this.findToken(current, token);
            if (!next) {
                next = new Node(token, current);
                current.children.push(next);
            }
            current = next;
        }
    }
    findToken(current, t) {
        for (const n of current.children) {
            if (n.token === t) {
                return n;
            }
        }
        return undefined;
    }
    start(t) {
        this.currentNode = this.findToken(this.root, t);
    }
    followUp(t, commit) {
        if (this.currentNode == null) {
            return false;
        }
        const node = this.findToken(this.currentNode, t);
        if (commit) {
            this.currentNode = node;
        }
        return node != null;
    }
}
//# sourceMappingURL=TokenTree.js.map