export class PMMLObject {
    constructor(data) { }
}
export class Expression extends PMMLObject {
    constructor(data) {
        super(data);
    }
}
export class Aggregate extends Expression {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.field = data.field;
        this.function = data.function;
        this.groupField = data.groupField;
        this.sqlWhere = data.sqlWhere;
    }
}
export class Annotation extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
    }
}
export class Anova extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.AnovaRow = data.AnovaRow;
        this.target = data.target;
    }
}
export class AnovaRow extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.type = data.type;
        this.sumOfSquares = data.sumOfSquares;
        this.degreesOfFreedom = data.degreesOfFreedom;
        this.meanOfSquares = data.meanOfSquares;
        this.fValue = data.fValue;
        this.pValue = data.pValue;
    }
}
export class Distribution extends PMMLObject {
    constructor(data) {
        super(data);
    }
}
export class ContinuousDistribution extends Distribution {
    constructor(data) {
        super(data);
    }
}
export class AnyDistribution extends ContinuousDistribution {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.mean = data.mean;
        this.variance = data.variance;
    }
}
export class Application extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.name = data.name;
        this.version = data.version;
    }
}
export class Apply extends Expression {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.expressions = data.expressions;
        this.function = data.function;
        this.mapMissingTo = data.mapMissingTo;
        this.defaultValue = data.defaultValue;
        this.invalidValueTreatment = data.invalidValueTreatment;
    }
}
export class Array extends PMMLObject {
    constructor(data) {
        super(data);
        this.value = data.value;
        this.n = data.n;
        this.type = data.type;
    }
}
export class Measure extends PMMLObject {
    constructor(data) {
        super(data);
    }
}
export class Similarity extends Measure {
    constructor(data) {
        super(data);
    }
}
export class BinarySimilarity extends Similarity {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this["c00-parameter"] = data["c00-parameter"];
        this["c01-parameter"] = data["c01-parameter"];
        this["c10-parameter"] = data["c10-parameter"];
        this["c11-parameter"] = data["c11-parameter"];
        this["d00-parameter"] = data["d00-parameter"];
        this["d01-parameter"] = data["d01-parameter"];
        this["d10-parameter"] = data["d10-parameter"];
        this["d11-parameter"] = data["d11-parameter"];
    }
}
export class BlockIndicator extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.field = data.field;
    }
}
export class BoundaryValueMeans extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.Array = data.Array;
    }
}
export class BoundaryValues extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.Array = data.Array;
    }
}
export class Cell extends PMMLObject {
    constructor(data) {
        super(data);
        this.value = data.value;
    }
}
export class Distance extends Measure {
    constructor(data) {
        super(data);
    }
}
export class Chebychev extends Distance {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
    }
}
export class ChildParent extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.FieldColumnPair = data.FieldColumnPair;
        this.TableLocator = data.TableLocator;
        this.InlineTable = data.InlineTable;
        this.childField = data.childField;
        this.parentField = data.parentField;
        this.parentLevelField = data.parentLevelField;
        this.isRecursive = data.isRecursive;
    }
}
export class CityBlock extends Distance {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
    }
}
export class ClassLabels extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.Array = data.Array;
    }
}
export class ClusteringModelQuality extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.dataName = data.dataName;
        this.SSE = data.SSE;
        this.SSB = data.SSB;
    }
}
export class ComparisonField extends PMMLObject {
    constructor(data) {
        super(data);
    }
}
export class ComparisonMeasure extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.measure = data.measure;
        this.kind = data.kind;
        this.compareFunction = data.compareFunction;
        this.minimum = data.minimum;
        this.maximum = data.maximum;
    }
}
export class ComplexArray extends Array {
    constructor(data) {
        super(data);
    }
}
export class Predicate extends PMMLObject {
    constructor(data) {
        super(data);
    }
}
export class CompoundPredicate extends Predicate {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.predicates = data.predicates;
        this.booleanOperator = data.booleanOperator;
    }
}
export class ConfusionMatrix extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.ClassLabels = data.ClassLabels;
        this.Matrix = data.Matrix;
    }
}
export class Constant extends Expression {
    constructor(data) {
        super(data);
        this.value = data.value;
        this.dataType = data.dataType;
        this.missing = data.missing;
    }
}
export class ContStats extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.Interval = data.Interval;
        this.Array = data.Array;
        this.totalValuesSum = data.totalValuesSum;
        this.totalSquaresSum = data.totalSquaresSum;
    }
}
export class CorrelationFields extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.Array = data.Array;
    }
}
export class CorrelationMethods extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.Matrix = data.Matrix;
    }
}
export class CorrelationValues extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.Matrix = data.Matrix;
    }
}
export class Correlations extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.CorrelationFields = data.CorrelationFields;
        this.CorrelationValues = data.CorrelationValues;
        this.CorrelationMethods = data.CorrelationMethods;
    }
}
export class Counts extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.totalFreq = data.totalFreq;
        this.missingFreq = data.missingFreq;
        this.invalidFreq = data.invalidFreq;
        this.cardinality = data.cardinality;
    }
}
export class DataDictionary extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.DataField = data.DataField;
        this.Taxonomy = data.Taxonomy;
        this.numberOfFields = data.numberOfFields;
    }
}
export class Field extends PMMLObject {
    constructor(data) {
        super(data);
    }
}
export class DataField extends Field {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.Interval = data.Interval;
        this.Value = data.Value;
        this.name = data.name;
        this.displayName = data.displayName;
        this.optype = data.optype;
        this.dataType = data.dataType;
        this.taxonomy = data.taxonomy;
        this.isCyclic = data.isCyclic;
    }
}
export class Decision extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.value = data.value;
        this.displayValue = data.displayValue;
        this.description = data.description;
    }
}
export class Decisions extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.Decision = data.Decision;
        this.businessProblem = data.businessProblem;
        this.description = data.description;
    }
}
export class DefineFunction extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.ParameterField = data.ParameterField;
        this.expression = data.expression;
        this.name = data.name;
        this.optype = data.optype;
        this.dataType = data.dataType;
    }
}
export class DerivedField extends Field {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.expression = data.expression;
        this.Interval = data.Interval;
        this.Value = data.Value;
        this.name = data.name;
        this.displayName = data.displayName;
        this.optype = data.optype;
        this.dataType = data.dataType;
    }
}
export class DiscrStats extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.Array = data.Array;
        this.modalValue = data.modalValue;
    }
}
export class DiscreteDistribution extends Distribution {
    constructor(data) {
        super(data);
    }
}
export class Discretize extends Expression {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.DiscretizeBin = data.DiscretizeBin;
        this.field = data.field;
        this.mapMissingTo = data.mapMissingTo;
        this.defaultValue = data.defaultValue;
        this.dataType = data.dataType;
    }
}
export class DiscretizeBin extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.Interval = data.Interval;
        this.binValue = data.binValue;
    }
}
export class EmbeddedModel extends PMMLObject {
    constructor(data) {
        super(data);
    }
}
export class Entity extends PMMLObject {
    constructor(data) {
        super(data);
    }
}
export class Euclidean extends Distance {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
    }
}
export class Extension extends PMMLObject {
    constructor(data) {
        super(data);
        this.content = data.content;
        this.extender = data.extender;
        this.name = data.name;
        this.value = data.value;
    }
}
export class False extends Predicate {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
    }
}
export class FieldColumnPair extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.field = data.field;
        this.column = data.column;
    }
}
export class FieldRef extends Expression {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.field = data.field;
        this.mapMissingTo = data.mapMissingTo;
    }
}
export class GaussianDistribution extends ContinuousDistribution {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.mean = data.mean;
        this.variance = data.variance;
    }
}
export class Header extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.Application = data.Application;
        this.Annotation = data.Annotation;
        this.Timestamp = data.Timestamp;
        this.copyright = data.copyright;
        this.description = data.description;
        this.modelVersion = data.modelVersion;
    }
}
export class InlineTable extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.row = data.row;
    }
}
export class SparseArray extends PMMLObject {
    constructor(data) {
        super(data);
    }
}
export class IntSparseArray extends SparseArray {
    constructor(data) {
        super(data);
        this.Indices = data.Indices;
        this["INT-Entries"] = data["INT-Entries"];
        this.n = data.n;
        this.defaultValue = data.defaultValue;
    }
}
export class Interval extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.closure = data.closure;
        this.leftMargin = data.leftMargin;
        this.rightMargin = data.rightMargin;
    }
}
export class Jaccard extends Similarity {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
    }
}
export class Lag extends Expression {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.BlockIndicator = data.BlockIndicator;
        this.field = data.field;
        this.n = data.n;
        this.aggregate = data.aggregate;
    }
}
export class LiftData extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.ModelLiftGraph = data.ModelLiftGraph;
        this.OptimumLiftGraph = data.OptimumLiftGraph;
        this.RandomLiftGraph = data.RandomLiftGraph;
        this.targetFieldValue = data.targetFieldValue;
        this.targetFieldDisplayValue = data.targetFieldDisplayValue;
        this.rankingQuality = data.rankingQuality;
    }
}
export class LiftGraph extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.XCoordinates = data.XCoordinates;
        this.YCoordinates = data.YCoordinates;
        this.BoundaryValues = data.BoundaryValues;
        this.BoundaryValueMeans = data.BoundaryValueMeans;
    }
}
export class LinearNorm extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.orig = data.orig;
        this.norm = data.norm;
    }
}
export class LocalTransformations extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.DerivedField = data.DerivedField;
    }
}
export class MapValues extends Expression {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.FieldColumnPair = data.FieldColumnPair;
        this.TableLocator = data.TableLocator;
        this.InlineTable = data.InlineTable;
        this.mapMissingTo = data.mapMissingTo;
        this.defaultValue = data.defaultValue;
        this.outputColumn = data.outputColumn;
        this.dataType = data.dataType;
    }
}
export class MatCell extends PMMLObject {
    constructor(data) {
        super(data);
        this.value = data.value;
        this.row = data.row;
        this.col = data.col;
    }
}
export class Matrix extends PMMLObject {
    constructor(data) {
        super(data);
        this.Array = data.Array;
        this.MatCell = data.MatCell;
        this.kind = data.kind;
        this.nbRows = data.nbRows;
        this.nbCols = data.nbCols;
        this.diagDefault = data.diagDefault;
        this.offDiagDefault = data.offDiagDefault;
    }
}
export class MiningBuildTask extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
    }
}
export class MiningField extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.name = data.name;
        this.usageType = data.usageType;
        this.optype = data.optype;
        this.importance = data.importance;
        this.outliers = data.outliers;
        this.lowValue = data.lowValue;
        this.highValue = data.highValue;
        this.missingValueReplacement = data.missingValueReplacement;
        this.missingValueTreatment = data.missingValueTreatment;
        this.invalidValueTreatment = data.invalidValueTreatment;
        this.invalidValueReplacement = data.invalidValueReplacement;
    }
}
export class MiningSchema extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.MiningField = data.MiningField;
    }
}
export class Minkowski extends Distance {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this["p-parameter"] = data["p-parameter"];
    }
}
export class Model extends PMMLObject {
    constructor(data) {
        super(data);
    }
}
export class ModelExplanation extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.PredictiveModelQuality = data.PredictiveModelQuality;
        this.ClusteringModelQuality = data.ClusteringModelQuality;
        this.Correlations = data.Correlations;
    }
}
export class ModelLiftGraph extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.LiftGraph = data.LiftGraph;
    }
}
export class ModelStats extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.UnivariateStats = data.UnivariateStats;
        this.MultivariateStats = data.MultivariateStats;
    }
}
export class ModelVerification extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.VerificationFields = data.VerificationFields;
        this.InlineTable = data.InlineTable;
        this.recordCount = data.recordCount;
        this.fieldCount = data.fieldCount;
    }
}
export class MultivariateStat extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.name = data.name;
        this.category = data.category;
        this.exponent = data.exponent;
        this.isIntercept = data.isIntercept;
        this.importance = data.importance;
        this.stdError = data.stdError;
        this.tValue = data.tValue;
        this.chiSquareValue = data.chiSquareValue;
        this.fStatistic = data.fStatistic;
        this.dF = data.dF;
        this.pValueAlpha = data.pValueAlpha;
        this.pValueInitial = data.pValueInitial;
        this.pValueFinal = data.pValueFinal;
        this.confidenceLevel = data.confidenceLevel;
        this.confidenceLowerBound = data.confidenceLowerBound;
        this.confidenceUpperBound = data.confidenceUpperBound;
    }
}
export class MultivariateStats extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.MultivariateStat = data.MultivariateStat;
        this.targetCategory = data.targetCategory;
    }
}
export class NormContinuous extends Expression {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.LinearNorm = data.LinearNorm;
        this.mapMissingTo = data.mapMissingTo;
        this.field = data.field;
        this.outliers = data.outliers;
    }
}
export class NormDiscrete extends Expression {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.field = data.field;
        this.method = data.method;
        this.value = data.value;
        this.mapMissingTo = data.mapMissingTo;
    }
}
export class NumericInfo extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.Quantile = data.Quantile;
        this.minimum = data.minimum;
        this.maximum = data.maximum;
        this.mean = data.mean;
        this.standardDeviation = data.standardDeviation;
        this.median = data.median;
        this.interQuartileRange = data.interQuartileRange;
    }
}
export class OptimumLiftGraph extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.LiftGraph = data.LiftGraph;
    }
}
export class Output extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.OutputField = data.OutputField;
    }
}
export class OutputField extends Field {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.Decisions = data.Decisions;
        this.expression = data.expression;
        this.Value = data.Value;
        this.name = data.name;
        this.displayName = data.displayName;
        this.optype = data.optype;
        this.dataType = data.dataType;
        this.targetField = data.targetField;
        this["x-reportField"] = data["x-reportField"];
        this.feature = data.feature;
        this.value = data.value;
        this.ruleFeature = data.ruleFeature;
        this.algorithm = data.algorithm;
        this.rank = data.rank;
        this.rankBasis = data.rankBasis;
        this.rankOrder = data.rankOrder;
        this.isMultiValued = data.isMultiValued;
        this.segmentId = data.segmentId;
        this.isFinalResult = data.isFinalResult;
    }
}
export class PMML extends PMMLObject {
    constructor(data) {
        super(data);
        this.Header = data.Header;
        this.MiningBuildTask = data.MiningBuildTask;
        this.DataDictionary = data.DataDictionary;
        this.TransformationDictionary = data.TransformationDictionary;
        this.models = data.models;
        this.Extension = data.Extension;
        this.version = data.version;
        this["x-baseVersion"] = data["x-baseVersion"];
    }
}
export class ParameterField extends Field {
    constructor(data) {
        super(data);
        this.name = data.name;
        this.optype = data.optype;
        this.dataType = data.dataType;
        this.displayName = data.displayName;
    }
}
export class Partition extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.PartitionFieldStats = data.PartitionFieldStats;
        this.name = data.name;
        this.size = data.size;
    }
}
export class PartitionFieldStats extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.Counts = data.Counts;
        this.NumericInfo = data.NumericInfo;
        this.Array = data.Array;
        this.field = data.field;
        this.weighted = data.weighted;
    }
}
export class PoissonDistribution extends ContinuousDistribution {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.mean = data.mean;
    }
}
export class PredictiveModelQuality extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.ConfusionMatrix = data.ConfusionMatrix;
        this.LiftData = data.LiftData;
        this.ROC = data.ROC;
        this.targetField = data.targetField;
        this.dataName = data.dataName;
        this.dataUsage = data.dataUsage;
        this.meanError = data.meanError;
        this.meanAbsoluteError = data.meanAbsoluteError;
        this.meanSquaredError = data.meanSquaredError;
        this.rootMeanSquaredError = data.rootMeanSquaredError;
        this["r-squared"] = data["r-squared"];
        this["adj-r-squared"] = data["adj-r-squared"];
        this.sumSquaredError = data.sumSquaredError;
        this.sumSquaredRegression = data.sumSquaredRegression;
        this.numOfRecords = data.numOfRecords;
        this.numOfRecordsWeighted = data.numOfRecordsWeighted;
        this.numOfPredictors = data.numOfPredictors;
        this.degreesOfFreedom = data.degreesOfFreedom;
        this.fStatistic = data.fStatistic;
        this.AIC = data.AIC;
        this.BIC = data.BIC;
        this.AICc = data.AICc;
    }
}
export class Quantile extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.quantileLimit = data.quantileLimit;
        this.quantileValue = data.quantileValue;
    }
}
export class ROC extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.ROCGraph = data.ROCGraph;
        this.positiveTargetFieldValue = data.positiveTargetFieldValue;
        this.positiveTargetFieldDisplayValue = data.positiveTargetFieldDisplayValue;
        this.negativeTargetFieldValue = data.negativeTargetFieldValue;
        this.negativeTargetFieldDisplayValue = data.negativeTargetFieldDisplayValue;
    }
}
export class ROCGraph extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.XCoordinates = data.XCoordinates;
        this.YCoordinates = data.YCoordinates;
        this.BoundaryValues = data.BoundaryValues;
    }
}
export class RandomLiftGraph extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.LiftGraph = data.LiftGraph;
    }
}
export class RealSparseArray extends SparseArray {
    constructor(data) {
        super(data);
        this.Indices = data.Indices;
        this["REAL-Entries"] = data["REAL-Entries"];
        this.n = data.n;
        this.defaultValue = data.defaultValue;
    }
}
export class ResultField extends Field {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.name = data.name;
        this.displayName = data.displayName;
        this.optype = data.optype;
        this.dataType = data.dataType;
        this.feature = data.feature;
        this.value = data.value;
    }
}
export class Row extends PMMLObject {
    constructor(data) {
        super(data);
        this.content = data.content;
    }
}
export class ScoreDistribution extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.value = data.value;
        this.recordCount = data.recordCount;
        this.confidence = data.confidence;
        this.probability = data.probability;
    }
}
export class SimpleMatching extends Similarity {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
    }
}
export class SimplePredicate extends Predicate {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.field = data.field;
        this.operator = data.operator;
        this.value = data.value;
    }
}
export class SimpleSetPredicate extends Predicate {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.Array = data.Array;
        this.field = data.field;
        this.booleanOperator = data.booleanOperator;
    }
}
export class SquaredEuclidean extends Distance {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
    }
}
export class TableLocator extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
    }
}
export class Tanimoto extends Similarity {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
    }
}
export class Target extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.TargetValue = data.TargetValue;
        this.field = data.field;
        this.optype = data.optype;
        this.castInteger = data.castInteger;
        this.min = data.min;
        this.max = data.max;
        this.rescaleConstant = data.rescaleConstant;
        this.rescaleFactor = data.rescaleFactor;
    }
}
export class TargetValue extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.Partition = data.Partition;
        this.value = data.value;
        this.displayValue = data.displayValue;
        this.priorProbability = data.priorProbability;
        this.defaultValue = data.defaultValue;
    }
}
export class Targets extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.Target = data.Target;
    }
}
export class Taxonomy extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.ChildParent = data.ChildParent;
        this.name = data.name;
    }
}
export class TextIndex extends Expression {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.TextIndexNormalization = data.TextIndexNormalization;
        this.expression = data.expression;
        this.textField = data.textField;
        this.localTermWeights = data.localTermWeights;
        this.isCaseSensitive = data.isCaseSensitive;
        this.maxLevenshteinDistance = data.maxLevenshteinDistance;
        this.countHits = data.countHits;
        this.wordSeparatorCharacterRE = data.wordSeparatorCharacterRE;
        this.tokenize = data.tokenize;
    }
}
export class TextIndexNormalization extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.TableLocator = data.TableLocator;
        this.InlineTable = data.InlineTable;
        this.inField = data.inField;
        this.outField = data.outField;
        this.regexField = data.regexField;
        this.recursive = data.recursive;
        this.isCaseSensitive = data.isCaseSensitive;
        this.maxLevenshteinDistance = data.maxLevenshteinDistance;
        this.wordSeparatorCharacterRE = data.wordSeparatorCharacterRE;
        this.tokenize = data.tokenize;
    }
}
export class Timestamp extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
    }
}
export class TransformationDictionary extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.DefineFunction = data.DefineFunction;
        this.DerivedField = data.DerivedField;
    }
}
export class True extends Predicate {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
    }
}
export class UniformDistribution extends ContinuousDistribution {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.lower = data.lower;
        this.upper = data.upper;
    }
}
export class UnivariateStats extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.Counts = data.Counts;
        this.NumericInfo = data.NumericInfo;
        this.DiscrStats = data.DiscrStats;
        this.ContStats = data.ContStats;
        this.Anova = data.Anova;
        this.field = data.field;
        this.weighted = data.weighted;
    }
}
export class Value extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.value = data.value;
        this.displayValue = data.displayValue;
        this.property = data.property;
    }
}
export class VerificationField extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.field = data.field;
        this.column = data.column;
        this.precision = data.precision;
        this.zeroThreshold = data.zeroThreshold;
    }
}
export class VerificationFields extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.VerificationField = data.VerificationField;
    }
}
export class XCoordinates extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.Array = data.Array;
    }
}
export class YCoordinates extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.Array = data.Array;
    }
}
export class AnomalyDetectionModel extends Model {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.MiningSchema = data.MiningSchema;
        this.Output = data.Output;
        this.LocalTransformations = data.LocalTransformations;
        this.ModelVerification = data.ModelVerification;
        this.model = data.model;
        this.MeanClusterDistances = data.MeanClusterDistances;
        this.modelName = data.modelName;
        this.algorithmName = data.algorithmName;
        this.functionName = data.functionName;
        this.algorithmType = data.algorithmType;
        this.sampleDataSize = data.sampleDataSize;
        this.isScorable = data.isScorable;
        this["x-mathContext"] = data["x-mathContext"];
    }
}
export class MeanClusterDistances extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.Array = data.Array;
    }
}
export class AssociationModel extends Model {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.MiningSchema = data.MiningSchema;
        this.Output = data.Output;
        this.ModelStats = data.ModelStats;
        this.LocalTransformations = data.LocalTransformations;
        this.Item = data.Item;
        this.Itemset = data.Itemset;
        this.AssociationRule = data.AssociationRule;
        this.ModelVerification = data.ModelVerification;
        this.modelName = data.modelName;
        this.functionName = data.functionName;
        this.algorithmName = data.algorithmName;
        this.numberOfTransactions = data.numberOfTransactions;
        this.maxNumberOfItemsPerTA = data.maxNumberOfItemsPerTA;
        this.avgNumberOfItemsPerTA = data.avgNumberOfItemsPerTA;
        this.minimumSupport = data.minimumSupport;
        this.minimumConfidence = data.minimumConfidence;
        this.lengthLimit = data.lengthLimit;
        this.numberOfItems = data.numberOfItems;
        this.numberOfItemsets = data.numberOfItemsets;
        this.numberOfRules = data.numberOfRules;
        this.isScorable = data.isScorable;
        this["x-mathContext"] = data["x-mathContext"];
    }
}
export class AssociationRule extends Entity {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.antecedent = data.antecedent;
        this.consequent = data.consequent;
        this.support = data.support;
        this.confidence = data.confidence;
        this.lift = data.lift;
        this.leverage = data.leverage;
        this.affinity = data.affinity;
        this.id = data.id;
    }
}
export class Item extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.id = data.id;
        this.value = data.value;
        this.field = data.field;
        this.category = data.category;
        this.mappedValue = data.mappedValue;
        this.weight = data.weight;
    }
}
export class ItemRef extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.itemRef = data.itemRef;
    }
}
export class Itemset extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.ItemRef = data.ItemRef;
        this.id = data.id;
        this.support = data.support;
        this.numberOfItems = data.numberOfItems;
    }
}
export class Alternate extends PMMLObject {
    constructor(data) {
        super(data);
        this.continuousDistribution = data.continuousDistribution;
    }
}
export class Baseline extends PMMLObject {
    constructor(data) {
        super(data);
        this.continuousDistribution = data.continuousDistribution;
        this.CountTable = data.CountTable;
        this.NormalizedCountTable = data.NormalizedCountTable;
        this.FieldRef = data.FieldRef;
    }
}
export class BaselineModel extends Model {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.MiningSchema = data.MiningSchema;
        this.Output = data.Output;
        this.ModelStats = data.ModelStats;
        this.ModelExplanation = data.ModelExplanation;
        this.Targets = data.Targets;
        this.LocalTransformations = data.LocalTransformations;
        this.TestDistributions = data.TestDistributions;
        this.ModelVerification = data.ModelVerification;
        this.modelName = data.modelName;
        this.functionName = data.functionName;
        this.algorithmName = data.algorithmName;
        this.isScorable = data.isScorable;
        this["x-mathContext"] = data["x-mathContext"];
    }
}
export class CountTable extends DiscreteDistribution {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.FieldValue = data.FieldValue;
        this.FieldValueCount = data.FieldValueCount;
        this.sample = data.sample;
    }
}
export class FieldValue extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.FieldValue = data.FieldValue;
        this.FieldValueCount = data.FieldValueCount;
        this.field = data.field;
        this.value = data.value;
    }
}
export class FieldValueCount extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.field = data.field;
        this.value = data.value;
        this.count = data.count;
    }
}
export class TestDistributions extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.Baseline = data.Baseline;
        this.Alternate = data.Alternate;
        this.field = data.field;
        this.testStatistic = data.testStatistic;
        this.resetValue = data.resetValue;
        this.windowSize = data.windowSize;
        this.weightField = data.weightField;
        this.normalizationScheme = data.normalizationScheme;
    }
}
export class BayesianNetworkModel extends Model {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.MiningSchema = data.MiningSchema;
        this.Output = data.Output;
        this.ModelStats = data.ModelStats;
        this.ModelExplanation = data.ModelExplanation;
        this.Targets = data.Targets;
        this.LocalTransformations = data.LocalTransformations;
        this.BayesianNetworkNodes = data.BayesianNetworkNodes;
        this.ModelVerification = data.ModelVerification;
        this.modelName = data.modelName;
        this.functionName = data.functionName;
        this.algorithmName = data.algorithmName;
        this.modelType = data.modelType;
        this.inferenceMethod = data.inferenceMethod;
        this.isScorable = data.isScorable;
        this["x-mathContext"] = data["x-mathContext"];
    }
}
export class BayesianNetworkNodes extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.content = data.content;
    }
}
export class ContinuousConditionalProbability extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.ParentValue = data.ParentValue;
        this.ContinuousDistribution = data.ContinuousDistribution;
        this.count = data.count;
    }
}
export class BayesianContinuousDistribution extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.TriangularDistributionForBN = data.TriangularDistributionForBN;
        this.NormalDistributionForBN = data.NormalDistributionForBN;
        this.LognormalDistributionForBN = data.LognormalDistributionForBN;
        this.UniformDistributionForBN = data.UniformDistributionForBN;
    }
}
export class ContinuousNode extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.DerivedField = data.DerivedField;
        this.content = data.content;
        this.name = data.name;
        this.count = data.count;
    }
}
export class DiscreteConditionalProbability extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.ParentValue = data.ParentValue;
        this.ValueProbability = data.ValueProbability;
        this.count = data.count;
    }
}
export class DiscreteNode extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.DerivedField = data.DerivedField;
        this.content = data.content;
        this.name = data.name;
        this.count = data.count;
    }
}
export class LognormalDistribution extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.Mean = data.Mean;
        this.Variance = data.Variance;
    }
}
export class Lower extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.expression = data.expression;
    }
}
export class Mean extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.expression = data.expression;
    }
}
export class NormalDistribution extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.Mean = data.Mean;
        this.Variance = data.Variance;
    }
}
export class ParentValue extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.parent = data.parent;
        this.value = data.value;
    }
}
export class TriangularDistribution extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.Mean = data.Mean;
        this.Lower = data.Lower;
        this.Upper = data.Upper;
    }
}
export class BayesianUniformDistribution extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.Lower = data.Lower;
        this.Upper = data.Upper;
    }
}
export class Upper extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.expression = data.expression;
    }
}
export class ValueProbability extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.value = data.value;
        this.probability = data.probability;
    }
}
export class Variance extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.expression = data.expression;
    }
}
export class CenterFields extends PMMLObject {
    constructor(data) {
        super(data);
        this.DerivedField = data.DerivedField;
    }
}
export class Cluster extends Entity {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.KohonenMap = data.KohonenMap;
        this.Array = data.Array;
        this.Partition = data.Partition;
        this.Covariances = data.Covariances;
        this.id = data.id;
        this.name = data.name;
        this.size = data.size;
    }
}
export class ClusteringField extends ComparisonField {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.Comparisons = data.Comparisons;
        this.field = data.field;
        this.isCenterField = data.isCenterField;
        this.fieldWeight = data.fieldWeight;
        this.similarityScale = data.similarityScale;
        this.compareFunction = data.compareFunction;
    }
}
export class ClusteringModel extends Model {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.MiningSchema = data.MiningSchema;
        this.Output = data.Output;
        this.ModelStats = data.ModelStats;
        this.ModelExplanation = data.ModelExplanation;
        this.LocalTransformations = data.LocalTransformations;
        this.ComparisonMeasure = data.ComparisonMeasure;
        this.ClusteringField = data.ClusteringField;
        this.CenterFields = data.CenterFields;
        this.MissingValueWeights = data.MissingValueWeights;
        this.Cluster = data.Cluster;
        this.ModelVerification = data.ModelVerification;
        this.modelName = data.modelName;
        this.functionName = data.functionName;
        this.algorithmName = data.algorithmName;
        this.modelClass = data.modelClass;
        this.numberOfClusters = data.numberOfClusters;
        this.isScorable = data.isScorable;
        this["x-mathContext"] = data["x-mathContext"];
    }
}
export class Comparisons extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.Matrix = data.Matrix;
    }
}
export class Covariances extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.Matrix = data.Matrix;
    }
}
export class KohonenMap extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.coord1 = data.coord1;
        this.coord2 = data.coord2;
        this.coord3 = data.coord3;
    }
}
export class MissingValueWeights extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.Array = data.Array;
    }
}
export class ARDSquaredExponentialKernel extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.Lambda = data.Lambda;
        this.description = data.description;
        this.gamma = data.gamma;
        this.noiseVariance = data.noiseVariance;
    }
}
export class AbsoluteExponentialKernel extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.Lambda = data.Lambda;
        this.description = data.description;
        this.gamma = data.gamma;
        this.noiseVariance = data.noiseVariance;
    }
}
export class GaussianProcessModel extends Model {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.MiningSchema = data.MiningSchema;
        this.Output = data.Output;
        this.ModelStats = data.ModelStats;
        this.ModelExplanation = data.ModelExplanation;
        this.Targets = data.Targets;
        this.LocalTransformations = data.LocalTransformations;
        this.RadialBasisKernel = data.RadialBasisKernel;
        this.ARDSquaredExponentialKernel = data.ARDSquaredExponentialKernel;
        this.AbsoluteExponentialKernel = data.AbsoluteExponentialKernel;
        this.GeneralizedExponentialKernel = data.GeneralizedExponentialKernel;
        this.TrainingInstances = data.TrainingInstances;
        this.ModelVerification = data.ModelVerification;
        this.modelName = data.modelName;
        this.functionName = data.functionName;
        this.algorithmName = data.algorithmName;
        this.optimizer = data.optimizer;
        this.isScorable = data.isScorable;
        this["x-mathContext"] = data["x-mathContext"];
    }
}
export class GeneralizedExponentialKernel extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.Lambda = data.Lambda;
        this.description = data.description;
        this.gamma = data.gamma;
        this.noiseVariance = data.noiseVariance;
        this.degree = data.degree;
    }
}
export class Lambda extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.Array = data.Array;
    }
}
export class GaussianRadialBasisKernel extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.description = data.description;
        this.gamma = data.gamma;
        this.noiseVariance = data.noiseVariance;
        this.lambda = data.lambda;
    }
}
export class BaseCumHazardTables extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.BaselineStratum = data.BaselineStratum;
        this.BaselineCell = data.BaselineCell;
        this.maxTime = data.maxTime;
    }
}
export class BaselineCell extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.time = data.time;
        this.cumHazard = data.cumHazard;
    }
}
export class BaselineStratum extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.BaselineCell = data.BaselineCell;
        this.value = data.value;
        this.label = data.label;
        this.maxTime = data.maxTime;
    }
}
export class Categories extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.Category = data.Category;
    }
}
export class Category extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.value = data.value;
    }
}
export class PredictorList extends PMMLObject {
    constructor(data) {
        super(data);
    }
}
export class CovariateList extends PredictorList {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.Predictor = data.Predictor;
    }
}
export class EventValues extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.Value = data.Value;
        this.Interval = data.Interval;
    }
}
export class FactorList extends PredictorList {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.Predictor = data.Predictor;
    }
}
export class GeneralRegressionModel extends Model {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.MiningSchema = data.MiningSchema;
        this.Output = data.Output;
        this.ModelStats = data.ModelStats;
        this.ModelExplanation = data.ModelExplanation;
        this.Targets = data.Targets;
        this.LocalTransformations = data.LocalTransformations;
        this.ParameterList = data.ParameterList;
        this.FactorList = data.FactorList;
        this.CovariateList = data.CovariateList;
        this.PPMatrix = data.PPMatrix;
        this.PCovMatrix = data.PCovMatrix;
        this.ParamMatrix = data.ParamMatrix;
        this.EventValues = data.EventValues;
        this.BaseCumHazardTables = data.BaseCumHazardTables;
        this.ModelVerification = data.ModelVerification;
        this.targetVariableName = data.targetVariableName;
        this.modelType = data.modelType;
        this.modelName = data.modelName;
        this.functionName = data.functionName;
        this.algorithmName = data.algorithmName;
        this.targetReferenceCategory = data.targetReferenceCategory;
        this.cumulativeLink = data.cumulativeLink;
        this.linkFunction = data.linkFunction;
        this.linkParameter = data.linkParameter;
        this.trialsVariable = data.trialsVariable;
        this.trialsValue = data.trialsValue;
        this.distribution = data.distribution;
        this.distParameter = data.distParameter;
        this.offsetVariable = data.offsetVariable;
        this.offsetValue = data.offsetValue;
        this.modelDF = data.modelDF;
        this.endTimeVariable = data.endTimeVariable;
        this.startTimeVariable = data.startTimeVariable;
        this.subjectIDVariable = data.subjectIDVariable;
        this.statusVariable = data.statusVariable;
        this.baselineStrataVariable = data.baselineStrataVariable;
        this.isScorable = data.isScorable;
        this["x-mathContext"] = data["x-mathContext"];
    }
}
export class ParameterCell extends PMMLObject {
    constructor(data) {
        super(data);
    }
}
export class PCell extends ParameterCell {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.targetCategory = data.targetCategory;
        this.parameterName = data.parameterName;
        this.beta = data.beta;
        this.df = data.df;
    }
}
export class PCovCell extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.pRow = data.pRow;
        this.pCol = data.pCol;
        this.tRow = data.tRow;
        this.tCol = data.tCol;
        this.value = data.value;
        this.targetCategory = data.targetCategory;
    }
}
export class PCovMatrix extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.PCovCell = data.PCovCell;
        this.type = data.type;
    }
}
export class PPCell extends ParameterCell {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.value = data.value;
        this.predictorName = data.predictorName;
        this.parameterName = data.parameterName;
        this.targetCategory = data.targetCategory;
    }
}
export class PPMatrix extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.PPCell = data.PPCell;
    }
}
export class ParamMatrix extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.PCell = data.PCell;
    }
}
export class Parameter extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.name = data.name;
        this.label = data.label;
        this.referencePoint = data.referencePoint;
    }
}
export class ParameterList extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.Parameter = data.Parameter;
    }
}
export class Predictor extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.Categories = data.Categories;
        this.Matrix = data.Matrix;
        this.name = data.name;
        this.contrastMatrixType = data.contrastMatrixType;
    }
}
export class MiningModel extends Model {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.MiningSchema = data.MiningSchema;
        this.Output = data.Output;
        this.ModelStats = data.ModelStats;
        this.ModelExplanation = data.ModelExplanation;
        this.Targets = data.Targets;
        this.LocalTransformations = data.LocalTransformations;
        this.embeddedModels = data.embeddedModels;
        this.Segmentation = data.Segmentation;
        this.ModelVerification = data.ModelVerification;
        this.modelName = data.modelName;
        this.functionName = data.functionName;
        this.algorithmName = data.algorithmName;
        this.isScorable = data.isScorable;
        this["x-mathContext"] = data["x-mathContext"];
    }
}
export class Segment extends Entity {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.predicate = data.predicate;
        this.model = data.model;
        this.VariableWeight = data.VariableWeight;
        this.id = data.id;
        this.weight = data.weight;
    }
}
export class Segmentation extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.LocalTransformations = data.LocalTransformations;
        this.Segment = data.Segment;
        this.multipleModelMethod = data.multipleModelMethod;
        this.missingPredictionTreatment = data.missingPredictionTreatment;
        this.missingThreshold = data.missingThreshold;
    }
}
export class VariableWeight extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.field = data.field;
    }
}
export class BayesInput extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.TargetValueStats = data.TargetValueStats;
        this.DerivedField = data.DerivedField;
        this.PairCounts = data.PairCounts;
        this.fieldName = data.fieldName;
    }
}
export class BayesInputs extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.BayesInput = data.BayesInput;
    }
}
export class BayesOutput extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.TargetValueCounts = data.TargetValueCounts;
        this.fieldName = data.fieldName;
    }
}
export class NaiveBayesModel extends Model {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.MiningSchema = data.MiningSchema;
        this.Output = data.Output;
        this.ModelStats = data.ModelStats;
        this.ModelExplanation = data.ModelExplanation;
        this.Targets = data.Targets;
        this.LocalTransformations = data.LocalTransformations;
        this.BayesInputs = data.BayesInputs;
        this.BayesOutput = data.BayesOutput;
        this.ModelVerification = data.ModelVerification;
        this.modelName = data.modelName;
        this.threshold = data.threshold;
        this.functionName = data.functionName;
        this.algorithmName = data.algorithmName;
        this.isScorable = data.isScorable;
        this["x-mathContext"] = data["x-mathContext"];
    }
}
export class PairCounts extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.TargetValueCounts = data.TargetValueCounts;
        this.value = data.value;
    }
}
export class TargetValueCount extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.value = data.value;
        this.count = data.count;
    }
}
export class TargetValueCounts extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.TargetValueCount = data.TargetValueCount;
    }
}
export class TargetValueStat extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.continuousDistribution = data.continuousDistribution;
        this.value = data.value;
    }
}
export class TargetValueStats extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.TargetValueStat = data.TargetValueStat;
    }
}
export class InstanceField extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.field = data.field;
        this.column = data.column;
    }
}
export class InstanceFields extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.InstanceField = data.InstanceField;
    }
}
export class KNNInput extends ComparisonField {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.field = data.field;
        this.fieldWeight = data.fieldWeight;
        this.compareFunction = data.compareFunction;
    }
}
export class KNNInputs extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.KNNInput = data.KNNInput;
    }
}
export class NearestNeighborModel extends Model {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.MiningSchema = data.MiningSchema;
        this.Output = data.Output;
        this.ModelStats = data.ModelStats;
        this.ModelExplanation = data.ModelExplanation;
        this.Targets = data.Targets;
        this.LocalTransformations = data.LocalTransformations;
        this.TrainingInstances = data.TrainingInstances;
        this.ComparisonMeasure = data.ComparisonMeasure;
        this.KNNInputs = data.KNNInputs;
        this.ModelVerification = data.ModelVerification;
        this.modelName = data.modelName;
        this.functionName = data.functionName;
        this.algorithmName = data.algorithmName;
        this.numberOfNeighbors = data.numberOfNeighbors;
        this.continuousScoringMethod = data.continuousScoringMethod;
        this.categoricalScoringMethod = data.categoricalScoringMethod;
        this.instanceIdVariable = data.instanceIdVariable;
        this.threshold = data.threshold;
        this.isScorable = data.isScorable;
        this["x-mathContext"] = data["x-mathContext"];
    }
}
export class TrainingInstances extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.InstanceFields = data.InstanceFields;
        this.TableLocator = data.TableLocator;
        this.InlineTable = data.InlineTable;
        this.isTransformed = data.isTransformed;
        this.recordCount = data.recordCount;
        this.fieldCount = data.fieldCount;
    }
}
export class Connection extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.from = data.from;
        this.weight = data.weight;
    }
}
export class NeuralEntity extends Entity {
    constructor(data) {
        super(data);
    }
}
export class NeuralInput extends NeuralEntity {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.DerivedField = data.DerivedField;
        this.id = data.id;
    }
}
export class NeuralInputs extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.NeuralInput = data.NeuralInput;
        this.numberOfInputs = data.numberOfInputs;
    }
}
export class NeuralLayer extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.Neuron = data.Neuron;
        this.numberOfNeurons = data.numberOfNeurons;
        this.activationFunction = data.activationFunction;
        this.threshold = data.threshold;
        this.width = data.width;
        this.altitude = data.altitude;
        this.normalizationMethod = data.normalizationMethod;
    }
}
export class NeuralNetwork extends Model {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.MiningSchema = data.MiningSchema;
        this.Output = data.Output;
        this.ModelStats = data.ModelStats;
        this.ModelExplanation = data.ModelExplanation;
        this.Targets = data.Targets;
        this.LocalTransformations = data.LocalTransformations;
        this.NeuralInputs = data.NeuralInputs;
        this.NeuralLayer = data.NeuralLayer;
        this.NeuralOutputs = data.NeuralOutputs;
        this.ModelVerification = data.ModelVerification;
        this.modelName = data.modelName;
        this.functionName = data.functionName;
        this.algorithmName = data.algorithmName;
        this.activationFunction = data.activationFunction;
        this.normalizationMethod = data.normalizationMethod;
        this.threshold = data.threshold;
        this.width = data.width;
        this.altitude = data.altitude;
        this.numberOfLayers = data.numberOfLayers;
        this.isScorable = data.isScorable;
        this["x-mathContext"] = data["x-mathContext"];
    }
}
export class NeuralOutput extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.DerivedField = data.DerivedField;
        this.outputNeuron = data.outputNeuron;
    }
}
export class NeuralOutputs extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.NeuralOutput = data.NeuralOutput;
        this.numberOfOutputs = data.numberOfOutputs;
    }
}
export class Neuron extends NeuralEntity {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.Con = data.Con;
        this.id = data.id;
        this.bias = data.bias;
        this.width = data.width;
        this.altitude = data.altitude;
    }
}
export class Term extends PMMLObject {
    constructor(data) {
        super(data);
    }
}
export class CategoricalPredictor extends Term {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.name = data.name;
        this.value = data.value;
        this.coefficient = data.coefficient;
    }
}
export class NumericPredictor extends Term {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.name = data.name;
        this.exponent = data.exponent;
        this.coefficient = data.coefficient;
    }
}
export class PredictorTerm extends Term {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.FieldRef = data.FieldRef;
        this.name = data.name;
        this.coefficient = data.coefficient;
    }
}
export class Regression extends EmbeddedModel {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.Output = data.Output;
        this.ModelStats = data.ModelStats;
        this.Targets = data.Targets;
        this.LocalTransformations = data.LocalTransformations;
        this.ResultField = data.ResultField;
        this.RegressionTable = data.RegressionTable;
        this.modelName = data.modelName;
        this.functionName = data.functionName;
        this.algorithmName = data.algorithmName;
        this.normalizationMethod = data.normalizationMethod;
    }
}
export class RegressionModel extends Model {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.MiningSchema = data.MiningSchema;
        this.Output = data.Output;
        this.ModelStats = data.ModelStats;
        this.ModelExplanation = data.ModelExplanation;
        this.Targets = data.Targets;
        this.LocalTransformations = data.LocalTransformations;
        this.RegressionTable = data.RegressionTable;
        this.ModelVerification = data.ModelVerification;
        this.modelName = data.modelName;
        this.functionName = data.functionName;
        this.algorithmName = data.algorithmName;
        this.modelType = data.modelType;
        this.targetFieldName = data.targetFieldName;
        this.normalizationMethod = data.normalizationMethod;
        this.isScorable = data.isScorable;
        this["x-mathContext"] = data["x-mathContext"];
    }
}
export class RegressionTable extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.NumericPredictor = data.NumericPredictor;
        this.CategoricalPredictor = data.CategoricalPredictor;
        this.PredictorTerm = data.PredictorTerm;
        this.intercept = data.intercept;
        this.targetCategory = data.targetCategory;
    }
}
export class Rule extends Entity {
    constructor(data) {
        super(data);
    }
}
export class CompoundRule extends Rule {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.predicate = data.predicate;
        this.rules = data.rules;
    }
}
export class RuleSelectionMethod extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.criterion = data.criterion;
    }
}
export class RuleSet extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.RuleSelectionMethod = data.RuleSelectionMethod;
        this.ScoreDistribution = data.ScoreDistribution;
        this.rules = data.rules;
        this.recordCount = data.recordCount;
        this.nbCorrect = data.nbCorrect;
        this.defaultScore = data.defaultScore;
        this.defaultConfidence = data.defaultConfidence;
    }
}
export class RuleSetModel extends Model {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.MiningSchema = data.MiningSchema;
        this.Output = data.Output;
        this.ModelStats = data.ModelStats;
        this.ModelExplanation = data.ModelExplanation;
        this.Targets = data.Targets;
        this.LocalTransformations = data.LocalTransformations;
        this.RuleSet = data.RuleSet;
        this.ModelVerification = data.ModelVerification;
        this.modelName = data.modelName;
        this.functionName = data.functionName;
        this.algorithmName = data.algorithmName;
        this.isScorable = data.isScorable;
        this["x-mathContext"] = data["x-mathContext"];
    }
}
export class SimpleRule extends Rule {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.predicate = data.predicate;
        this.ScoreDistribution = data.ScoreDistribution;
        this.id = data.id;
        this.score = data.score;
        this.recordCount = data.recordCount;
        this.nbCorrect = data.nbCorrect;
        this.confidence = data.confidence;
        this.weight = data.weight;
    }
}
export class Attribute extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.predicate = data.predicate;
        this.ComplexPartialScore = data.ComplexPartialScore;
        this.reasonCode = data.reasonCode;
        this.partialScore = data.partialScore;
    }
}
export class Characteristic extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.Attribute = data.Attribute;
        this.name = data.name;
        this.reasonCode = data.reasonCode;
        this.baselineScore = data.baselineScore;
    }
}
export class Characteristics extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.Characteristic = data.Characteristic;
    }
}
export class ComplexPartialScore extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.expression = data.expression;
    }
}
export class Scorecard extends Model {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.MiningSchema = data.MiningSchema;
        this.Output = data.Output;
        this.ModelStats = data.ModelStats;
        this.ModelExplanation = data.ModelExplanation;
        this.Targets = data.Targets;
        this.LocalTransformations = data.LocalTransformations;
        this.Characteristics = data.Characteristics;
        this.ModelVerification = data.ModelVerification;
        this.modelName = data.modelName;
        this.functionName = data.functionName;
        this.algorithmName = data.algorithmName;
        this.initialScore = data.initialScore;
        this.useReasonCodes = data.useReasonCodes;
        this.reasonCodeAlgorithm = data.reasonCodeAlgorithm;
        this.baselineScore = data.baselineScore;
        this.baselineMethod = data.baselineMethod;
        this.isScorable = data.isScorable;
        this["x-mathContext"] = data["x-mathContext"];
    }
}
export class AntecedentSequence extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.SequenceReference = data.SequenceReference;
        this.Time = data.Time;
    }
}
export class ConsequentSequence extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.SequenceReference = data.SequenceReference;
        this.Time = data.Time;
    }
}
export class Constraints extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.minimumNumberOfItems = data.minimumNumberOfItems;
        this.maximumNumberOfItems = data.maximumNumberOfItems;
        this.minimumNumberOfAntecedentItems = data.minimumNumberOfAntecedentItems;
        this.maximumNumberOfAntecedentItems = data.maximumNumberOfAntecedentItems;
        this.minimumNumberOfConsequentItems = data.minimumNumberOfConsequentItems;
        this.maximumNumberOfConsequentItems = data.maximumNumberOfConsequentItems;
        this.minimumSupport = data.minimumSupport;
        this.minimumConfidence = data.minimumConfidence;
        this.minimumLift = data.minimumLift;
        this.minimumTotalSequenceTime = data.minimumTotalSequenceTime;
        this.maximumTotalSequenceTime = data.maximumTotalSequenceTime;
        this.minimumItemsetSeparationTime = data.minimumItemsetSeparationTime;
        this.maximumItemsetSeparationTime = data.maximumItemsetSeparationTime;
        this.minimumAntConsSeparationTime = data.minimumAntConsSeparationTime;
        this.maximumAntConsSeparationTime = data.maximumAntConsSeparationTime;
    }
}
export class Delimiter extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.delimiter = data.delimiter;
        this.gap = data.gap;
    }
}
export class Sequence extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.SetReference = data.SetReference;
        this.content = data.content;
        this.Time = data.Time;
        this.id = data.id;
        this.numberOfSets = data.numberOfSets;
        this.occurrence = data.occurrence;
        this.support = data.support;
    }
}
export class SequenceModel extends Model {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.MiningSchema = data.MiningSchema;
        this.ModelStats = data.ModelStats;
        this.LocalTransformations = data.LocalTransformations;
        this.Constraints = data.Constraints;
        this.Item = data.Item;
        this.Itemset = data.Itemset;
        this.SetPredicate = data.SetPredicate;
        this.Sequence = data.Sequence;
        this.SequenceRule = data.SequenceRule;
        this.modelName = data.modelName;
        this.functionName = data.functionName;
        this.algorithmName = data.algorithmName;
        this.numberOfTransactions = data.numberOfTransactions;
        this.maxNumberOfItemsPerTransaction = data.maxNumberOfItemsPerTransaction;
        this.avgNumberOfItemsPerTransaction = data.avgNumberOfItemsPerTransaction;
        this.numberOfTransactionGroups = data.numberOfTransactionGroups;
        this.maxNumberOfTAsPerTAGroup = data.maxNumberOfTAsPerTAGroup;
        this.avgNumberOfTAsPerTAGroup = data.avgNumberOfTAsPerTAGroup;
        this.minimumSupport = data.minimumSupport;
        this.minimumConfidence = data.minimumConfidence;
        this.lengthLimit = data.lengthLimit;
        this.numberOfItems = data.numberOfItems;
        this.numberOfSets = data.numberOfSets;
        this.numberOfSequences = data.numberOfSequences;
        this.numberOfRules = data.numberOfRules;
        this.timeWindowWidth = data.timeWindowWidth;
        this.minimumTime = data.minimumTime;
        this.maximumTime = data.maximumTime;
        this.isScorable = data.isScorable;
        this["x-mathContext"] = data["x-mathContext"];
    }
}
export class SequenceReference extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.seqId = data.seqId;
    }
}
export class SequenceRule extends Entity {
    constructor(data) {
        super(data);
        this.content = data.content;
        this.id = data.id;
        this.numberOfSets = data.numberOfSets;
        this.occurrence = data.occurrence;
        this.support = data.support;
        this.confidence = data.confidence;
        this.lift = data.lift;
    }
}
export class SetPredicate extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.Array = data.Array;
        this.id = data.id;
        this.field = data.field;
        this.operator = data.operator;
    }
}
export class SetReference extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.setId = data.setId;
    }
}
export class Time extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.min = data.min;
        this.max = data.max;
        this.mean = data.mean;
        this.standardDeviation = data.standardDeviation;
    }
}
export class Coefficient extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.value = data.value;
    }
}
export class Coefficients extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.Coefficient = data.Coefficient;
        this.numberOfCoefficients = data.numberOfCoefficients;
        this.absoluteValue = data.absoluteValue;
    }
}
export class Kernel extends PMMLObject {
    constructor(data) {
        super(data);
    }
}
export class LinearKernel extends Kernel {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.description = data.description;
    }
}
export class PolynomialKernel extends Kernel {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.description = data.description;
        this.gamma = data.gamma;
        this.coef0 = data.coef0;
        this.degree = data.degree;
    }
}
export class VectorMachineRadialBasisKernel extends Kernel {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.description = data.description;
        this.gamma = data.gamma;
    }
}
export class SigmoidKernel extends Kernel {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.description = data.description;
        this.gamma = data.gamma;
        this.coef0 = data.coef0;
    }
}
export class SupportVector extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.vectorId = data.vectorId;
    }
}
export class SupportVectorMachine extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.SupportVectors = data.SupportVectors;
        this.Coefficients = data.Coefficients;
        this.targetCategory = data.targetCategory;
        this.alternateTargetCategory = data.alternateTargetCategory;
        this.threshold = data.threshold;
    }
}
export class SupportVectorMachineModel extends Model {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.MiningSchema = data.MiningSchema;
        this.Output = data.Output;
        this.ModelStats = data.ModelStats;
        this.ModelExplanation = data.ModelExplanation;
        this.Targets = data.Targets;
        this.LocalTransformations = data.LocalTransformations;
        this.kernel = data.kernel;
        this.VectorDictionary = data.VectorDictionary;
        this.SupportVectorMachine = data.SupportVectorMachine;
        this.ModelVerification = data.ModelVerification;
        this.modelName = data.modelName;
        this.functionName = data.functionName;
        this.algorithmName = data.algorithmName;
        this.threshold = data.threshold;
        this.svmRepresentation = data.svmRepresentation;
        this.alternateBinaryTargetCategory = data.alternateBinaryTargetCategory;
        this.classificationMethod = data.classificationMethod;
        this.maxWins = data.maxWins;
        this.isScorable = data.isScorable;
        this["x-mathContext"] = data["x-mathContext"];
    }
}
export class SupportVectors extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.SupportVector = data.SupportVector;
        this.numberOfSupportVectors = data.numberOfSupportVectors;
        this.numberOfAttributes = data.numberOfAttributes;
    }
}
export class VectorDictionary extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.VectorFields = data.VectorFields;
        this.VectorInstance = data.VectorInstance;
        this.numberOfVectors = data.numberOfVectors;
    }
}
export class VectorFields extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.content = data.content;
        this.numberOfFields = data.numberOfFields;
    }
}
export class VectorInstance extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this["REAL-SparseArray"] = data["REAL-SparseArray"];
        this.Array = data.Array;
        this.id = data.id;
    }
}
export class DocumentTermMatrix extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.Matrix = data.Matrix;
    }
}
export class TextCorpus extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.TextDocument = data.TextDocument;
    }
}
export class TextDictionary extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.Taxonomy = data.Taxonomy;
        this.Array = data.Array;
    }
}
export class TextDocument extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.id = data.id;
        this.name = data.name;
        this.length = data.length;
        this.file = data.file;
    }
}
export class TextModel extends Model {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.MiningSchema = data.MiningSchema;
        this.Output = data.Output;
        this.ModelStats = data.ModelStats;
        this.ModelExplanation = data.ModelExplanation;
        this.Targets = data.Targets;
        this.LocalTransformations = data.LocalTransformations;
        this.TextDictionary = data.TextDictionary;
        this.TextCorpus = data.TextCorpus;
        this.DocumentTermMatrix = data.DocumentTermMatrix;
        this.TextModelNormalization = data.TextModelNormalization;
        this.TextModelSimiliarity = data.TextModelSimiliarity;
        this.ModelVerification = data.ModelVerification;
        this.modelName = data.modelName;
        this.functionName = data.functionName;
        this.algorithmName = data.algorithmName;
        this.numberOfTerms = data.numberOfTerms;
        this.numberOfDocuments = data.numberOfDocuments;
        this.isScorable = data.isScorable;
        this["x-mathContext"] = data["x-mathContext"];
    }
}
export class TextModelNormalization extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.localTermWeights = data.localTermWeights;
        this.globalTermWeights = data.globalTermWeights;
        this.documentNormalization = data.documentNormalization;
    }
}
export class TextModelSimiliarity extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.similarityType = data.similarityType;
    }
}
export class AR extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.Array = data.Array;
    }
}
export class TimeSeriesAlgorithm extends PMMLObject {
    constructor(data) {
        super(data);
    }
}
export class ARIMA extends TimeSeriesAlgorithm {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.NonseasonalComponent = data.NonseasonalComponent;
        this.SeasonalComponent = data.SeasonalComponent;
        this.DynamicRegressor = data.DynamicRegressor;
        this.MaximumLikelihoodStat = data.MaximumLikelihoodStat;
        this.OutlierEffect = data.OutlierEffect;
        this.RMSE = data.RMSE;
        this.transformation = data.transformation;
        this.constantTerm = data.constantTerm;
        this.predictionMethod = data.predictionMethod;
    }
}
export class ARMAPart extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.AR = data.AR;
        this.MA = data.MA;
        this.constant = data.constant;
        this.p = data.p;
        this.q = data.q;
    }
}
export class Denominator extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.NonseasonalFactor = data.NonseasonalFactor;
        this.SeasonalFactor = data.SeasonalFactor;
    }
}
export class DynamicRegressor extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.Numerator = data.Numerator;
        this.Denominator = data.Denominator;
        this.RegressorValues = data.RegressorValues;
        this.field = data.field;
        this.transformation = data.transformation;
        this.delay = data.delay;
        this.futureValuesMethod = data.futureValuesMethod;
        this.targetField = data.targetField;
    }
}
export class ExponentialSmoothing extends TimeSeriesAlgorithm {
    constructor(data) {
        super(data);
        this.Level = data.Level;
        this.Trend_ExpoSmooth = data.Trend_ExpoSmooth;
        this.Seasonality_ExpoSmooth = data.Seasonality_ExpoSmooth;
        this.TimeValue = data.TimeValue;
        this.RMSE = data.RMSE;
        this.transformation = data.transformation;
    }
}
export class FinalNoise extends PMMLObject {
    constructor(data) {
        super(data);
        this.Array = data.Array;
    }
}
export class FinalNu extends PMMLObject {
    constructor(data) {
        super(data);
        this.Array = data.Array;
    }
}
export class FinalOmega extends PMMLObject {
    constructor(data) {
        super(data);
        this.Matrix = data.Matrix;
    }
}
export class FinalPredictedNoise extends PMMLObject {
    constructor(data) {
        super(data);
        this.Array = data.Array;
    }
}
export class FinalStateVector extends PMMLObject {
    constructor(data) {
        super(data);
        this.Array = data.Array;
    }
}
export class FinalTheta extends PMMLObject {
    constructor(data) {
        super(data);
        this.Theta = data.Theta;
    }
}
export class GARCH extends TimeSeriesAlgorithm {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.ARMAPart = data.ARMAPart;
        this.GARCHPart = data.GARCHPart;
    }
}
export class GARCHPart extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.ResidualSquareCoefficients = data.ResidualSquareCoefficients;
        this.VarianceCoefficients = data.VarianceCoefficients;
        this.constant = data.constant;
        this.gp = data.gp;
        this.gq = data.gq;
    }
}
export class HVector extends PMMLObject {
    constructor(data) {
        super(data);
        this.Array = data.Array;
    }
}
export class KalmanState extends PMMLObject {
    constructor(data) {
        super(data);
        this.FinalOmega = data.FinalOmega;
        this.FinalStateVector = data.FinalStateVector;
        this.HVector = data.HVector;
    }
}
export class Level extends PMMLObject {
    constructor(data) {
        super(data);
        this.alpha = data.alpha;
        this.quadraticSmoothedValue = data.quadraticSmoothedValue;
        this.cubicSmoothedValue = data.cubicSmoothedValue;
        this.smoothedValue = data.smoothedValue;
    }
}
export class MA extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.MACoefficients = data.MACoefficients;
        this.Residuals = data.Residuals;
    }
}
export class MACoefficients extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.Array = data.Array;
    }
}
export class MaximumLikelihoodStat extends PMMLObject {
    constructor(data) {
        super(data);
        this.KalmanState = data.KalmanState;
        this.ThetaRecursionState = data.ThetaRecursionState;
        this.method = data.method;
        this.periodDeficit = data.periodDeficit;
    }
}
export class MeasurementMatrix extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.Matrix = data.Matrix;
    }
}
export class NonseasonalComponent extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.AR = data.AR;
        this.MA = data.MA;
        this.p = data.p;
        this.d = data.d;
        this.q = data.q;
    }
}
export class NonseasonalFactor extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.Array = data.Array;
        this.difference = data.difference;
        this.maximumOrder = data.maximumOrder;
    }
}
export class Numerator extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.NonseasonalFactor = data.NonseasonalFactor;
        this.SeasonalFactor = data.SeasonalFactor;
    }
}
export class OutlierEffect extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.type = data.type;
        this.startTime = data.startTime;
        this.magnitude = data.magnitude;
        this.dampingCoefficient = data.dampingCoefficient;
    }
}
export class PastVariances extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.Array = data.Array;
    }
}
export class PsiVector extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.Array = data.Array;
        this.targetField = data.targetField;
        this.variance = data.variance;
    }
}
export class RegressorValues extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.TimeSeries = data.TimeSeries;
        this.TrendCoefficients = data.TrendCoefficients;
        this.TransferFunctionValues = data.TransferFunctionValues;
    }
}
export class ResidualSquareCoefficients extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.Residuals = data.Residuals;
        this.MACoefficients = data.MACoefficients;
    }
}
export class Residuals extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.Array = data.Array;
    }
}
export class SeasonalComponent extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.AR = data.AR;
        this.MA = data.MA;
        this.P = data.P;
        this.D = data.D;
        this.Q = data.Q;
        this.period = data.period;
    }
}
export class SeasonalFactor extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.Array = data.Array;
        this.difference = data.difference;
        this.maximumOrder = data.maximumOrder;
    }
}
export class SeasonalTrendDecomposition extends TimeSeriesAlgorithm {
    constructor(data) {
        super(data);
    }
}
export class SeasonalityExpoSmooth extends PMMLObject {
    constructor(data) {
        super(data);
        this.Array = data.Array;
        this.type = data.type;
        this.period = data.period;
        this.unit = data.unit;
        this.phase = data.phase;
        this.delta = data.delta;
    }
}
export class SpectralAnalysis extends TimeSeriesAlgorithm {
    constructor(data) {
        super(data);
    }
}
export class StateSpaceModel extends TimeSeriesAlgorithm {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.StateVector = data.StateVector;
        this.TransitionMatrix = data.TransitionMatrix;
        this.MeasurementMatrix = data.MeasurementMatrix;
        this.PsiVector = data.PsiVector;
        this.DynamicRegressor = data.DynamicRegressor;
        this.variance = data.variance;
        this.period = data.period;
        this.intercept = data.intercept;
    }
}
export class StateVector extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.Array = data.Array;
    }
}
export class Theta extends PMMLObject {
    constructor(data) {
        super(data);
        this.i = data.i;
        this.j = data.j;
        this.theta = data.theta;
    }
}
export class ThetaRecursionState extends PMMLObject {
    constructor(data) {
        super(data);
        this.FinalNoise = data.FinalNoise;
        this.FinalPredictedNoise = data.FinalPredictedNoise;
        this.FinalTheta = data.FinalTheta;
        this.FinalNu = data.FinalNu;
    }
}
export class TimeAnchor extends PMMLObject {
    constructor(data) {
        super(data);
        this.TimeCycle = data.TimeCycle;
        this.TimeException = data.TimeException;
        this.type = data.type;
        this.offset = data.offset;
        this.stepsize = data.stepsize;
        this.displayName = data.displayName;
    }
}
export class TimeCycle extends PMMLObject {
    constructor(data) {
        super(data);
        this.Array = data.Array;
        this.length = data.length;
        this.type = data.type;
        this.displayName = data.displayName;
    }
}
export class TimeException extends PMMLObject {
    constructor(data) {
        super(data);
        this.Array = data.Array;
        this.type = data.type;
        this.count = data.count;
    }
}
export class TimeSeries extends PMMLObject {
    constructor(data) {
        super(data);
        this.TimeAnchor = data.TimeAnchor;
        this.TimeException = data.TimeException;
        this.TimeValue = data.TimeValue;
        this.usage = data.usage;
        this.startTime = data.startTime;
        this.endTime = data.endTime;
        this.interpolationMethod = data.interpolationMethod;
        this.field = data.field;
    }
}
export class TimeSeriesModel extends Model {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.MiningSchema = data.MiningSchema;
        this.Output = data.Output;
        this.ModelStats = data.ModelStats;
        this.ModelExplanation = data.ModelExplanation;
        this.LocalTransformations = data.LocalTransformations;
        this.TimeSeries = data.TimeSeries;
        this.SpectralAnalysis = data.SpectralAnalysis;
        this.ARIMA = data.ARIMA;
        this.ExponentialSmoothing = data.ExponentialSmoothing;
        this.SeasonalTrendDecomposition = data.SeasonalTrendDecomposition;
        this.StateSpaceModel = data.StateSpaceModel;
        this.GARCH = data.GARCH;
        this.ModelVerification = data.ModelVerification;
        this.modelName = data.modelName;
        this.functionName = data.functionName;
        this.algorithmName = data.algorithmName;
        this.bestFit = data.bestFit;
        this.isScorable = data.isScorable;
        this["x-mathContext"] = data["x-mathContext"];
    }
}
export class TimeValue extends PMMLObject {
    constructor(data) {
        super(data);
        this.Timestamp = data.Timestamp;
        this.index = data.index;
        this.time = data.time;
        this.value = data.value;
        this.standardError = data.standardError;
    }
}
export class TransferFunctionValues extends PMMLObject {
    constructor(data) {
        super(data);
        this.Array = data.Array;
    }
}
export class TransitionMatrix extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.Matrix = data.Matrix;
    }
}
export class TrendCoefficients extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this["REAL-SparseArray"] = data["REAL-SparseArray"];
    }
}
export class TrendExpoSmooth extends PMMLObject {
    constructor(data) {
        super(data);
        this.Array = data.Array;
        this.trend = data.trend;
        this.gamma = data.gamma;
        this.phi = data.phi;
        this.smoothedValue = data.smoothedValue;
    }
}
export class VarianceCoefficients extends PMMLObject {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.PastVariances = data.PastVariances;
        this.MACoefficients = data.MACoefficients;
    }
}
export class Node extends Entity {
    constructor(data) {
        super(data);
    }
}
export class SimpleNode extends Node {
    constructor(data) {
        super(data);
        this.score = data.score;
        this.predicate = data.predicate;
    }
}
export class BranchNode extends SimpleNode {
    constructor(data) {
        super(data);
        this.id = data.id;
        this.defaultChild = data.defaultChild;
        this.nodes = data.nodes;
    }
}
export class ClassifierNode extends SimpleNode {
    constructor(data) {
        super(data);
        this.id = data.id;
        this.recordCount = data.recordCount;
        this.defaultChild = data.defaultChild;
        this.scoreDistributions = data.scoreDistributions;
        this.nodes = data.nodes;
    }
}
export class ComplexNode extends Node {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.predicate = data.predicate;
        this.Partition = data.Partition;
        this.ScoreDistribution = data.ScoreDistribution;
        this.Node = data.Node;
        this.embeddedModel = data.embeddedModel;
        this.id = data.id;
        this.score = data.score;
        this.recordCount = data.recordCount;
        this.defaultChild = data.defaultChild;
    }
}
export class CountingBranchNode extends BranchNode {
    constructor(data) {
        super(data);
        this.recordCount = data.recordCount;
    }
}
export class LeafNode extends SimpleNode {
    constructor(data) {
        super(data);
        this.id = data.id;
    }
}
export class CountingLeafNode extends LeafNode {
    constructor(data) {
        super(data);
        this.recordCount = data.recordCount;
    }
}
export class DecisionTree extends EmbeddedModel {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.Output = data.Output;
        this.ModelStats = data.ModelStats;
        this.Targets = data.Targets;
        this.LocalTransformations = data.LocalTransformations;
        this.ResultField = data.ResultField;
        this.Node = data.Node;
        this.modelName = data.modelName;
        this.functionName = data.functionName;
        this.algorithmName = data.algorithmName;
        this.missingValueStrategy = data.missingValueStrategy;
        this.missingValuePenalty = data.missingValuePenalty;
        this.noTrueChildStrategy = data.noTrueChildStrategy;
        this.splitCharacteristic = data.splitCharacteristic;
    }
}
export class SimplifyingNodeTransformer {
    constructor(data) { }
}
export class TreeModel extends Model {
    constructor(data) {
        super(data);
        this.Extension = data.Extension;
        this.MiningSchema = data.MiningSchema;
        this.Output = data.Output;
        this.ModelStats = data.ModelStats;
        this.ModelExplanation = data.ModelExplanation;
        this.Targets = data.Targets;
        this.LocalTransformations = data.LocalTransformations;
        this.Node = data.Node;
        this.ModelVerification = data.ModelVerification;
        this.modelName = data.modelName;
        this.functionName = data.functionName;
        this.algorithmName = data.algorithmName;
        this.missingValueStrategy = data.missingValueStrategy;
        this.missingValuePenalty = data.missingValuePenalty;
        this.noTrueChildStrategy = data.noTrueChildStrategy;
        this.splitCharacteristic = data.splitCharacteristic;
        this.isScorable = data.isScorable;
        this["x-mathContext"] = data["x-mathContext"];
    }
}
//# sourceMappingURL=pmml4_4.js.map