import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { useMemo } from "react";
import { Link } from "react-router-dom";
import { PageSection } from "@patternfly/react-core/dist/js/components/Page";
import { Breadcrumb, BreadcrumbItem } from "@patternfly/react-core/dist/js/components/Breadcrumb";
import { PageTitle } from "../PageTitle";
import { componentOuiaProps } from "../../ouiaTools";
export const PageSectionHeader = ({ titleText, breadcrumbText, breadcrumbPath, ouiaId, ouiaSafe, }) => {
    const breadcrumbContent = useMemo(() => {
        const items = [];
        if (!breadcrumbPath || !breadcrumbText) {
            return;
        }
        breadcrumbText === null || breadcrumbText === void 0 ? void 0 : breadcrumbText.forEach((text, index) => {
            if (index === breadcrumbText.length - 1) {
                items.push(_jsx(BreadcrumbItem, { isActive: true, children: text }, index));
            }
            else {
                items.push(_jsx(BreadcrumbItem, { children: _jsx(Link, { to: breadcrumbPath[index], children: text }) }, index));
            }
        });
        return items;
    }, [breadcrumbPath, breadcrumbText]);
    return (_jsxs(PageSection, { variant: "light", ...componentOuiaProps(ouiaId, "page-section-header", ouiaSafe), children: [breadcrumbContent && _jsx(Breadcrumb, { children: breadcrumbContent }), _jsx(PageTitle, { title: titleText })] }));
};
//# sourceMappingURL=PageSectionHeader.js.map