import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import { DrawerActions, DrawerCloseButton, DrawerHead, DrawerPanelContent, } from "@patternfly/react-core/dist/js/components/Drawer";
import { useMemo } from "react";
import { buildXmlHref } from "@kie-tools/dmn-marshaller/dist/xml/xmlHrefs";
import { SingleNodeProperties } from "./SingleNodeProperties";
import { generateBoxedExpressionIndex } from "../boxedExpressions/boxedExpressionIndex";
import { Form, FormSection } from "@patternfly/react-core/dist/js/components/Form";
import { RelationInformationItemCell } from "./BoxedExpressionPropertiesPanelComponents/RelationInformationItemCell";
import { DecisionTableInputHeaderCell } from "./BoxedExpressionPropertiesPanelComponents/DecisionTableInputHeaderCell";
import { DecisionTableOutputHeaderCell } from "./BoxedExpressionPropertiesPanelComponents/DecisionTableOutputHeaderCell";
import { LiteralExpressionContentCell } from "./BoxedExpressionPropertiesPanelComponents/LiteralExpressionContentCell";
import { ExpressionRootCell } from "./BoxedExpressionPropertiesPanelComponents/ExpressionRootCell";
import { DecisionTableInputRule } from "./BoxedExpressionPropertiesPanelComponents/DecisionTableInputRuleCell";
import { DecisionTableRootCell } from "./BoxedExpressionPropertiesPanelComponents/DecisionTableRootCell";
import { InvocationFunctionCallCell } from "./BoxedExpressionPropertiesPanelComponents/InvocationFunctionCallCell";
import { FunctionDefinitionParameterCell } from "./BoxedExpressionPropertiesPanelComponents/FunctionDefinitionParametersCell";
import { FunctionDefinitionRootCell } from "./BoxedExpressionPropertiesPanelComponents/FunctionDefinitionRootCell";
import { WithoutPropertiesCell } from "./BoxedExpressionPropertiesPanelComponents/WithoutPropertiesCell";
import { DecisionTableOutputRuleCell } from "./BoxedExpressionPropertiesPanelComponents/DecisionTableOutputRuleCell";
import { ContextInformationItemCell } from "./BoxedExpressionPropertiesPanelComponents/ContextInformationItemCell";
import { InvocationInformationItemCell } from "./BoxedExpressionPropertiesPanelComponents/InvocationInformationItemCell";
import { SelectExpressionCell } from "./BoxedExpressionPropertiesPanelComponents/SelectExpressionCell";
import { BoxedExpressionPropertiesPanelComponent, getBoxedExpressionPropertiesPanelComponent, } from "./BoxedExpressionPropertiesPanelComponents/getBoxedExpressionPropertiesPanelComponent";
import { useDmnEditorStore, useDmnEditorStoreApi } from "../store/StoreContext";
import { useExternalModels } from "../includedModels/DmnEditorDependenciesContext";
import { drgElementToBoxedExpression } from "../boxedExpressions/BoxedExpressionScreen";
import { IteratorVariableCell } from "./BoxedExpressionPropertiesPanelComponents/IteratorVariableCell";
import { useSettings } from "../settings/DmnEditorSettingsContext";
import { getOperatingSystem, OperatingSystem } from "@kie-tools-core/operating-system";
export function BoxedExpressionPropertiesPanel() {
    var _a;
    const dmnEditorStoreApi = useDmnEditorStoreApi();
    const thisDmnsNamespace = useDmnEditorStore((s) => s.dmn.model.definitions["@_namespace"]);
    const selectedObjectId = useDmnEditorStore((s) => s.boxedExpressionEditor.selectedObjectId);
    const activeDrgElementId = useDmnEditorStore((s) => s.boxedExpressionEditor.activeDrgElementId);
    const { externalModelsByNamespace } = useExternalModels();
    const settings = useSettings();
    const shouldDisplayDecisionOrBkmProps = useMemo(() => selectedObjectId === undefined || (selectedObjectId && selectedObjectId === activeDrgElementId), [activeDrgElementId, selectedObjectId]);
    const node = useDmnEditorStore((s) => s
        .computed(s)
        .getDiagramData(externalModelsByNamespace)
        .nodesById.get(buildXmlHref({ id: activeDrgElementId !== null && activeDrgElementId !== void 0 ? activeDrgElementId : "" })));
    const isReadOnly = settings.isReadOnly || (!!(node === null || node === void 0 ? void 0 : node.data.dmnObjectNamespace) && node.data.dmnObjectNamespace !== thisDmnsNamespace);
    const boxedExpressionIndex = useMemo(() => {
        var _a, _b;
        if ((node === null || node === void 0 ? void 0 : node.data.dmnObject) === undefined) {
            return;
        }
        if (((_a = node.data.dmnObject) === null || _a === void 0 ? void 0 : _a.__$$element) === "businessKnowledgeModel" ||
            ((_b = node.data.dmnObject) === null || _b === void 0 ? void 0 : _b.__$$element) === "decision") {
            const expression = drgElementToBoxedExpression(node.data.dmnObject);
            return expression ? generateBoxedExpressionIndex(expression, new Map(), []) : undefined;
        }
        return;
    }, [node === null || node === void 0 ? void 0 : node.data.dmnObject]);
    const boxedExpressionPropertiesPanelComponent = useMemo(() => {
        const selectedObjectInfos = boxedExpressionIndex === null || boxedExpressionIndex === void 0 ? void 0 : boxedExpressionIndex.get(selectedObjectId !== null && selectedObjectId !== void 0 ? selectedObjectId : "");
        const selectedObjectPath = selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.expressionPath[selectedObjectInfos.expressionPath.length - 1];
        if (!selectedObjectPath) {
            return;
        }
        return getBoxedExpressionPropertiesPanelComponent(selectedObjectPath);
    }, [boxedExpressionIndex, selectedObjectId]);
    return (_jsx(_Fragment, { children: node && (_jsx(DrawerPanelContent, { "data-testid": "kie-tools--dmn-editor--bee-properties-panel-container", isResizable: true, minSize: "300px", defaultSize: "500px", onKeyDown: (e) => {
                if (!(getOperatingSystem() === OperatingSystem.MACOS && e.metaKey)) {
                    e.stopPropagation();
                }
            }, children: _jsxs(DrawerHead, { children: [shouldDisplayDecisionOrBkmProps && _jsx(SingleNodeProperties, { nodeId: node.id }), _jsx(DrawerActions, { children: _jsx(DrawerCloseButton, { onClick: () => {
                                dmnEditorStoreApi.setState((state) => {
                                    state.boxedExpressionEditor.propertiesPanel.isOpen = false;
                                });
                            } }) }), !shouldDisplayDecisionOrBkmProps && (_jsx(Form, { children: _jsxs(FormSection, { title: (_a = boxedExpressionPropertiesPanelComponent === null || boxedExpressionPropertiesPanelComponent === void 0 ? void 0 : boxedExpressionPropertiesPanelComponent.title) !== null && _a !== void 0 ? _a : "", children: [(((selectedObjectId === undefined || selectedObjectId === "") &&
                                    boxedExpressionPropertiesPanelComponent === undefined) ||
                                    (boxedExpressionPropertiesPanelComponent === null || boxedExpressionPropertiesPanelComponent === void 0 ? void 0 : boxedExpressionPropertiesPanelComponent.component) ===
                                        BoxedExpressionPropertiesPanelComponent.WITHOUT_PROPERTIES_CELL) && _jsx(WithoutPropertiesCell, {}), selectedObjectId !== "" && boxedExpressionPropertiesPanelComponent === undefined && (_jsx(SelectExpressionCell, { selectedObjectId: selectedObjectId })), (boxedExpressionPropertiesPanelComponent === null || boxedExpressionPropertiesPanelComponent === void 0 ? void 0 : boxedExpressionPropertiesPanelComponent.component) ===
                                    BoxedExpressionPropertiesPanelComponent.CONTEXT_INFORMATION_ITEM_CELL && (_jsx(ContextInformationItemCell, { boxedExpressionIndex: boxedExpressionIndex, isReadOnly: isReadOnly })), (boxedExpressionPropertiesPanelComponent === null || boxedExpressionPropertiesPanelComponent === void 0 ? void 0 : boxedExpressionPropertiesPanelComponent.component) ===
                                    BoxedExpressionPropertiesPanelComponent.DECISION_TABLE_INPUT_HEADER && (_jsx(DecisionTableInputHeaderCell, { boxedExpressionIndex: boxedExpressionIndex, isReadOnly: isReadOnly })), (boxedExpressionPropertiesPanelComponent === null || boxedExpressionPropertiesPanelComponent === void 0 ? void 0 : boxedExpressionPropertiesPanelComponent.component) ===
                                    BoxedExpressionPropertiesPanelComponent.DECISION_TABLE_INPUT_RULE && (_jsx(DecisionTableInputRule, { boxedExpressionIndex: boxedExpressionIndex, isReadOnly: isReadOnly })), (boxedExpressionPropertiesPanelComponent === null || boxedExpressionPropertiesPanelComponent === void 0 ? void 0 : boxedExpressionPropertiesPanelComponent.component) ===
                                    BoxedExpressionPropertiesPanelComponent.DECISION_TABLE_OUTPUT_HEADER && (_jsx(DecisionTableOutputHeaderCell, { boxedExpressionIndex: boxedExpressionIndex, isReadOnly: isReadOnly })), (boxedExpressionPropertiesPanelComponent === null || boxedExpressionPropertiesPanelComponent === void 0 ? void 0 : boxedExpressionPropertiesPanelComponent.component) ===
                                    BoxedExpressionPropertiesPanelComponent.DECISION_TABLE_OUTPUT_RULE && (_jsx(DecisionTableOutputRuleCell, { boxedExpressionIndex: boxedExpressionIndex, isReadOnly: isReadOnly })), (boxedExpressionPropertiesPanelComponent === null || boxedExpressionPropertiesPanelComponent === void 0 ? void 0 : boxedExpressionPropertiesPanelComponent.component) ===
                                    BoxedExpressionPropertiesPanelComponent.DECISION_TABLE_ROOT && (_jsx(DecisionTableRootCell, { boxedExpressionIndex: boxedExpressionIndex, isReadOnly: isReadOnly })), (boxedExpressionPropertiesPanelComponent === null || boxedExpressionPropertiesPanelComponent === void 0 ? void 0 : boxedExpressionPropertiesPanelComponent.component) ===
                                    BoxedExpressionPropertiesPanelComponent.EXPRESSION_ROOT && (_jsx(ExpressionRootCell, { boxedExpressionIndex: boxedExpressionIndex, isReadOnly: isReadOnly })), (boxedExpressionPropertiesPanelComponent === null || boxedExpressionPropertiesPanelComponent === void 0 ? void 0 : boxedExpressionPropertiesPanelComponent.component) ===
                                    BoxedExpressionPropertiesPanelComponent.FUNCTION_DEFINITION_PARAMETERS && (_jsx(FunctionDefinitionParameterCell, { boxedExpressionIndex: boxedExpressionIndex, isReadOnly: isReadOnly })), (boxedExpressionPropertiesPanelComponent === null || boxedExpressionPropertiesPanelComponent === void 0 ? void 0 : boxedExpressionPropertiesPanelComponent.component) ===
                                    BoxedExpressionPropertiesPanelComponent.FUNCTION_DEFINITION_ROOT && (_jsx(FunctionDefinitionRootCell, { boxedExpressionIndex: boxedExpressionIndex, isReadOnly: isReadOnly })), (boxedExpressionPropertiesPanelComponent === null || boxedExpressionPropertiesPanelComponent === void 0 ? void 0 : boxedExpressionPropertiesPanelComponent.component) ===
                                    BoxedExpressionPropertiesPanelComponent.INVOCATION_FUNCTION_CALL && (_jsx(InvocationFunctionCallCell, { boxedExpressionIndex: boxedExpressionIndex, isReadOnly: isReadOnly })), (boxedExpressionPropertiesPanelComponent === null || boxedExpressionPropertiesPanelComponent === void 0 ? void 0 : boxedExpressionPropertiesPanelComponent.component) ===
                                    BoxedExpressionPropertiesPanelComponent.INVOCATION_INFORMATION_ITEM_CELL && (_jsx(InvocationInformationItemCell, { boxedExpressionIndex: boxedExpressionIndex, isReadOnly: isReadOnly })), (boxedExpressionPropertiesPanelComponent === null || boxedExpressionPropertiesPanelComponent === void 0 ? void 0 : boxedExpressionPropertiesPanelComponent.component) ===
                                    BoxedExpressionPropertiesPanelComponent.ITERATOR_VARIABLE_CELL && (_jsx(IteratorVariableCell, { boxedExpressionIndex: boxedExpressionIndex, isReadOnly: isReadOnly })), (boxedExpressionPropertiesPanelComponent === null || boxedExpressionPropertiesPanelComponent === void 0 ? void 0 : boxedExpressionPropertiesPanelComponent.component) ===
                                    BoxedExpressionPropertiesPanelComponent.LITERAL_EXPRESSION_CONTENT && (_jsx(LiteralExpressionContentCell, { boxedExpressionIndex: boxedExpressionIndex, isReadOnly: isReadOnly })), (boxedExpressionPropertiesPanelComponent === null || boxedExpressionPropertiesPanelComponent === void 0 ? void 0 : boxedExpressionPropertiesPanelComponent.component) ===
                                    BoxedExpressionPropertiesPanelComponent.RELATION_INFORMATION_ITEM_CELL && (_jsx(RelationInformationItemCell, { boxedExpressionIndex: boxedExpressionIndex, isReadOnly: isReadOnly }))] }) }))] }) })) }));
}
//# sourceMappingURL=BoxedExpressionPropertiesPanel.js.map