import { traverseExpressionsInExpressionHolders, traverseItemDefinitions, traverseTypeRefedInExpressionHolders, } from "../dataTypes/DataTypeSpec";
import { buildFeelQName, parseFeelQName } from "../feel/parseFeelQName";
import { DMN15_SPEC } from "@kie-tools/dmn-marshaller/dist/schemas/dmn-1_5/Dmn15Spec";
import { IdentifiersRefactor } from "@kie-tools/dmn-language-service";
export function renameImport({ definitions, newName, allTopLevelDataTypesByFeelName, index, externalModelsByNamespaceMap, }) {
    var _a, _b, _c, _d, _e;
    const trimmedNewName = newName.trim();
    const identifiersRefactor = new IdentifiersRefactor({
        writeableDmnDefinitions: definitions,
        _readonly_externalDmnModelsByNamespaceMap: externalModelsByNamespaceMap !== null && externalModelsByNamespaceMap !== void 0 ? externalModelsByNamespaceMap : new Map(),
    });
    const _import = definitions.import[index];
    traverseItemDefinitions((_a = definitions.itemDefinition) !== null && _a !== void 0 ? _a : [], (item) => {
        var _a;
        if (item.typeRef) {
            const feelQName = parseFeelQName(item.typeRef.__$$text);
            if (((_a = allTopLevelDataTypesByFeelName.get(item.typeRef.__$$text)) === null || _a === void 0 ? void 0 : _a.namespace) === _import["@_namespace"]) {
                item.typeRef = {
                    __$$text: buildFeelQName({
                        type: "feel-qname",
                        importName: trimmedNewName,
                        localPart: feelQName.localPart,
                    }),
                };
            }
        }
    });
    (_b = definitions.drgElement) !== null && _b !== void 0 ? _b : (definitions.drgElement = []);
    for (let i = 0; i < definitions.drgElement.length; i++) {
        const element = definitions.drgElement[i];
        if (element.__$$element === "inputData" ||
            element.__$$element === "decision" ||
            element.__$$element === "businessKnowledgeModel" ||
            element.__$$element === "decisionService") {
            if ((_c = element.variable) === null || _c === void 0 ? void 0 : _c["@_typeRef"]) {
                if (((_e = allTopLevelDataTypesByFeelName.get((_d = element.variable) === null || _d === void 0 ? void 0 : _d["@_typeRef"])) === null || _e === void 0 ? void 0 : _e.namespace) === _import["@_namespace"]) {
                    const feelQName = parseFeelQName(element.variable["@_typeRef"]);
                    element.variable["@_typeRef"] = buildFeelQName({
                        type: "feel-qname",
                        importName: trimmedNewName,
                        localPart: feelQName.localPart,
                    });
                }
            }
            if (element.__$$element === "decision" || element.__$$element === "businessKnowledgeModel") {
                traverseExpressionsInExpressionHolders(element, (expression, __$$element) => {
                    var _a, _b;
                    if (__$$element === "functionDefinition") {
                        const e = expression;
                        if (e["@_kind"] === "PMML") {
                            const pmmlDocument = (_a = e.expression.contextEntry) === null || _a === void 0 ? void 0 : _a.find(({ variable }) => (variable === null || variable === void 0 ? void 0 : variable["@_name"]) === DMN15_SPEC.BOXED.FUNCTION.PMML.documentFieldName);
                            const pmmlDocumentLiteralExpression = pmmlDocument === null || pmmlDocument === void 0 ? void 0 : pmmlDocument.expression;
                            if (((_b = pmmlDocumentLiteralExpression === null || pmmlDocumentLiteralExpression === void 0 ? void 0 : pmmlDocumentLiteralExpression.text) === null || _b === void 0 ? void 0 : _b.__$$text) === _import["@_name"]) {
                                pmmlDocumentLiteralExpression.text = { __$$text: trimmedNewName };
                            }
                        }
                    }
                });
                traverseTypeRefedInExpressionHolders(element, (typeRefed) => {
                    var _a;
                    if (typeRefed["@_typeRef"]) {
                        if (((_a = allTopLevelDataTypesByFeelName.get(typeRefed["@_typeRef"])) === null || _a === void 0 ? void 0 : _a.namespace) === _import["@_namespace"]) {
                            const feelQName = parseFeelQName(typeRefed["@_typeRef"]);
                            typeRefed["@_typeRef"] = buildFeelQName({
                                type: "feel-qname",
                                importName: trimmedNewName,
                                localPart: feelQName.localPart,
                            });
                        }
                    }
                });
            }
        }
    }
    identifiersRefactor.renameImport({ oldName: _import["@_name"], newName: trimmedNewName });
    _import["@_name"] = trimmedNewName;
}
//# sourceMappingURL=renameImport.js.map