import { parseXmlHref } from "@kie-tools/dmn-marshaller/dist/xml/xmlHrefs";
import { repopulateInputDataAndDecisionsOnDecisionService } from "./repopulateInputDataAndDecisionsOnDecisionService";
export function deleteDecisionFromDecisionService({ definitions, decisionHref, decisionServiceId, externalModelsByNamespace, }) {
    var _a, _b, _c, _d;
    console.debug(`DMN MUTATION: Deleting Decision '${decisionHref}' from Decision Service '${decisionServiceId}'`);
    const href = parseXmlHref(decisionHref);
    if (href.namespace) {
        const externalModel = externalModelsByNamespace === null || externalModelsByNamespace === void 0 ? void 0 : externalModelsByNamespace[href.namespace];
        if (!externalModel) {
            throw new Error(`DMN MUTATION: Namespace '${href.namespace}' not found.`);
        }
        if ((externalModel === null || externalModel === void 0 ? void 0 : externalModel.type) !== "dmn") {
            throw new Error(`DMN MUTATION: External model with namespace ${href.namespace} is not a DMN.`);
        }
        const externalDrgs = externalModel.model.definitions.drgElement;
        const decision = externalDrgs === null || externalDrgs === void 0 ? void 0 : externalDrgs.find((drgElement) => drgElement["@_id"] === href.id);
        if ((decision === null || decision === void 0 ? void 0 : decision.__$$element) !== "decision") {
            throw new Error(`DMN MUTATION: DRG Element with id '${href.id}' is either not a Decision or doesn't exist in the external model '${href.namespace}'`);
        }
    }
    else {
        const decision = (_a = definitions.drgElement) === null || _a === void 0 ? void 0 : _a.find((s) => s["@_id"] === href.id);
        if ((decision === null || decision === void 0 ? void 0 : decision.__$$element) !== "decision") {
            throw new Error(`DMN MUTATION: DRG Element with id '${href.id}' is either not a Decision or doesn't exist.`);
        }
    }
    const decisionService = (_b = definitions.drgElement) === null || _b === void 0 ? void 0 : _b.find((s) => s["@_id"] === decisionServiceId);
    if ((decisionService === null || decisionService === void 0 ? void 0 : decisionService.__$$element) !== "decisionService") {
        throw new Error(`DMN MUTATION: DRG Element with id '${decisionServiceId}' is either not a Decision Service or doesn't exist.`);
    }
    decisionService.outputDecision = ((_c = decisionService.outputDecision) !== null && _c !== void 0 ? _c : []).filter((od) => od["@_href"] !== decisionHref);
    decisionService.encapsulatedDecision = ((_d = decisionService.encapsulatedDecision) !== null && _d !== void 0 ? _d : []).filter((ed) => ed["@_href"] !== decisionHref);
    repopulateInputDataAndDecisionsOnDecisionService({ definitions, decisionService, externalModelsByNamespace });
}
//# sourceMappingURL=deleteDecisionFromDecisionService.js.map