import { generateUuid } from "@kie-tools/boxed-expression-component/dist/api";
import { addNamespaceToHref, parseXmlHref } from "@kie-tools/dmn-marshaller/dist/xml/xmlHrefs";
import ELK from "elkjs/lib/elk.bundled.js";
import { getAdjMatrix, traverse } from "../diagram/graph/graph";
import { getContainmentRelationship } from "../diagram/maths/DmnMaths";
import { DEFAULT_NODE_SIZES, MIN_NODE_SIZES } from "../diagram/nodes/DefaultSizes";
import { NODE_TYPES } from "../diagram/nodes/NodeTypes";
const elk = new ELK();
export const ELK_OPTIONS = {
    "elk.algorithm": "layered",
    "elk.direction": "UP",
    "elk.aspectRatio": "9999999999",
    "elk.spacing.nodeNode": "60",
    "elk.spacing.componentComponent": "200",
    "layered.spacing.edgeEdgeBetweenLayers": "0",
    "layered.spacing.edgeNodeBetweenLayers": "0",
    "layered.spacing.nodeNodeBetweenLayers": "100",
    "elk.edgeRouting": "ORTHOGONAL",
    "elk.layered.mergeEdges": "true",
    "elk.layered.mergeHierarchyEdges": "true",
    "elk.partitioning.activate": "true",
    "elk.nodePlacement.favorStraightEdges": "true",
    "elk.nodePlacement.bk.fixedAlignment": "LEFTDOWN",
    "elk.nodePlacement.bk.edgeStraightening": "IMPROVE_STRAIGHTNESS",
    "layering.strategy": "LONGEST_PATH_SOURCE",
};
const PARENT_NODE_ELK_OPTIONS = {
    "elk.padding": "[left=60, top=60, right=80, bottom=60]",
    "elk.spacing.componentComponent": "60",
};
export const FAKE_MARKER = "__$FAKE$__";
export async function getAutoLayoutedInfo({ __readonly_snapGrid, __readonly_nodesById, __readonly_edgesById, __readonly_nodes, __readonly_drgEdges, __readonly_isAlternativeInputDataShape, }) {
    var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l;
    const parentNodesById = new Map();
    const nodeParentsById = new Map();
    const fakeEdgesForElk = new Set();
    const adjMatrix = getAdjMatrix(__readonly_drgEdges);
    for (const node of __readonly_nodes) {
        const dependencies = new Set();
        const dependents = new Set();
        if (((_b = (_a = node.data) === null || _a === void 0 ? void 0 : _a.dmnObject) === null || _b === void 0 ? void 0 : _b.__$$element) === "decisionService") {
            const { namespace } = parseXmlHref(node.id);
            const outputs = new Set([
                ...((_c = node.data.dmnObject.outputDecision) !== null && _c !== void 0 ? _c : []).map((s) => addNamespaceToHref({ href: s["@_href"], namespace })),
            ]);
            const encapsulated = new Set([
                ...((_d = node.data.dmnObject.encapsulatedDecision) !== null && _d !== void 0 ? _d : []).map((s) => addNamespaceToHref({ href: s["@_href"], namespace })),
            ]);
            const idOfFakeNodeForOutputSection = `${node.id}${FAKE_MARKER}dsOutput`;
            const idOfFakeNodeForEncapsulatedSection = `${node.id}${FAKE_MARKER}dsEncapsulated`;
            const dsSize = MIN_NODE_SIZES[NODE_TYPES.decisionService]({ snapGrid: __readonly_snapGrid });
            parentNodesById.set(node.id, {
                elkNode: {
                    id: node.id,
                    width: dsSize["@_width"],
                    height: dsSize["@_height"],
                    children: [
                        {
                            id: idOfFakeNodeForOutputSection,
                            width: dsSize["@_width"],
                            height: dsSize["@_height"] / 2,
                            children: [],
                            layoutOptions: {
                                ...ELK_OPTIONS,
                                ...PARENT_NODE_ELK_OPTIONS,
                            },
                        },
                        {
                            id: idOfFakeNodeForEncapsulatedSection,
                            width: dsSize["@_width"],
                            height: dsSize["@_height"] / 2,
                            children: [],
                            layoutOptions: {
                                ...ELK_OPTIONS,
                                ...PARENT_NODE_ELK_OPTIONS,
                            },
                        },
                    ],
                    layoutOptions: {
                        "elk.algorithm": "layered",
                        "elk.direction": "UP",
                        "elk.aspectRatio": "9999999999",
                        "elk.partitioning.activate": "true",
                        "elk.spacing.nodeNode": "0",
                        "elk.spacing.componentComponent": "0",
                        "layered.spacing.edgeEdgeBetweenLayers": "0",
                        "layered.spacing.edgeNodeBetweenLayers": "0",
                        "layered.spacing.nodeNodeBetweenLayers": "0",
                        "elk.padding": "[left=0, top=0, right=0, bottom=0]",
                    },
                },
                decisionServiceSection: "output",
                dependencies,
                dependents,
                contained: outputs,
                contains: ({ id }) => ({
                    isInside: outputs.has(id) || encapsulated.has(id),
                    decisionServiceSection: outputs.has(id) ? "output" : encapsulated.has(id) ? "encapsulated" : "n/a",
                }),
                isDependencyOf: ({ id }) => dependents.has(id),
                hasDependencyTo: ({ id }) => dependencies.has(id),
            });
            fakeEdgesForElk.add({
                id: `${node.id}${FAKE_MARKER}fakeOutputEncapsulatedEdge`,
                sources: [idOfFakeNodeForEncapsulatedSection],
                targets: [idOfFakeNodeForOutputSection],
            });
        }
        else if (((_f = (_e = node.data) === null || _e === void 0 ? void 0 : _e.dmnObject) === null || _f === void 0 ? void 0 : _f.__$$element) === "group") {
            const groupSize = DEFAULT_NODE_SIZES[NODE_TYPES.group]({ snapGrid: __readonly_snapGrid });
            const groupBounds = node.data.shape["dc:Bounds"];
            parentNodesById.set(node.id, {
                decisionServiceSection: "n/a",
                elkNode: {
                    id: node.id,
                    width: (_g = groupBounds === null || groupBounds === void 0 ? void 0 : groupBounds["@_width"]) !== null && _g !== void 0 ? _g : groupSize["@_width"],
                    height: (_h = groupBounds === null || groupBounds === void 0 ? void 0 : groupBounds["@_height"]) !== null && _h !== void 0 ? _h : groupSize["@_height"],
                    children: [],
                    layoutOptions: {
                        ...ELK_OPTIONS,
                        ...PARENT_NODE_ELK_OPTIONS,
                    },
                },
                dependencies,
                dependents,
                contained: new Set(),
                contains: ({ id, bounds }) => {
                    var _a;
                    return ({
                        isInside: getContainmentRelationship({
                            bounds: bounds,
                            container: groupBounds,
                            snapGrid: __readonly_snapGrid,
                            isAlternativeInputDataShape: __readonly_isAlternativeInputDataShape,
                            containerMinSizes: MIN_NODE_SIZES[NODE_TYPES.group],
                            boundsMinSizes: MIN_NODE_SIZES[(_a = __readonly_nodesById.get(id)) === null || _a === void 0 ? void 0 : _a.type],
                        }).isInside,
                        decisionServiceSection: "n/a",
                    });
                },
                isDependencyOf: ({ id }) => dependents.has(id),
                hasDependencyTo: ({ id }) => dependencies.has(id),
            });
        }
    }
    const elkNodes = __readonly_nodes.flatMap((node) => {
        var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l;
        const parent = parentNodesById.get(node.id);
        if (parent) {
            return [];
        }
        const defaultSize = DEFAULT_NODE_SIZES[node.type]({
            snapGrid: __readonly_snapGrid,
            isAlternativeInputDataShape: __readonly_isAlternativeInputDataShape,
        });
        const elkNode = {
            id: node.id,
            width: (_b = (_a = node.data.shape["dc:Bounds"]) === null || _a === void 0 ? void 0 : _a["@_width"]) !== null && _b !== void 0 ? _b : defaultSize["@_width"],
            height: (_d = (_c = node.data.shape["dc:Bounds"]) === null || _c === void 0 ? void 0 : _c["@_height"]) !== null && _d !== void 0 ? _d : defaultSize["@_height"],
            children: [],
            layoutOptions: {
                "partitioning.partition": node.type === NODE_TYPES.textAnnotation ||
                    node.type === NODE_TYPES.knowledgeSource
                    ? "0"
                    : "1",
            },
        };
        const parents = [...parentNodesById.values()].filter((p) => p.contains({ id: elkNode.id, bounds: node.data.shape["dc:Bounds"] }).isInside);
        if (parents.length > 0) {
            const decisionServiceSection = parents[0].contains({
                id: elkNode.id,
                bounds: node.data.shape["dc:Bounds"],
            }).decisionServiceSection;
            if (decisionServiceSection === "n/a") {
                (_e = parents[0].elkNode.children) === null || _e === void 0 ? void 0 : _e.push(elkNode);
            }
            else if (decisionServiceSection === "output") {
                (_g = (_f = parents[0].elkNode.children) === null || _f === void 0 ? void 0 : _f[0].children) === null || _g === void 0 ? void 0 : _g.push(elkNode);
            }
            else if (decisionServiceSection === "encapsulated") {
                (_j = (_h = parents[0].elkNode.children) === null || _h === void 0 ? void 0 : _h[1].children) === null || _j === void 0 ? void 0 : _j.push(elkNode);
            }
            else {
                throw new Error(`Unknown decisionServiceSection ${decisionServiceSection}`);
            }
            for (const p of parents) {
                (_k = p.contained) === null || _k === void 0 ? void 0 : _k.add(elkNode.id);
                nodeParentsById.set(node.id, new Set([...((_l = nodeParentsById.get(node.id)) !== null && _l !== void 0 ? _l : []), p.elkNode.id]));
            }
            return [];
        }
        return [elkNode];
    });
    for (const [_, parentNode] of parentNodesById) {
        traverse(adjMatrix, parentNode.contained, [...parentNode.contained], "down", (n) => {
            parentNode.dependencies.add(n);
        });
        traverse(adjMatrix, parentNode.contained, [...parentNode.contained], "up", (n) => {
            parentNode.dependents.add(n);
        });
        const p = __readonly_nodesById.get(parentNode.elkNode.id);
        if ((p === null || p === void 0 ? void 0 : p.type) === NODE_TYPES.group && ((_j = parentNode.elkNode.children) === null || _j === void 0 ? void 0 : _j.length) === 0) {
            continue;
        }
        else {
            elkNodes.push(parentNode.elkNode);
        }
    }
    for (const node of __readonly_nodes) {
        const parentNodes = [...parentNodesById.values()];
        const dependents = parentNodes.filter((p) => p.hasDependencyTo({ id: node.id }));
        for (const dependent of dependents) {
            if (__readonly_nodesById.has(node.id) && __readonly_nodesById.has(dependent.elkNode.id)) {
                fakeEdgesForElk.add({
                    id: `${generateUuid()}${FAKE_MARKER}__fake`,
                    sources: [node.id],
                    targets: [dependent.elkNode.id],
                });
            }
            for (const p of (_k = nodeParentsById.get(node.id)) !== null && _k !== void 0 ? _k : []) {
                if (__readonly_nodesById.has(p) && __readonly_nodesById.has(dependent.elkNode.id)) {
                    fakeEdgesForElk.add({
                        id: `${generateUuid()}${FAKE_MARKER}__fake`,
                        sources: [p],
                        targets: [dependent.elkNode.id],
                    });
                }
            }
        }
        const dependencies = parentNodes.filter((p) => p.isDependencyOf({ id: node.id }));
        for (const dependency of dependencies) {
            if (__readonly_nodesById.has(node.id) && __readonly_nodesById.has(dependency.elkNode.id)) {
                fakeEdgesForElk.add({
                    id: `${generateUuid()}${FAKE_MARKER}__fake`,
                    sources: [dependency.elkNode.id],
                    targets: [node.id],
                });
            }
            for (const p of (_l = nodeParentsById.get(node.id)) !== null && _l !== void 0 ? _l : []) {
                if (__readonly_nodesById.has(p) && __readonly_nodesById.has(dependency.elkNode.id)) {
                    fakeEdgesForElk.add({
                        id: `${generateUuid()}${FAKE_MARKER}__fake`,
                        sources: [dependency.elkNode.id],
                        targets: [p],
                    });
                }
            }
        }
    }
    const elkEdges = [
        ...fakeEdgesForElk,
        ...[...__readonly_edgesById.values()].flatMap((e) => {
            if (__readonly_nodesById.has(e.source) && __readonly_nodesById.has(e.target)) {
                return {
                    id: e.id,
                    sources: [e.source],
                    targets: [e.target],
                };
            }
            else {
                return [];
            }
        }),
    ];
    const autoLayoutedInfo = await runElk(elkNodes, elkEdges, ELK_OPTIONS);
    return {
        __readonly_autoLayoutedInfo: autoLayoutedInfo,
        __readonly_parentNodesById: parentNodesById,
    };
}
async function runElk(nodes, edges, options = {}) {
    const isHorizontal = (options === null || options === void 0 ? void 0 : options["elk.direction"]) === "RIGHT";
    const graph = {
        id: "root",
        layoutOptions: options,
        children: nodes,
        edges,
    };
    const layoutedGraph = await elk.layout(graph);
    return {
        isHorizontal,
        nodes: layoutedGraph.children,
        edges: layoutedGraph.edges,
    };
}
export function visitNodeAndNested(elkNode, positionOffset, visitor) {
    var _a;
    visitor(elkNode, positionOffset);
    for (const nestedNode of (_a = elkNode.children) !== null && _a !== void 0 ? _a : []) {
        visitNodeAndNested(nestedNode, {
            x: elkNode.x + positionOffset.x,
            y: elkNode.y + positionOffset.y,
        }, visitor);
    }
}
//# sourceMappingURL=autoLayoutInfo.js.map