import { jsx as _jsx } from "react/jsx-runtime";
import { useMemo } from "react";
import CloudEventFormContext from "./CloudEventFormContext";
import { CloudEventFormGatewayApiImpl } from "./CloudEventFormGatewayApi";
export function CloudEventFormContextProvider(props) {
    const { proxyEndpoint } = props;
    const gatewayApi = useMemo(() => new CloudEventFormGatewayApiImpl(proxyEndpoint), [proxyEndpoint]);
    return _jsx(CloudEventFormContext.Provider, { value: gatewayApi, children: props.children });
}
export default CloudEventFormContextProvider;
//# sourceMappingURL=CloudEventFormContextProvider.js.map