import { EditorContent, KogitoEditorChannelApi, StateControlCommand } from "@kie-tools-core/editor/dist/api";
import { I18n } from "@kie-tools-core/i18n/dist/core";
import { Notification } from "@kie-tools-core/notifications/dist/api";
import { JavaCodeCompletionAccessor, JavaCodeCompletionApi, JavaCodeCompletionChannelApi, JavaCodeCompletionClass } from "@kie-tools-core/vscode-java-code-completion/dist/api";
import { ResourceContentRequest, ResourceContentService, ResourceListRequest, WorkspaceEdit } from "@kie-tools-core/workspace/dist/api";
import { VsCodeKieEditorController } from "./VsCodeKieEditorController";
import { VsCodeI18n } from "./i18n";
import { VsCodeNotificationsChannelApiImpl } from "./notifications/VsCodeNotificationsChannelApiImpl";
import { VsCodeWorkspaceChannelApiImpl } from "./workspace/VsCodeWorkspaceChannelApiImpl";
export declare class DefaultVsCodeKieEditorChannelApiImpl implements KogitoEditorChannelApi, JavaCodeCompletionChannelApi {
    protected readonly editor: VsCodeKieEditorController;
    protected readonly resourceContentService: ResourceContentService;
    protected readonly vscodeWorkspace: VsCodeWorkspaceChannelApiImpl;
    protected readonly vscodeNotifications: VsCodeNotificationsChannelApiImpl;
    protected readonly javaCodeCompletionApi: JavaCodeCompletionApi;
    protected readonly viewType: string;
    protected readonly i18n: I18n<VsCodeI18n>;
    constructor(editor: VsCodeKieEditorController, resourceContentService: ResourceContentService, vscodeWorkspace: VsCodeWorkspaceChannelApiImpl, vscodeNotifications: VsCodeNotificationsChannelApiImpl, javaCodeCompletionApi: JavaCodeCompletionApi, viewType: string, i18n: I18n<VsCodeI18n>);
    kogitoWorkspace_newEdit(workspaceEdit: WorkspaceEdit): Promise<void>;
    kogitoWorkspace_openFile(normalizedPosixPathRelativeToTheWorkspaceRoot: string): void;
    kogitoEditor_contentRequest(): Promise<{
        content: string;
        normalizedPosixPathRelativeToTheWorkspaceRoot: string;
    }>;
    kogitoEditor_setContentError(editorContent: EditorContent): void;
    kogitoEditor_ready(): void;
    kogitoEditor_theme(): {
        defaultValue: import("@kie-tools-core/editor/dist/api").EditorTheme;
    };
    kogitoEditor_stateControlCommandUpdate(command: StateControlCommand): void;
    kogitoWorkspace_resourceContentRequest(request: ResourceContentRequest): Promise<import("@kie-tools-core/workspace/dist/api").ResourceContent | undefined>;
    kogitoWorkspace_resourceListRequest(request: ResourceListRequest): Promise<import("@kie-tools-core/workspace/dist/api").ResourcesList>;
    kogitoI18n_getLocale(): Promise<string>;
    kogitoNotifications_createNotification(notification: Notification): void;
    kogitoNotifications_setNotifications(normalizedPosixPathRelativeToTheWorkspaceRoot: string, notifications: Notification[]): void;
    kogitoNotifications_removeNotifications(normalizedPosixPathRelativeToTheWorkspaceRoot: string): void;
    kogitoJavaCodeCompletion__getAccessors(fqcn: string, query: string): Promise<JavaCodeCompletionAccessor[]>;
    kogitoJavaCodeCompletion__getClasses(query: string): Promise<JavaCodeCompletionClass[]>;
    kogitoJavaCodeCompletion__isLanguageServerAvailable(): Promise<boolean>;
}
//# sourceMappingURL=DefaultVsCodeKieEditorChannelApiImpl.d.ts.map