import { createElement } from "react";
import { useForm } from "uniforms";
import AutoField from "./AutoField";
function AutoFields({ autoField = AutoField, element = "div", fields, omitFields = [], ...props }) {
    const { schema } = useForm();
    return createElement(element, props, (fields !== null && fields !== void 0 ? fields : schema.getSubfields())
        .filter((field) => !omitFields.includes(field))
        .map((field) => createElement(autoField, { key: field, name: field })));
}
export default AutoFields;
//# sourceMappingURL=AutoFields.js.map