import { jsx as _jsx } from "react/jsx-runtime";
import React, { useCallback } from "react";
import { RefForwardingEmbeddedEnvelope } from "@kie-tools-core/envelope/dist/embedded";
import { init } from "../envelope";
import { ContainerType } from "@kie-tools-core/envelope/dist/api";
import { EmbeddedCloudEventFormChannelApiImpl } from "./EmbeddedCloudEventFormChannelApiImpl";
export const EmbeddedCloudEventForm = React.forwardRef((props, forwardedRef) => {
    const refDelegate = useCallback((envelopeServer) => ({}), []);
    const pollInit = useCallback((envelopeServer, container) => {
        var _a;
        init({
            config: {
                containerType: ContainerType.DIV,
                envelopeId: envelopeServer.id,
            },
            container: container(),
            bus: {
                postMessage(message, targetOrigin, transfer) {
                    window.postMessage(message, targetOrigin, transfer);
                },
            },
        });
        return envelopeServer.envelopeApi.requests.cloudEventForm__init({
            origin: envelopeServer.origin,
            envelopeServerId: envelopeServer.id,
        }, {
            isNewInstanceEvent: (_a = props.isNewInstanceEvent) !== null && _a !== void 0 ? _a : true,
            defaultValues: props.defaultValues,
            serviceUrl: props.serviceUrl,
        });
    }, []);
    return (_jsx(EmbeddedCloudEventFormEnvelope, { ref: forwardedRef, apiImpl: new EmbeddedCloudEventFormChannelApiImpl(props.driver), origin: props.targetOrigin, refDelegate: refDelegate, pollInit: pollInit, config: { containerType: ContainerType.DIV } }));
});
const EmbeddedCloudEventFormEnvelope = React.forwardRef(RefForwardingEmbeddedEnvelope);
//# sourceMappingURL=EmbeddedCloudEventForm.js.map