import { areAttributesReasonCodesMissing, validateAttributes } from "./Attributes";
import { ValidationEntry } from "./ValidationRegistry";
import { ValidationLevel } from "./ValidationLevel";
import { Builder } from "../paths";
export const validateCharacteristic = (modelIndex, scorecardProperties, characteristicIndex, characteristic, miningFields, validationRegistry) => {
    if (scorecardProperties.useReasonCodes !== false) {
        if (characteristic.reasonCode === undefined && areAttributesReasonCodesMissing(characteristic.Attribute)) {
            validationRegistry.set(Builder()
                .forModel(modelIndex)
                .forCharacteristics()
                .forCharacteristic(characteristicIndex)
                .forReasonCode()
                .build(), new ValidationEntry(ValidationLevel.WARNING, `${characteristic.name}: Reason code is required`));
        }
        if (scorecardProperties.baselineScore === undefined && characteristic.baselineScore === undefined) {
            validationRegistry.set(Builder()
                .forModel(modelIndex)
                .forCharacteristics()
                .forCharacteristic(characteristicIndex)
                .forBaselineScore()
                .build(), new ValidationEntry(ValidationLevel.WARNING, `${characteristic.name}: Baseline score is required`));
        }
    }
    validateAttributes(modelIndex, scorecardProperties, characteristicIndex, characteristic, miningFields, validationRegistry);
};
export const validateCharacteristics = (modelIndex, scorecardProperties, characteristics, miningFields, validationRegistry) => {
    characteristics.forEach((characteristic, characteristicIndex) => validateCharacteristic(modelIndex, scorecardProperties, characteristicIndex, characteristic, miningFields, validationRegistry));
};
//# sourceMappingURL=Characteristics.js.map