import { Actions } from "./Actions";
import { CompoundPredicate, False, Scorecard, SimplePredicate, SimpleSetPredicate, True, } from "@kie-tools/pmml-editor-marshaller";
import { immerable } from "immer";
import { validateOutputs } from "../validation/Outputs";
import { Builder } from "../paths";
import { validateCharacteristic, validateCharacteristics } from "../validation/Characteristics";
import { validateBaselineScore } from "../validation/ModelCoreProperties";
import { getBaselineScore, getCharacteristics, getMiningSchema, getUseReasonCodes } from "../PMMLModelHelper";
Scorecard[immerable] = true;
export const ScorecardReducer = (historyService, validationRegistry) => {
    return (state, action) => {
        var _a, _b;
        switch (action.type) {
            case Actions.Scorecard_SetModelName:
                historyService.batch(state, Builder().forModel(action.payload.modelIndex).build(), (draft) => {
                    draft.modelName = action.payload.modelName;
                });
                break;
            case Actions.Scorecard_SetCoreProperties:
                historyService.batch(state, Builder().forModel(action.payload.modelIndex).build(), (draft) => {
                    draft.isScorable = action.payload.isScorable;
                    draft.functionName = action.payload.functionName;
                    draft.algorithmName = action.payload.algorithmName;
                    draft.baselineScore = action.payload.baselineScore;
                    draft.baselineMethod = action.payload.baselineMethod;
                    draft.initialScore = action.payload.initialScore;
                    draft.useReasonCodes = action.payload.useReasonCodes;
                    draft.reasonCodeAlgorithm = action.payload.reasonCodeAlgorithm;
                    if (!(action.payload.useReasonCodes === undefined || action.payload.useReasonCodes)) {
                        draft.Characteristics.Characteristic.forEach((characteristic) => {
                            characteristic.reasonCode = undefined;
                            characteristic.Attribute.forEach((attribute) => (attribute.reasonCode = undefined));
                        });
                    }
                    if (action.payload.baselineScore !== undefined) {
                        draft.Characteristics.Characteristic.forEach((characteristic) => {
                            characteristic.baselineScore = undefined;
                        });
                    }
                }, (pmml) => {
                    const modelIndex = action.payload.modelIndex;
                    const miningSchema = getMiningSchema(pmml, modelIndex);
                    const characteristics = getCharacteristics(pmml, modelIndex);
                    const baselineScore = getBaselineScore(pmml, modelIndex);
                    const useReasonCodes = getUseReasonCodes(pmml, modelIndex);
                    if (miningSchema !== undefined && characteristics !== undefined) {
                        validationRegistry.clear(Builder().forModel(modelIndex).forBaselineScore().build());
                        validateBaselineScore(modelIndex, useReasonCodes, baselineScore, characteristics.Characteristic, validationRegistry);
                        validationRegistry.clear(Builder().forModel(modelIndex).forCharacteristics().build());
                        validateCharacteristics(modelIndex, {
                            baselineScore: baselineScore,
                            useReasonCodes: useReasonCodes,
                        }, characteristics.Characteristic, miningSchema.MiningField, validationRegistry);
                    }
                });
                break;
            case Actions.Scorecard_AddCharacteristic:
                historyService.batch(state, Builder().forModel(action.payload.modelIndex).build(), () => {
                }, (pmml) => {
                    const modelIndex = action.payload.modelIndex;
                    const miningSchema = getMiningSchema(pmml, modelIndex);
                    const characteristics = getCharacteristics(pmml, modelIndex);
                    const baselineScore = getBaselineScore(pmml, modelIndex);
                    const useReasonCodes = getUseReasonCodes(pmml, modelIndex);
                    if (miningSchema !== undefined && characteristics !== undefined) {
                        validationRegistry.clear(Builder().forModel(action.payload.modelIndex).forBaselineScore().build());
                        validateBaselineScore(modelIndex, useReasonCodes, baselineScore, characteristics.Characteristic, validationRegistry);
                        validationRegistry.clear(Builder().forModel(modelIndex).forCharacteristics().build());
                        validateCharacteristics(modelIndex, { baselineScore: baselineScore, useReasonCodes: useReasonCodes }, characteristics.Characteristic, miningSchema.MiningField, validationRegistry);
                    }
                });
                break;
            case Actions.Scorecard_DeleteCharacteristic:
                historyService.batch(state, Builder().forModel(action.payload.modelIndex).build(), () => {
                }, (pmml) => {
                    const modelIndex = action.payload.modelIndex;
                    const characteristics = getCharacteristics(pmml, modelIndex);
                    const baselineScore = getBaselineScore(pmml, modelIndex);
                    const useReasonCodes = getUseReasonCodes(pmml, modelIndex);
                    if (characteristics !== undefined) {
                        validationRegistry.clear(Builder().forModel(modelIndex).forBaselineScore().build());
                        validateBaselineScore(modelIndex, useReasonCodes, baselineScore, characteristics.Characteristic, validationRegistry);
                    }
                });
                break;
            case Actions.Scorecard_UpdateCharacteristic:
                historyService.batch(state, Builder().forModel(action.payload.modelIndex).build(), () => {
                }, (pmml) => {
                    const modelIndex = action.payload.modelIndex;
                    const miningSchema = getMiningSchema(pmml, modelIndex);
                    const characteristics = getCharacteristics(pmml, modelIndex);
                    const baselineScore = getBaselineScore(pmml, modelIndex);
                    const useReasonCodes = getUseReasonCodes(pmml, modelIndex);
                    if (miningSchema !== undefined && characteristics !== undefined) {
                        validationRegistry.clear(Builder().forModel(modelIndex).forBaselineScore().build());
                        validateBaselineScore(modelIndex, useReasonCodes, baselineScore, characteristics.Characteristic, validationRegistry);
                        validationRegistry.clear(Builder().forModel(modelIndex).forCharacteristics().build());
                        validateCharacteristics(modelIndex, { baselineScore: baselineScore, useReasonCodes: useReasonCodes }, characteristics.Characteristic, miningSchema.MiningField, validationRegistry);
                    }
                });
                break;
            case Actions.Scorecard_AddAttribute:
            case Actions.Scorecard_DeleteAttribute:
                historyService.batch(state, Builder().forModel(action.payload.modelIndex).build(), () => {
                }, (pmml) => {
                    const modelIndex = action.payload.modelIndex;
                    const characteristicIndex = action.payload.characteristicIndex;
                    const miningSchema = getMiningSchema(pmml, modelIndex);
                    const characteristics = getCharacteristics(pmml, modelIndex);
                    const baselineScore = getBaselineScore(pmml, modelIndex);
                    const useReasonCodes = getUseReasonCodes(pmml, modelIndex);
                    if (miningSchema !== undefined && characteristics !== undefined) {
                        validationRegistry.clear(Builder().forModel(modelIndex).forCharacteristics().forCharacteristic(characteristicIndex).build());
                        validateCharacteristic(modelIndex, { baselineScore: baselineScore, useReasonCodes: useReasonCodes }, characteristicIndex, characteristics.Characteristic[characteristicIndex], miningSchema.MiningField, validationRegistry);
                    }
                });
                break;
            case Actions.UpdateDataDictionaryField:
                if (action.payload.modelIndex !== undefined) {
                    const modelIndex = action.payload.modelIndex;
                    const dataFieldName = action.payload.dataField.name;
                    const originalDataFieldName = action.payload.originalName;
                    state.Characteristics.Characteristic.forEach((characteristic, characteristicIndex) => {
                        characteristic.Attribute.forEach((attribute, attributeIndex) => {
                            updatePredicateFieldName(Builder()
                                .forModel(modelIndex)
                                .forCharacteristics()
                                .forCharacteristic(characteristicIndex)
                                .forAttribute(attributeIndex)
                                .forPredicate(), attribute.predicate, dataFieldName, originalDataFieldName, historyService);
                        });
                    });
                }
                break;
            case Actions.AddMiningSchemaFields:
            case Actions.Scorecard_UpdateAttribute:
                historyService.batch(state, Builder().forModel(action.payload.modelIndex).build(), () => {
                }, (pmml) => {
                    const modelIndex = action.payload.modelIndex;
                    const miningSchema = getMiningSchema(pmml, modelIndex);
                    const characteristics = getCharacteristics(pmml, modelIndex);
                    const baselineScore = getBaselineScore(pmml, modelIndex);
                    const useReasonCodes = getUseReasonCodes(pmml, modelIndex);
                    if (miningSchema !== undefined && characteristics !== undefined) {
                        validationRegistry.clear(Builder().forModel(modelIndex).forCharacteristics().build());
                        validateCharacteristics(action.payload.modelIndex, { baselineScore: baselineScore, useReasonCodes: useReasonCodes }, characteristics.Characteristic, miningSchema.MiningField, validationRegistry);
                    }
                });
                break;
            case Actions.DeleteMiningSchemaField:
                if (state.MiningSchema.MiningField.length > 0) {
                    const modelIndex = action.payload.modelIndex;
                    historyService.batch(state, Builder().forModel(modelIndex).build(), (draft) => {
                    }, (pmml) => {
                        const miningSchema = getMiningSchema(pmml, modelIndex);
                        const characteristics = getCharacteristics(pmml, modelIndex);
                        const baselineScore = getBaselineScore(pmml, modelIndex);
                        const useReasonCodes = getUseReasonCodes(pmml, modelIndex);
                        if (miningSchema !== undefined && characteristics !== undefined) {
                            validationRegistry.clear(Builder().forModel(modelIndex).forCharacteristics().build());
                            validateCharacteristics(modelIndex, { baselineScore: baselineScore, useReasonCodes: useReasonCodes }, characteristics.Characteristic, miningSchema.MiningField, validationRegistry);
                        }
                    });
                }
                break;
            case Actions.Validate:
                if (action.payload.modelIndex !== undefined) {
                    const modelIndex = action.payload.modelIndex;
                    validationRegistry.clear(Builder().forModel(modelIndex).forOutput().build());
                    validateOutputs(modelIndex, (_b = (_a = state.Output) === null || _a === void 0 ? void 0 : _a.OutputField) !== null && _b !== void 0 ? _b : [], state.MiningSchema.MiningField, validationRegistry);
                    validationRegistry.clear(Builder().forModel(modelIndex).forBaselineScore().build());
                    validateBaselineScore(modelIndex, state.useReasonCodes, state.baselineScore, state.Characteristics.Characteristic, validationRegistry);
                    validationRegistry.clear(Builder().forModel(modelIndex).forCharacteristics().build());
                    validateCharacteristics(modelIndex, { baselineScore: state.baselineScore, useReasonCodes: state.useReasonCodes }, state.Characteristics.Characteristic, state.MiningSchema.MiningField, validationRegistry);
                }
        }
        return state;
    };
};
const updatePredicateFieldName = (pathBuilder, predicate, name, originalName, service) => {
    var _a;
    if (predicate === undefined) {
        return;
    }
    else if (predicate instanceof True) {
        return;
    }
    else if (predicate instanceof False) {
        return;
    }
    if (predicate instanceof SimpleSetPredicate) {
        if (originalName === predicate.field) {
            service.batch(predicate, pathBuilder.build(), (draft) => {
                draft.field = name;
            });
        }
    }
    else if (predicate instanceof SimplePredicate) {
        if (originalName === predicate.field) {
            service.batch(predicate, pathBuilder.build(), (draft) => {
                draft.field = name;
            });
        }
    }
    else if (predicate instanceof CompoundPredicate) {
        const cp = predicate;
        (_a = cp.predicates) === null || _a === void 0 ? void 0 : _a.forEach((p, i) => updatePredicateFieldName(pathBuilder.forPredicate(i), p, name, originalName, service));
    }
};
//# sourceMappingURL=ScorecardReducer.js.map