import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { useCallback, useEffect, useMemo, useState } from "react";
import { Button } from "@patternfly/react-core/dist/js/components/Button";
import { TextInput } from "@patternfly/react-core/dist/js/components/TextInput";
import { Stack, StackItem } from "@patternfly/react-core/dist/js/layouts/Stack";
import { Split, SplitItem } from "@patternfly/react-core/dist/js/layouts/Split";
import { FormGroup } from "@patternfly/react-core/dist/js/components/Form";
import { Tooltip } from "@patternfly/react-core/dist/js/components/Tooltip";
import { ExclamationCircleIcon } from "@patternfly/react-icons/dist/js/icons/exclamation-circle-icon";
import { HelpIcon } from "@patternfly/react-icons/dist/js/icons/help-icon";
import "./CharacteristicsTableRow.scss";
import "../../EditorScorecard/templates/ScorecardEditorPage.scss";
import { AttributesTable } from "../organisms";
import useOnclickOutside from "react-cool-onclickoutside";
import { Operation } from "../Operation";
import { Actions } from "../../../reducers";
import { useSelector } from "react-redux";
import { Scorecard } from "@kie-tools/pmml-editor-marshaller";
import { useBatchDispatch, useHistoryService } from "../../../history";
import { useOperation } from "../OperationContext";
import { Builder } from "../../../paths";
import { useValidationRegistry } from "../../../validation";
import { isEqual } from "lodash";
var get = Reflect.get;
var set = Reflect.set;
export const CharacteristicsTableEditRow = (props) => {
    var _a;
    const { modelIndex, areReasonCodesUsed, scorecardBaselineScore, characteristic, validateCharacteristicName, viewAttribute, onAddAttribute, onCommitAndClose, onCommit, onCancel, } = props;
    const characteristicIndex = characteristic.index;
    const { activeOperation } = useOperation();
    const { service, getCurrentState } = useHistoryService();
    const dispatch = useBatchDispatch(service, getCurrentState);
    const [name, setName] = useState({
        value: undefined,
        valid: true,
    });
    const [reasonCode, setReasonCode] = useState();
    const [baselineScore, setBaselineScore] = useState();
    const attributes = useSelector((state) => {
        const model = state.models ? state.models[modelIndex] : undefined;
        if (model instanceof Scorecard && characteristicIndex !== undefined) {
            const scorecard = model;
            const _characteristic = scorecard.Characteristics.Characteristic[characteristicIndex];
            if (_characteristic) {
                return _characteristic.Attribute;
            }
        }
        return [];
    });
    const isReasonCodeProvidedByAttributes = useMemo(() => {
        return attributes.length > 0 && attributes.every((attribute) => attribute.reasonCode !== undefined);
    }, [attributes]);
    const ref = useOnclickOutside(() => {
        if (name === null || name === void 0 ? void 0 : name.valid) {
            onCommitAndClose();
        }
        else {
            onCancel();
        }
    }, {
        disabled: activeOperation !== Operation.UPDATE_CHARACTERISTIC,
        eventTypes: ["click"],
    });
    useEffect(() => {
        setName({
            value: characteristic === null || characteristic === void 0 ? void 0 : characteristic.characteristic.name,
            valid: true,
        });
        setReasonCode(characteristic === null || characteristic === void 0 ? void 0 : characteristic.characteristic.reasonCode);
        setBaselineScore(characteristic === null || characteristic === void 0 ? void 0 : characteristic.characteristic.baselineScore);
    }, [props]);
    const { validationRegistry } = useValidationRegistry();
    const reasonCodeValidation = useMemo(() => validationRegistry.get(Builder()
        .forModel(modelIndex)
        .forCharacteristics()
        .forCharacteristic(characteristicIndex)
        .forReasonCode()
        .build()), [modelIndex, characteristicIndex, areReasonCodesUsed, characteristic]);
    const baselineScoreValidation = useMemo(() => validationRegistry.get(Builder()
        .forModel(modelIndex)
        .forCharacteristics()
        .forCharacteristic(characteristicIndex)
        .forBaselineScore()
        .build()), [modelIndex, characteristicIndex, scorecardBaselineScore, characteristic]);
    const toNumber = (value) => {
        if (value === "") {
            return undefined;
        }
        const n = Number(value);
        if (isNaN(n)) {
            return undefined;
        }
        return n;
    };
    const onDeleteAttribute = useCallback((attributeIndex) => {
        dispatch({
            type: Actions.Scorecard_DeleteAttribute,
            payload: {
                modelIndex: modelIndex,
                characteristicIndex: characteristicIndex,
                attributeIndex: attributeIndex,
            },
        });
    }, [modelIndex, characteristicIndex]);
    const onUpdateAttribute = useCallback((attributeIndex, partial) => {
        const attribute = attributes[attributeIndex];
        const existingPartial = {};
        Object.keys(partial).forEach((key) => set(existingPartial, key, get(attribute, key)));
        if (!isEqual(partial, existingPartial)) {
            dispatch({
                type: Actions.Scorecard_UpdateAttribute,
                payload: {
                    modelIndex: modelIndex,
                    characteristicIndex: characteristicIndex,
                    attributeIndex: attributeIndex,
                    ...attribute,
                    ...partial,
                },
            });
        }
    }, [modelIndex, characteristicIndex, attributes]);
    return (_jsx("article", { ref: ref, className: "editable-item__inner", tabIndex: 0, "data-ouia-component-id": "edit-characteristic", children: _jsxs(Stack, { hasGutter: true, children: [_jsx(StackItem, { children: _jsxs(Split, { hasGutter: true, children: [_jsx(SplitItem, { children: _jsx(FormGroup, { label: "Name", isRequired: true, fieldId: "characteristic-form-name-helper", helperTextInvalid: "Name is mandatory and must be unique", helperTextInvalidIcon: _jsx(ExclamationCircleIcon, {}), validated: name.valid ? "default" : "error", style: { width: "18em" }, children: _jsx(TextInput, { type: "text", id: "characteristic-name", name: "characteristic-name", "aria-describedby": "characteristic-name-helper", value: (_a = name.value) !== null && _a !== void 0 ? _a : "", placeholder: "Name", validated: name.valid ? "default" : "error", autoFocus: true, onChange: (e) => setName({
                                            value: e,
                                            valid: validateCharacteristicName(e),
                                        }), onBlur: () => {
                                            if (name === null || name === void 0 ? void 0 : name.valid) {
                                                onCommit({
                                                    name: name.value,
                                                });
                                            }
                                            else {
                                                setName({
                                                    value: characteristic.characteristic.name,
                                                    valid: validateCharacteristicName(characteristic.characteristic.name),
                                                });
                                            }
                                        }, ouiaId: "characteristic-name-input" }) }) }), _jsx(SplitItem, { children: _jsx(FormGroup, { label: "Reason code", fieldId: "characteristic-reason-code-helper", style: { width: "16em" }, labelIcon: _jsx(Tooltip, { content: areReasonCodesUsed && isReasonCodeProvidedByAttributes
                                            ? `A Reason code is already provided inside all the Attributes of this Characteristic`
                                            : `
                          Reason code is available and required when Use reason codes property inside Model Setup is yes. \
                          You can enter Reason code here or provide a Reason code for all the Attributes of this \
                          characteristic as an alternative.`, children: _jsx("button", { "aria-label": "More information for Reason code", onClick: (e) => e.preventDefault(), className: "pf-c-form__group-label-help", children: _jsx(HelpIcon, { style: { color: "var(--pf-global--info-color--100)" } }) }) }), validated: reasonCodeValidation.length > 0 ? "warning" : "default", helperText: reasonCodeValidation.length > 0 ? reasonCodeValidation[0].message : undefined, children: _jsx(TextInput, { type: "text", id: "characteristic-reason-code", name: "characteristic-reason-code", "aria-describedby": "characteristic-reason-code-helper", value: reasonCode !== null && reasonCode !== void 0 ? reasonCode : "", onChange: (e) => setReasonCode(e), onBlur: () => {
                                            onCommit({
                                                reasonCode: reasonCode === "" ? undefined : reasonCode,
                                            });
                                        }, validated: reasonCodeValidation.length > 0 ? "warning" : "default", isDisabled: !areReasonCodesUsed || isReasonCodeProvidedByAttributes, ouiaId: "characteristic-reason-code-input" }) }) }), _jsx(SplitItem, { isFilled: true, children: _jsx(FormGroup, { label: "Baseline score", fieldId: "characteristic-baseline-score-helper", labelIcon: _jsx(Tooltip, { content: areReasonCodesUsed && scorecardBaselineScore !== undefined
                                            ? `A baseline score is already provided inside Model Setup`
                                            : `
                          Baseline score for Characteristics is required when Use reason codes property is true \
                          and no Baseline score is provided inside Model Setup
                          `, children: _jsx("button", { "aria-label": "More information for Baseline score", onClick: (e) => e.preventDefault(), className: "pf-c-form__group-label-help", children: _jsx(HelpIcon, { style: { color: "var(--pf-global--info-color--100)" } }) }) }), helperText: baselineScoreValidation.length > 0 ? baselineScoreValidation[0].message : undefined, validated: baselineScoreValidation.length > 0 ? "warning" : "default", style: { width: "16em" }, children: _jsx(TextInput, { type: "number", id: "characteristic-baseline-score", name: "characteristic-baseline-score", "aria-describedby": "characteristic-baseline-score-helper", value: baselineScore !== null && baselineScore !== void 0 ? baselineScore : "", validated: baselineScoreValidation.length > 0 ? "warning" : "default", onChange: (e) => setBaselineScore(toNumber(e)), onBlur: () => {
                                            onCommit({
                                                baselineScore: baselineScore,
                                            });
                                        }, isDisabled: scorecardBaselineScore !== undefined, ouiaId: "characteristic-baseline-score-input" }) }) }), _jsx(SplitItem, { children: _jsx(Button, { id: "add-attribute-button", variant: "primary", onClick: onAddAttribute, ouiaId: "add-attribute", children: "Add Attribute" }) })] }) }), attributes.length > 0 && (_jsx(StackItem, { children: _jsx(FormGroup, { label: "Attributes", fieldId: "output-labels-helper", children: _jsx(AttributesTable, { modelIndex: modelIndex, characteristicIndex: characteristicIndex, characteristic: characteristic.characteristic, areReasonCodesUsed: areReasonCodesUsed, viewAttribute: viewAttribute, deleteAttribute: onDeleteAttribute, onCommit: onUpdateAttribute }) }) }))] }) }));
};
//# sourceMappingURL=CharacteristicsTableEditRow.js.map