import { jsx as _jsx } from "react/jsx-runtime";
import { Button } from "@patternfly/react-core/dist/js/components/Button";
import { Flex, FlexItem } from "@patternfly/react-core/dist/js/layouts/Flex";
import { TrashIcon } from "@patternfly/react-icons/dist/js/icons/trash-icon";
export const AttributesTableAction = (props) => {
    const { index, onDelete } = props;
    const handleDelete = (e, interaction) => {
        e.stopPropagation();
        e.preventDefault();
        if (onDelete) {
            onDelete(interaction);
        }
    };
    return (_jsx(Flex, { alignItems: { default: "alignItemsCenter" }, style: { height: "100%" }, children: _jsx(FlexItem, { children: _jsx(Button, { id: `attribute-n${index}__delete`, "data-testid": `attribute-n${index}__delete`, className: "attribute-item__delete", ouiaId: "delete-attribute", variant: "plain", onClick: (e) => handleDelete(e, "mouse"), onKeyDown: (event) => {
                    if (event.key === "Enter") {
                        handleDelete(event, "keyboard");
                    }
                }, children: _jsx(TrashIcon, {}) }) }) }));
};
//# sourceMappingURL=AttributesTableAction.js.map