/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.aware;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.jetbrains.annotations.Nullable;

public class IndexRebuildFutureStorage {
    private final Map<Integer, GridFutureAdapter<Void>> futs = new HashMap<Integer, GridFutureAdapter<Void>>();
    private final Map<Integer, AffinityTopologyVersion> tops = new HashMap<Integer, AffinityTopologyVersion>();

    @Nullable
    public synchronized GridFutureAdapter<Void> indexRebuildFuture(int cacheId) {
        return this.futs.get(cacheId);
    }

    public synchronized boolean rebuildIndexesOnExchange(int cacheId, AffinityTopologyVersion topVer) {
        boolean rebuild;
        boolean bl = rebuild = this.tops.containsKey(cacheId) && topVer.equals(this.tops.get(cacheId));
        if (rebuild) assert (this.futs.get(cacheId) != null);
        return rebuild;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelRebuildIndexesOnExchange(Set<Integer> cacheIds, AffinityTopologyVersion topVer) {
        if (!cacheIds.isEmpty()) {
            IndexRebuildFutureStorage indexRebuildFutureStorage = this;
            synchronized (indexRebuildFutureStorage) {
                for (Integer cacheId : cacheIds) {
                    if (!this.tops.containsKey(cacheId) || !topVer.equals(this.tops.get(cacheId))) continue;
                    this.onFinishRebuildIndexes(cacheId, null);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Integer> prepareRebuildIndexes(Set<Integer> cacheIds, @Nullable AffinityTopologyVersion topVer) {
        if (!cacheIds.isEmpty()) {
            IndexRebuildFutureStorage indexRebuildFutureStorage = this;
            synchronized (indexRebuildFutureStorage) {
                HashSet<Integer> alreadyPrepared = new HashSet<Integer>();
                for (Integer cacheId : cacheIds) {
                    GridFutureAdapter<Void> prevFut = this.futs.get(cacheId);
                    if (prevFut == null || prevFut.isDone()) {
                        if (topVer != null) {
                            AffinityTopologyVersion prevTopVer = this.tops.put(cacheId, topVer);
                            assert (prevTopVer == null);
                        }
                        this.futs.put(cacheId, new GridFutureAdapter());
                        continue;
                    }
                    alreadyPrepared.add(cacheId);
                }
                return alreadyPrepared;
            }
        }
        return Collections.emptySet();
    }

    public synchronized void onFinishRebuildIndexes(int cacheId, @Nullable Throwable err) {
        this.tops.remove(cacheId);
        GridFutureAdapter<Void> rmv = this.futs.remove(cacheId);
        assert (rmv != null);
        rmv.onDone(err);
    }
}

