/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.yarn.exceptions.InvalidAllocationTagException;

public enum AllocationTagNamespaceType {
    SELF("self"),
    NOT_SELF("not-self"),
    APP_ID("app-id"),
    APP_LABEL("app-label"),
    ALL("all");

    private String typeKeyword;

    private AllocationTagNamespaceType(String keyword) {
        this.typeKeyword = keyword;
    }

    public String getTypeKeyword() {
        return this.typeKeyword;
    }

    public static AllocationTagNamespaceType fromString(String prefix) throws InvalidAllocationTagException {
        for (AllocationTagNamespaceType type : AllocationTagNamespaceType.values()) {
            if (!type.getTypeKeyword().equals(prefix)) continue;
            return type;
        }
        Set values = Arrays.stream(AllocationTagNamespaceType.values()).map(AllocationTagNamespaceType::toString).collect(Collectors.toSet());
        throw new InvalidAllocationTagException("Invalid namespace prefix: " + prefix + ", valid values are: " + String.join((CharSequence)",", values));
    }

    public String toString() {
        return this.getTypeKeyword();
    }
}

