/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.datastore;

import java.io.IOException;
import java.io.Serializable;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.Sum;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.util.BackOff;
import org.apache.beam.sdk.util.FluentBackoff;
import org.apache.beam.sdk.util.MovingFunction;
import org.apache.beam.sdk.util.Sleeper;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RampupThrottlingFn<@UnknownKeyFor T>
extends DoFn<T, T>
implements Serializable {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(RampupThrottlingFn.class);
    private static final @UnknownKeyFor @NonNull @Initialized double BASE_BUDGET = 500.0;
    private static final @UnknownKeyFor @NonNull @Initialized Duration RAMP_UP_INTERVAL = Duration.standardMinutes((long)5L);
    private static final @UnknownKeyFor @NonNull @Initialized FluentBackoff fluentBackoff = FluentBackoff.DEFAULT;
    private final @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Integer> numWorkers;
    private final @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Instant> firstInstantSideInput;
    @VisibleForTesting
    @UnknownKeyFor @NonNull @Initialized Counter throttlingMsecs = Metrics.counter(RampupThrottlingFn.class, (String)"throttling-msecs");
    private transient @UnknownKeyFor @NonNull @Initialized MovingFunction successfulOps;
    @VisibleForTesting
    transient @UnknownKeyFor @NonNull @Initialized Sleeper sleeper;

    public RampupThrottlingFn(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Integer> numWorkers, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Instant> firstInstantSideInput) {
        this.numWorkers = numWorkers;
        this.sleeper = Sleeper.DEFAULT;
        this.successfulOps = new MovingFunction(Duration.standardSeconds((long)1L).getMillis(), Duration.standardSeconds((long)1L).getMillis(), 1, 1, Sum.ofLongs());
        this.firstInstantSideInput = firstInstantSideInput;
    }

    public RampupThrottlingFn(@UnknownKeyFor @NonNull @Initialized int numWorkers, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Instant> timestampSideInput) {
        this((ValueProvider<Integer>)ValueProvider.StaticValueProvider.of((Object)numWorkers), timestampSideInput);
    }

    private @UnknownKeyFor @NonNull @Initialized int calcMaxOpsBudget(@UnknownKeyFor @NonNull @Initialized Instant first, @UnknownKeyFor @NonNull @Initialized Instant instant, @UnknownKeyFor @NonNull @Initialized int hintNumWorkers) {
        double rampUpIntervalMinutes = RAMP_UP_INTERVAL.getStandardMinutes();
        Duration durationSinceFirst = new Duration((ReadableInstant)first, (ReadableInstant)instant);
        double calculatedGrowth = ((double)durationSinceFirst.getStandardMinutes() - rampUpIntervalMinutes) / rampUpIntervalMinutes;
        double growth = Math.max(0.0, calculatedGrowth);
        double maxOpsBudget = 500.0 / (double)hintNumWorkers * Math.pow(1.5, growth);
        return (int)Math.min(2.147483647E9, Math.max(1.0, maxOpsBudget));
    }

    @DoFn.Setup
    public void setup() {
        this.sleeper = Sleeper.DEFAULT;
        this.successfulOps = new MovingFunction(Duration.standardSeconds((long)1L).getMillis(), Duration.standardSeconds((long)1L).getMillis(), 1, 1, Sum.ofLongs());
    }

    @DoFn.ProcessElement
    public void processElement(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized InterruptedException {
        Instant firstInstant = (Instant)c.sideInput(this.firstInstantSideInput);
        Object element = c.element();
        BackOff backoff = fluentBackoff.backoff();
        while (true) {
            Instant instant = Instant.now();
            int maxOpsBudget = this.calcMaxOpsBudget(firstInstant, instant, (Integer)this.numWorkers.get());
            long currentOpCount = this.successfulOps.get(instant.getMillis());
            long availableOps = (long)maxOpsBudget - currentOpCount;
            if (maxOpsBudget >= Integer.MAX_VALUE || availableOps > 0L) {
                c.output(element);
                this.successfulOps.add(instant.getMillis(), 1L);
                return;
            }
            long backoffMillis = backoff.nextBackOffMillis();
            LOG.info("Delaying by {}ms to conform to gradual ramp-up.", (Object)backoffMillis);
            this.throttlingMsecs.inc(backoffMillis);
            this.sleeper.sleep(backoffMillis);
        }
    }

    public void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
        builder.add(DisplayData.item((String)"hintNumWorkers", this.numWorkers).withLabel("Number of workers for ramp-up throttling algorithm"));
    }
}

