/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.hc.core.impl.monitor;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import org.apache.felix.hc.api.HealthCheck;
import org.apache.felix.hc.api.Result;
import org.apache.felix.hc.api.condition.Healthy;
import org.apache.felix.hc.api.condition.SystemReady;
import org.apache.felix.hc.api.condition.Unhealthy;
import org.apache.felix.hc.api.execution.HealthCheckExecutionResult;
import org.apache.felix.hc.api.execution.HealthCheckMetadata;
import org.apache.felix.hc.api.execution.HealthCheckSelector;
import org.apache.felix.hc.core.impl.executor.CombinedExecutionResult;
import org.apache.felix.hc.core.impl.monitor.HealthCheckMonitor;
import org.apache.felix.hc.core.impl.util.lang.StringUtils;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.condition.Condition;
import org.osgi.service.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HealthState {
    private static final Logger LOG = LoggerFactory.getLogger(HealthState.class);
    public static final String TAG_SYSTEMREADY = "systemready";
    public static final String EVENT_TOPIC_PREFIX = "org/apache/felix/health";
    public static final String EVENT_TOPIC_SUFFIX_STATUS_CHANGED = "STATUS_CHANGED";
    public static final String EVENT_TOPIC_SUFFIX_STATUS_UPDATED = "UPDATED";
    public static final String EVENT_PROP_EXECUTION_RESULT = "executionResult";
    public static final String EVENT_PROP_STATUS = "status";
    public static final String EVENT_PROP_PREVIOUS_STATUS = "previousStatus";
    static final Healthy MARKER_SERVICE_HEALTHY = new HealthyCondition();
    static final Unhealthy MARKER_SERVICE_UNHEALTHY = new Unhealthy(){};
    static final SystemReady MARKER_SERVICE_SYSTEMREADY = new SystemReadyCondition();
    private final HealthCheckMonitor monitor;
    private final String tagOrName;
    private final ServiceReference<HealthCheck> healthCheckRef;
    private final boolean isTag;
    private final String propertyName;
    private ServiceRegistration<?> healthyRegistration = null;
    private ServiceRegistration<Unhealthy> unhealthyRegistration = null;
    private HealthCheckExecutionResult executionResult;
    private Result.Status status = null;
    private boolean isHealthy = false;
    private boolean statusChanged = false;
    private boolean isLive = true;

    HealthState(HealthCheckMonitor healthCheckMonitor, ServiceReference<HealthCheck> ref) {
        this.monitor = healthCheckMonitor;
        HealthCheckMetadata metadata = new HealthCheckMetadata(ref);
        this.tagOrName = metadata.getTitle();
        this.healthCheckRef = ref;
        this.isTag = false;
        this.propertyName = this.isTag ? "tag" : "name";
    }

    HealthState(HealthCheckMonitor healthCheckMonitor, String tagOrName, boolean isTag) {
        this.monitor = healthCheckMonitor;
        this.tagOrName = tagOrName;
        this.healthCheckRef = null;
        this.isTag = isTag;
        this.propertyName = isTag ? "tag" : "name";
    }

    public String toString() {
        return "[HealthState tagOrName=" + this.tagOrName + (this.healthCheckRef != null ? " (service ref)" : "") + ", isTag=" + this.isTag + ", status=" + this.status + ", isHealthy=" + this.isHealthy + ", statusChanged=" + this.statusChanged + "]";
    }

    public boolean hasChanged() {
        return this.statusChanged;
    }

    public boolean isHealthy() {
        return this.isHealthy;
    }

    String getTagOrName() {
        return this.tagOrName;
    }

    boolean isTag() {
        return this.isTag;
    }

    HealthCheckExecutionResult getExecutionResult() {
        return this.executionResult;
    }

    public void update() {
        List executionResults;
        if (this.healthCheckRef != null) {
            executionResults = Arrays.asList(this.monitor.getExecutor().execute(this.healthCheckRef));
        } else {
            HealthCheckSelector selector = this.isTag ? HealthCheckSelector.tags((String[])new String[]{this.tagOrName}) : HealthCheckSelector.names((String[])new String[]{this.tagOrName});
            executionResults = this.monitor.getExecutor().execute(selector);
        }
        CombinedExecutionResult result = executionResults.size() == 1 ? (HealthCheckExecutionResult)executionResults.get(0) : new CombinedExecutionResult(executionResults, Result.Status.TEMPORARILY_UNAVAILABLE);
        LOG.trace("Result of '{}' => {}", (Object)this.tagOrName, (Object)result.getHealthCheckResult().getStatus());
        this.update(result);
    }

    synchronized void update(HealthCheckExecutionResult executionResult) {
        if (!this.isLive) {
            LOG.trace("Not live anymore, skipping result update for {}", (Object)this);
            return;
        }
        this.executionResult = executionResult;
        Result.Status previousStatus = this.status;
        this.status = executionResult.getHealthCheckResult().getStatus();
        this.isHealthy = this.status == Result.Status.OK || this.monitor.isTreatWarnAsHealthy() && this.status == Result.Status.WARN;
        this.statusChanged = previousStatus != this.status;
        LOG.trace("  {}: isHealthy={} statusChanged={}", new Object[]{this.tagOrName, this.isHealthy, this.statusChanged});
        this.registerMarkerServices();
        this.sendEvents(executionResult, previousStatus);
    }

    private void registerMarkerServices() {
        if (this.monitor.isRegisterHealthyMarkerService()) {
            if (this.isHealthy && this.healthyRegistration == null) {
                this.registerHealthyService();
            } else if (!this.isHealthy && this.healthyRegistration != null) {
                this.unregisterHealthyService();
            }
        }
        if (this.monitor.isRegisterUnhealthyMarkerService()) {
            if (!this.isHealthy && this.unhealthyRegistration == null) {
                this.registerUnhealthyService();
            } else if (this.isHealthy && this.unhealthyRegistration != null) {
                this.unregisterUnhealthyService();
            }
        }
    }

    private void registerHealthyService() {
        if (this.healthyRegistration == null) {
            boolean isSystemReady = TAG_SYSTEMREADY.equals(this.tagOrName);
            LOG.debug("HealthCheckMonitor: registerHealthyService() {} ", (Object)this.tagOrName);
            Hashtable<String, String> registrationProps = new Hashtable<String, String>();
            ((Dictionary)registrationProps).put(this.propertyName, this.tagOrName);
            ((Dictionary)registrationProps).put("activated", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
            ((Dictionary)registrationProps).put("osgi.condition.id", "felix.hc.".concat(this.tagOrName));
            if (isSystemReady) {
                LOG.debug("HealthCheckMonitor: SYSTEM READY");
            }
            ArrayList<String> services = new ArrayList<String>();
            services.add(Healthy.class.getName());
            services.add(Condition.class.getName());
            if (isSystemReady) {
                services.add(SystemReady.class.getName());
            }
            SystemReady service = isSystemReady ? MARKER_SERVICE_SYSTEMREADY : MARKER_SERVICE_HEALTHY;
            this.healthyRegistration = this.monitor.getBundleContext().registerService(services.toArray(new String[0]), (Object)service, registrationProps);
            LOG.debug("HealthCheckMonitor: Healthy service for {} '{}' registered", (Object)this.propertyName, (Object)this.tagOrName);
        }
    }

    private void unregisterHealthyService() {
        if (this.healthyRegistration != null) {
            this.healthyRegistration.unregister();
            this.healthyRegistration = null;
            LOG.debug("HealthCheckMonitor: Healthy service for {} '{}' unregistered", (Object)this.propertyName, (Object)this.tagOrName);
        }
    }

    private void registerUnhealthyService() {
        if (this.unhealthyRegistration == null) {
            Hashtable<String, String> registrationProps = new Hashtable<String, String>();
            ((Dictionary)registrationProps).put("tag", this.tagOrName);
            ((Dictionary)registrationProps).put("activated", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
            this.unhealthyRegistration = this.monitor.getBundleContext().registerService(Unhealthy.class, (Object)MARKER_SERVICE_UNHEALTHY, registrationProps);
            LOG.debug("HealthCheckMonitor: Unhealthy service for {} '{}' registered", (Object)this.propertyName, (Object)this.tagOrName);
        }
    }

    private void unregisterUnhealthyService() {
        if (this.unhealthyRegistration != null) {
            this.unhealthyRegistration.unregister();
            this.unhealthyRegistration = null;
            LOG.debug("HealthCheckMonitor: Unhealthy service for {} '{}' unregistered", (Object)this.propertyName, (Object)this.tagOrName);
        }
    }

    private void sendEvents(HealthCheckExecutionResult executionResult, Result.Status previousStatus) {
        HealthCheckMonitor.ChangeType sendEventsConfig = this.monitor.getSendEvents();
        if (sendEventsConfig == HealthCheckMonitor.ChangeType.ALL || this.statusChanged && (sendEventsConfig == HealthCheckMonitor.ChangeType.STATUS_CHANGES || sendEventsConfig == HealthCheckMonitor.ChangeType.STATUS_CHANGES_OR_NOT_OK) || !executionResult.getHealthCheckResult().isOk() && sendEventsConfig == HealthCheckMonitor.ChangeType.STATUS_CHANGES_OR_NOT_OK) {
            String componentName;
            String eventSuffix = this.statusChanged ? EVENT_TOPIC_SUFFIX_STATUS_CHANGED : EVENT_TOPIC_SUFFIX_STATUS_UPDATED;
            String logMsg = "Posted event for topic '{}': " + (this.statusChanged ? "Status change from {} to {}" : "Result updated (status {})");
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.put(EVENT_PROP_STATUS, this.status);
            if (previousStatus != null) {
                properties.put(EVENT_PROP_PREVIOUS_STATUS, previousStatus);
            }
            properties.put(EVENT_PROP_EXECUTION_RESULT, executionResult);
            String topic = String.join((CharSequence)"/", EVENT_TOPIC_PREFIX, this.propertyName, this.tagOrName.replaceAll("[^A-Za-z0-9-_]+", "_"), eventSuffix);
            this.monitor.getEventAdmin().postEvent(new Event(topic, properties));
            LOG.debug(logMsg, new Object[]{topic, previousStatus, this.status});
            if (!(executionResult instanceof CombinedExecutionResult) && StringUtils.isNotBlank(componentName = (String)executionResult.getHealthCheckMetadata().getServiceReference().getProperty("component.name"))) {
                String topicClass = String.join((CharSequence)"/", EVENT_TOPIC_PREFIX, "component", componentName.replace(".", "/"), eventSuffix);
                this.monitor.getEventAdmin().postEvent(new Event(topicClass, properties));
                LOG.debug(logMsg, new Object[]{topicClass, previousStatus, this.status});
            }
        }
    }

    synchronized void cleanUp() {
        this.unregisterHealthyService();
        this.unregisterUnhealthyService();
        this.isLive = false;
    }

    static final class SystemReadyCondition
    implements Condition,
    SystemReady {
        SystemReadyCondition() {
        }
    }

    static final class HealthyCondition
    implements Condition,
    Healthy {
        HealthyCondition() {
        }
    }
}

