/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.web.panel;

import com.inmethod.grid.column.PropertyColumn;
import com.inmethod.grid.treegrid.TreeGrid;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.apache.directory.fortress.core.model.FortEntity;
import org.apache.directory.fortress.core.model.SDSet;
import org.apache.directory.fortress.web.control.SecUtils;
import org.apache.directory.fortress.web.event.SaveModelEvent;
import org.apache.directory.fortress.web.modal.ModalWindow;
import org.apache.directory.fortress.web.model.SDListModel;
import org.apache.directory.fortress.web.panel.RoleSearchModalPanel;
import org.apache.directory.fortress.web.panel.SDListPanel;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.markup.html.form.Radio;
import org.apache.wicket.markup.html.form.RadioGroup;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SDListPanel
extends FormComponentPanel {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger((String)SDListPanel.class.getName());
    private Form listForm;
    private DefaultTreeModel treeModel;
    private DefaultMutableTreeNode node;
    private TreeGrid<DefaultTreeModel, DefaultMutableTreeNode, String> grid;
    private DefaultMutableTreeNode rootNode;
    private String searchVal;
    private char selectedRadioButton;
    private TextField searchValFld;
    private RadioGroup radioGroup;
    private static final char NAMES = 'N';
    private static final char ROLES = 'R';

    public SDListPanel(String id, boolean isStatic) {
        super(id);
        String opName;
        String searchLabel;
        SDSet sdSet = new SDSet();
        sdSet.setName("");
        if (isStatic) {
            sdSet.setType(SDSet.SDType.STATIC);
            searchLabel = "SSD Name";
            opName = "ssdRoleSets";
        } else {
            sdSet.setType(SDSet.SDType.DYNAMIC);
            searchLabel = "DSD Name";
            opName = "dsdRoleSets";
        }
        SDListModel sdListModel = new SDListModel(sdSet, SecUtils.getSession((Component)this));
        this.setDefaultModel((IModel)sdListModel);
        ArrayList<PropertyColumn> columns = new ArrayList<PropertyColumn>();
        columns.add(new PropertyColumn((IModel)Model.of((Serializable)((Object)searchLabel)), "userObject.name"));
        PropertyColumn description = new PropertyColumn((IModel)Model.of((Serializable)((Object)"Description")), "userObject.Description");
        description.setInitialSize(300);
        columns.add(description);
        PropertyColumn cardinality = new PropertyColumn((IModel)Model.of((Serializable)((Object)"Cardinality")), "userObject.Cardinality");
        cardinality.setInitialSize(100);
        columns.add(cardinality);
        PropertyColumn members = new PropertyColumn((IModel)Model.of((Serializable)((Object)"Members")), "userObject.members");
        members.setInitialSize(600);
        columns.add(members);
        List sdSets = (List)this.getDefaultModel().getObject();
        this.treeModel = this.createTreeModel(sdSets);
        this.grid = new /* Unavailable Anonymous Inner Class!! */;
        this.grid.setAllowSelectMultiple(false);
        this.grid.setClickRowToSelect(true);
        this.grid.setClickRowToDeselect(false);
        this.grid.setSelectToEdit(false);
        this.grid.getTreeState().expandAll();
        this.listForm = new Form("form");
        this.listForm.add(new Component[]{this.grid});
        this.grid.setOutputMarkupId(true);
        this.radioGroup = new RadioGroup("searchOptions", (IModel)new PropertyModel((Object)this, "selectedRadioButton"));
        this.add(new Component[]{this.radioGroup});
        Radio nameRb = new Radio("nameRb", (IModel)new Model((Serializable)Character.valueOf('N')));
        this.radioGroup.add(new Component[]{nameRb});
        Radio roleRb = new Radio("roleRb", (IModel)new Model((Serializable)Character.valueOf('R')));
        this.radioGroup.add(new Component[]{roleRb});
        this.addRoleSearchModal(roleRb);
        this.radioGroup.setOutputMarkupId(true);
        this.radioGroup.setRenderBodyOnly(false);
        this.searchValFld = new TextField("searchVal", (IModel)new PropertyModel((Object)this, "searchVal"));
        this.searchValFld.setOutputMarkupId(true);
        2 ajaxUpdater = new /* Unavailable Anonymous Inner Class!! */;
        this.searchValFld.add(new Behavior[]{ajaxUpdater});
        this.radioGroup.add(new Component[]{this.searchValFld});
        this.listForm.add(new Component[]{this.radioGroup});
        this.selectedRadioButton = (char)78;
        this.listForm.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        this.add(new Component[]{this.listForm});
    }

    private void addRoleSearchModal(Radio roleRb) {
        Component[] componentArray = new Component[1];
        ModalWindow rolesModalWindow = new ModalWindow("rolesearchmodal");
        componentArray[0] = rolesModalWindow;
        this.listForm.add(componentArray);
        RoleSearchModalPanel roleSearchModalPanel = new RoleSearchModalPanel(rolesModalWindow.getContentId(), rolesModalWindow, false);
        rolesModalWindow.setContent((Component)roleSearchModalPanel);
        rolesModalWindow.setWindowClosedCallback((ModalWindow.WindowClosedCallback)new /* Unavailable Anonymous Inner Class!! */);
        roleRb.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        rolesModalWindow.setTitle("Role Search Modal");
        rolesModalWindow.setInitialWidth(700);
        rolesModalWindow.setInitialHeight(700);
        rolesModalWindow.setCookieName("role-assign-modal");
    }

    public void onEvent(IEvent event) {
        if (event.getPayload() instanceof SaveModelEvent) {
            SaveModelEvent modelEvent = (SaveModelEvent)event.getPayload();
            switch (6.$SwitchMap$org$apache$directory$fortress$web$event$SaveModelEvent$Operations[modelEvent.getOperation().ordinal()]) {
                case 1: {
                    this.add(modelEvent.getEntity());
                    break;
                }
                case 2: {
                    this.modelChanged();
                    break;
                }
                case 3: {
                    this.prune();
                    break;
                }
            }
            AjaxRequestTarget target = ((SaveModelEvent)event.getPayload()).getAjaxRequestTarget();
            target.add(new Component[]{this.grid});
            LOG.debug(".onEvent SaveModelEvent: " + target.toString());
        }
    }

    private void removeSelectedItems(TreeGrid<DefaultTreeModel, DefaultMutableTreeNode, String> grid) {
        Collection selected = grid.getSelectedItems();
        for (IModel model : selected) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)model.getObject();
            this.treeModel.removeNodeFromParent(node);
            SDSet sdSet = (SDSet)node.getUserObject();
            LOG.debug(".removeSelectedItems sdset node: " + sdSet.getName());
            List sdSets = (List)this.getDefaultModel().getObject();
            sdSets.remove(sdSet);
        }
    }

    private DefaultTreeModel createTreeModel(List<SDSet> sdSets) {
        this.rootNode = new DefaultMutableTreeNode(null);
        DefaultTreeModel model = new DefaultTreeModel(this.rootNode);
        if (sdSets == null) {
            LOG.debug("no SDSets found");
        } else {
            LOG.debug("SDSets found:" + sdSets.size());
            for (SDSet sdSet : sdSets) {
                this.rootNode.add(new DefaultMutableTreeNode(sdSet));
            }
        }
        return model;
    }

    public void add(FortEntity entity) {
        if (this.getDefaultModelObject() != null) {
            List sdSets = (List)this.getDefaultModelObject();
            sdSets.add((SDSet)entity);
            this.treeModel.insertNodeInto(new DefaultMutableTreeNode(entity), this.rootNode, sdSets.size());
        }
    }

    public void prune() {
        this.removeSelectedItems(this.grid);
    }
}

