/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.rest;

import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.security.AccessDeniedException;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityOutFaultInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final Logger LOG = LoggerFactory.getLogger((String)SecurityOutFaultInterceptor.class.getName());

    public SecurityOutFaultInterceptor() {
        super("pre-stream");
    }

    public void handleMessage(Message message) throws Fault {
        Fault fault = (Fault)message.getContent(Exception.class);
        Throwable ex = fault.getCause();
        HttpServletResponse response = (HttpServletResponse)message.getExchange().getInMessage().get((Object)"HTTP.RESPONSE");
        if (!(ex instanceof SecurityException)) {
            LOG.warn("SecurityOutFaultInterceptor caught exception: " + ex);
            response.setStatus(500);
        } else {
            int status = ex instanceof AccessDeniedException ? 403 : 401;
            response.setStatus(status);
            LOG.warn("SecurityOutFaultInterceptor caught security violation: " + ex);
        }
        try {
            response.getOutputStream().write(ex.getMessage().getBytes());
            response.getOutputStream().flush();
        }
        catch (IOException iex) {
            LOG.warn("SecurityOutFaultInterceptor caught IOException: " + iex);
        }
        message.getInterceptorChain().abort();
    }
}

