/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.rest;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.directory.fortress.core.GroupMgr;
import org.apache.directory.fortress.core.GroupMgrFactory;
import org.apache.directory.fortress.core.SecurityException;
import org.apache.directory.fortress.core.model.FortEntity;
import org.apache.directory.fortress.core.model.FortRequest;
import org.apache.directory.fortress.core.model.FortResponse;
import org.apache.directory.fortress.core.model.Group;
import org.apache.directory.fortress.core.model.Role;
import org.apache.directory.fortress.rest.AbstractMgrImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GroupMgrImpl
extends AbstractMgrImpl {
    private static final Logger LOG = LoggerFactory.getLogger((String)GroupMgrImpl.class.getName());

    GroupMgrImpl() {
    }

    FortResponse addGroup(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            GroupMgr groupMgr = GroupMgrFactory.createInstance((String)request.getContextId());
            groupMgr.setAdmin(request.getSession());
            Group inGroup = (Group)request.getEntity();
            Group outGroup = groupMgr.add(inGroup);
            response.setEntity((FortEntity)outGroup);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse readGroup(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            GroupMgr groupMgr = GroupMgrFactory.createInstance((String)request.getContextId());
            groupMgr.setAdmin(request.getSession());
            Group inGroup = (Group)request.getEntity();
            Group outGroup = groupMgr.read(inGroup);
            response.setEntity((FortEntity)outGroup);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse deleteGroup(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            GroupMgr groupMgr = GroupMgrFactory.createInstance((String)request.getContextId());
            groupMgr.setAdmin(request.getSession());
            Group inGroup = (Group)request.getEntity();
            Group outGroup = groupMgr.read(inGroup);
            groupMgr.delete(inGroup);
            response.setEntity((FortEntity)outGroup);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse updateGroup(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            GroupMgr groupMgr = GroupMgrFactory.createInstance((String)request.getContextId());
            groupMgr.setAdmin(request.getSession());
            Group inGroup = (Group)request.getEntity();
            Group outGroup = groupMgr.update(inGroup);
            response.setEntity((FortEntity)outGroup);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse assignedGroups(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            GroupMgr groupMgr = GroupMgrFactory.createInstance((String)request.getContextId());
            groupMgr.setAdmin(request.getSession());
            Role inRole = (Role)request.getEntity();
            List groups = groupMgr.roleGroups(inRole);
            response.setEntities(groups);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse assignedRoles(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            GroupMgr groupMgr = GroupMgrFactory.createInstance((String)request.getContextId());
            groupMgr.setAdmin(request.getSession());
            if (StringUtils.isNotEmpty((CharSequence)request.getValue())) {
                String groupName = request.getValue();
                Group outGroup = groupMgr.read(new Group(groupName));
                List retRoles = new ArrayList();
                if (Group.Type.ROLE.equals((Object)outGroup.getType())) {
                    retRoles = outGroup.getMembers();
                }
                response.setValues(retRoles);
            } else {
                Group inGroup = (Group)request.getEntity();
                List uRoles = groupMgr.groupRoles(inGroup);
                response.setEntities(uRoles);
            }
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse assignGroup(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            GroupMgr groupMgr = GroupMgrFactory.createInstance((String)request.getContextId());
            groupMgr.setAdmin(request.getSession());
            Group inGroup = (Group)request.getEntity();
            String member = request.getValue();
            groupMgr.assign(inGroup, member);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse deassignGroup(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            GroupMgr groupMgr = GroupMgrFactory.createInstance((String)request.getContextId());
            groupMgr.setAdmin(request.getSession());
            Group inGroup = (Group)request.getEntity();
            String member = request.getValue();
            groupMgr.deassign(inGroup, member);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }
}

