/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core.impl;

import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.directory.fortress.core.SecurityException;
import org.apache.directory.fortress.core.ValidationException;
import org.apache.directory.fortress.core.impl.HierUtil;
import org.apache.directory.fortress.core.impl.RoleP;
import org.apache.directory.fortress.core.model.Graphable;
import org.apache.directory.fortress.core.model.Hier;
import org.apache.directory.fortress.core.model.ParentUtil;
import org.apache.directory.fortress.core.model.Relationship;
import org.apache.directory.fortress.core.model.Role;
import org.apache.directory.fortress.core.model.UserRole;
import org.apache.directory.fortress.core.util.cache.Cache;
import org.apache.directory.fortress.core.util.cache.CacheMgr;
import org.jgrapht.graph.SimpleDirectedGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RoleUtil
implements ParentUtil {
    private Cache roleCache;
    private RoleP roleP = new RoleP();
    private static final String CLS_NM = RoleUtil.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger((String)CLS_NM);
    private static volatile RoleUtil sINSTANCE = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static RoleUtil getInstance() {
        if (sINSTANCE != null) return sINSTANCE;
        Class<RoleUtil> clazz = RoleUtil.class;
        synchronized (RoleUtil.class) {
            if (sINSTANCE != null) return sINSTANCE;
            sINSTANCE = new RoleUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sINSTANCE;
        }
    }

    private RoleUtil() {
        this.init();
    }

    private void init() {
        this.roleP = new RoleP();
        CacheMgr cacheMgr = CacheMgr.getInstance();
        this.roleCache = cacheMgr.getCache("fortress.roles");
    }

    boolean isParent(String child, String parent, String contextId) {
        boolean result = false;
        Set<String> parents = this.getAscendants(child, contextId);
        if (parents != null && parents.size() > 0) {
            result = parents.contains(parent.toUpperCase());
        }
        return result;
    }

    Set<String> getDescendants(String roleName, String contextId) {
        return HierUtil.getDescendants(roleName.toUpperCase(), this.getGraph(contextId));
    }

    Set<String> getChildren(String roleName, String contextId) {
        return HierUtil.getChildren(roleName.toUpperCase(), this.getGraph(contextId));
    }

    Set<String> getAscendants(String roleName, String contextId) {
        return HierUtil.getAscendants(roleName.toUpperCase(), this.getGraph(contextId));
    }

    Set<String> getParents(String roleName, String contextId) {
        return HierUtil.getParents(roleName.toUpperCase(), this.getGraph(contextId));
    }

    @Override
    public Set<String> getParentsCB(String roleName, String contextId) {
        return HierUtil.getParents(roleName.toUpperCase(), this.getGraph(contextId));
    }

    int numChildren(String roleName, String contextId) {
        return HierUtil.numChildren(roleName.toUpperCase(), this.getGraph(contextId));
    }

    Set<String> getInheritedRoles(List<UserRole> uRoles, String contextId) {
        TreeSet<String> iRoles = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        if (CollectionUtils.isNotEmpty(uRoles)) {
            for (UserRole uRole : uRoles) {
                String rleName = uRole.getName();
                iRoles.add(rleName);
                Set<String> parents = HierUtil.getAscendants(rleName, this.getGraph(contextId));
                if (!CollectionUtils.isNotEmpty(parents)) continue;
                iRoles.addAll(parents);
            }
        }
        return iRoles;
    }

    Set<String> getAscendantRoles(List<String> roles, String contextId) {
        TreeSet<String> iRoles = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        if (CollectionUtils.isNotEmpty(roles)) {
            for (String role : roles) {
                iRoles.add(role);
                Set<String> parents = HierUtil.getAscendants(role, this.getGraph(contextId));
                if (!CollectionUtils.isNotEmpty(parents)) continue;
                iRoles.addAll(parents);
            }
        }
        return iRoles;
    }

    Set<String> getDescendantRoles(Set<String> roles, String contextId) {
        TreeSet<String> iRoles = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        if (CollectionUtils.isNotEmpty(roles)) {
            for (String role : roles) {
                iRoles.add(role);
                Set<String> children = HierUtil.getDescendants(role, this.getGraph(contextId));
                if (!CollectionUtils.isNotEmpty(children)) continue;
                iRoles.addAll(children);
            }
        }
        return iRoles;
    }

    Set<String> getAscendants(String childName, String parentName, boolean isInclusive, String contextId) {
        return HierUtil.getAscendants(childName, parentName, isInclusive, this.getGraph(contextId));
    }

    void validateRelationship(Role childRole, Role parentRole, boolean mustExist) throws ValidationException {
        HierUtil.validateRelationship(this.getGraph(childRole.getContextId()), childRole.getName(), parentRole.getName(), mustExist);
    }

    void updateHier(String contextId, Relationship relationship, Hier.Op op) throws SecurityException {
        HierUtil.updateHier(this.getGraph(contextId), relationship, op);
    }

    private synchronized SimpleDirectedGraph<String, Relationship> loadGraph(String contextId) {
        Hier inHier = new Hier(Hier.Type.ROLE);
        inHier.setContextId(contextId);
        LOG.info("loadGraph initializing ROLE context [{}]", (Object)inHier.getContextId());
        List<Graphable> descendants = null;
        try {
            descendants = this.roleP.getAllDescendants(inHier.getContextId());
        }
        catch (SecurityException se) {
            LOG.info("loadGraph caught SecurityException={}", (Throwable)se);
        }
        Hier hier = HierUtil.loadHier(contextId, descendants);
        SimpleDirectedGraph<String, Relationship> graph = HierUtil.buildGraph(hier);
        this.roleCache.put(this.getKey(contextId), graph);
        return graph;
    }

    private String getKey(String contextId) {
        Object key = HierUtil.Type.ROLE.toString();
        if (StringUtils.isNotEmpty((CharSequence)contextId) && !contextId.equalsIgnoreCase("null")) {
            key = (String)key + ":" + contextId;
        }
        return key;
    }

    private SimpleDirectedGraph<String, Relationship> getGraph(String contextId) {
        String key = this.getKey(contextId);
        LOG.debug("Getting graph for key " + contextId);
        SimpleDirectedGraph graph = (SimpleDirectedGraph)this.roleCache.get(key);
        if (graph == null) {
            LOG.debug("Graph was null, creating... " + contextId);
            return this.loadGraph(contextId);
        }
        LOG.debug("Graph found in cache, returning...");
        return graph;
    }
}

