/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.cxf.plugin;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.URL;
import java.security.Principal;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.MultivaluedMap;
import javax.xml.bind.JAXBException;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.fediz.core.SecurityTokenThreadLocal;
import org.apache.cxf.fediz.core.config.FederationProtocol;
import org.apache.cxf.fediz.core.config.FedizConfigurator;
import org.apache.cxf.fediz.core.config.FedizContext;
import org.apache.cxf.fediz.core.config.SAMLProtocol;
import org.apache.cxf.fediz.core.util.CookieUtils;
import org.apache.cxf.fediz.cxf.plugin.CXFFedizPrincipal;
import org.apache.cxf.fediz.cxf.plugin.FedizSecurityContext;
import org.apache.cxf.fediz.cxf.plugin.state.EHCacheSPStateManager;
import org.apache.cxf.fediz.cxf.plugin.state.ResponseState;
import org.apache.cxf.fediz.cxf.plugin.state.SPStateManager;
import org.apache.cxf.jaxrs.impl.HttpHeadersImpl;
import org.apache.cxf.jaxrs.impl.UriInfoImpl;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.jaxrs.utils.ResourceUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.security.SecurityContext;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

@PreMatching
public abstract class AbstractServiceProviderFilter
implements ContainerRequestFilter {
    public static final String SECURITY_CONTEXT_TOKEN = "org.apache.fediz.SECURITY_TOKEN";
    public static final String SECURITY_CONTEXT_STATE = "org.apache.fediz.SECURITY_CONTEXT_STATE";
    protected static final ResourceBundle BUNDLE = BundleUtils.getBundle(AbstractServiceProviderFilter.class);
    private static final Logger LOG = LoggerFactory.getLogger(AbstractServiceProviderFilter.class);
    private boolean addWebAppContext = true;
    private boolean addEndpointAddressToContext;
    private FedizConfigurator configurator;
    private String configFile;
    private SPStateManager stateManager;
    private long stateTimeToLive = 120000L;
    private String webAppDomain;

    public String getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    @PostConstruct
    public synchronized void configure() throws JAXBException, IOException {
        if (this.configurator == null) {
            String actualConfigFile = this.configFile;
            if (actualConfigFile == null) {
                actualConfigFile = "fediz_config.xml";
            }
            try {
                File f = new File(actualConfigFile);
                if (!f.exists()) {
                    URL url = ResourceUtils.getResourceURL((String)actualConfigFile, (Bus)BusFactory.getThreadDefaultBus());
                    if (url == null) {
                        url = new URL(actualConfigFile);
                    }
                    if (url != null) {
                        f = new File(url.getPath());
                    }
                }
                this.configurator = new FedizConfigurator();
                this.configurator.loadConfig(f);
                LOG.debug("Fediz configuration read from " + f.getAbsolutePath());
            }
            catch (JAXBException e) {
                LOG.error("Error in parsing configuration", (Throwable)e);
                throw e;
            }
            catch (IOException e) {
                LOG.error("Error in loading configuration file", (Throwable)e);
                throw e;
            }
        }
        if (this.stateManager == null) {
            this.stateManager = new EHCacheSPStateManager("fediz-ehcache.xml");
        }
    }

    @PreDestroy
    public synchronized void cleanup() throws IOException {
        List fedContextList;
        if (this.configurator != null && (fedContextList = this.configurator.getFedizContextList()) != null) {
            for (FedizContext fedContext : fedContextList) {
                try {
                    fedContext.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (this.stateManager != null) {
            this.stateManager.close();
        }
    }

    protected boolean checkSecurityContext(FedizContext fedConfig, Message m, MultivaluedMap<String, String> params) {
        HttpHeadersImpl headers = new HttpHeadersImpl(m);
        Map cookies = headers.getCookies();
        Cookie securityContextCookie = (Cookie)cookies.get(SECURITY_CONTEXT_TOKEN);
        ResponseState responseState = this.getValidResponseState(securityContextCookie, fedConfig, m);
        if (responseState == null) {
            return false;
        }
        Cookie relayStateCookie = (Cookie)cookies.get(SECURITY_CONTEXT_STATE);
        if (fedConfig.isRequestStateValidation()) {
            if (relayStateCookie == null) {
                this.reportError("MISSING_RELAY_COOKIE");
                return false;
            }
            String originalRelayState = responseState.getState();
            if (!originalRelayState.equals(relayStateCookie.getValue())) {
                this.reportError("INVALID_RELAY_STATE");
                return false;
            }
            String state = this.getState(fedConfig, params);
            if (state != null && !state.equals(responseState.getState())) {
                LOG.error("wctx parameter does not match stored value");
                throw ExceptionUtils.toForbiddenException(null, null);
            }
        }
        try {
            Element token = StaxUtils.read((Reader)new StringReader(responseState.getAssertion())).getDocumentElement();
            this.setSecurityContext(responseState, m, token);
        }
        catch (Exception ex) {
            this.reportError("INVALID_RESPONSE_STATE");
            return false;
        }
        return true;
    }

    protected void setSecurityContext(ResponseState responseState, Message m, Element token) throws WSSecurityException {
        CXFFedizPrincipal principal = new CXFFedizPrincipal(responseState.getSubject(), responseState.getClaims(), responseState.getRoles(), token);
        SecurityTokenThreadLocal.setToken((Element)principal.getLoginToken());
        FedizSecurityContext context = new FedizSecurityContext((Principal)((Object)principal), responseState.getRoles());
        m.put(SecurityContext.class, (Object)context);
    }

    protected ResponseState getValidResponseState(Cookie securityContextCookie, FedizContext fedConfig, Message m) {
        if (securityContextCookie == null) {
            this.reportTrace("MISSING_RESPONSE_STATE");
            return null;
        }
        String contextKey = securityContextCookie.getValue();
        ResponseState responseState = this.stateManager.getResponseState(contextKey);
        if (responseState == null) {
            this.reportError("MISSING_RESPONSE_STATE");
            return null;
        }
        if (CookieUtils.isStateExpired((long)responseState.getCreatedAt(), (boolean)fedConfig.isDetectExpiredTokens(), (long)responseState.getExpiresAt(), (long)this.getStateTimeToLive())) {
            this.reportError("EXPIRED_RESPONSE_STATE");
            this.stateManager.removeResponseState(contextKey);
            return null;
        }
        String webAppContext = this.getWebAppContext(m);
        if (this.webAppDomain != null && (responseState.getWebAppDomain() == null || !this.webAppDomain.equals(responseState.getWebAppDomain())) || responseState.getWebAppContext() == null || !webAppContext.equals(responseState.getWebAppContext())) {
            this.stateManager.removeResponseState(contextKey);
            this.reportError("INVALID_RESPONSE_STATE");
            return null;
        }
        if (responseState.getAssertion() == null) {
            this.reportError("INVALID_RESPONSE_STATE");
            return null;
        }
        return responseState;
    }

    protected String getState(FedizContext fedConfig, MultivaluedMap<String, String> params) {
        if (params != null && fedConfig.getProtocol() instanceof FederationProtocol) {
            return (String)params.getFirst((Object)"wctx");
        }
        if (params != null && fedConfig.getProtocol() instanceof SAMLProtocol) {
            return (String)params.getFirst((Object)"RelayState");
        }
        return null;
    }

    protected FedizContext getFedizContext(Message message) {
        Object contextName = this.getWebAppContext(message);
        String[] contextPath = ((String)contextName).split("/");
        if (contextPath.length > 0) {
            contextName = "/" + contextPath[1];
        }
        return this.getContextConfiguration((String)contextName);
    }

    protected synchronized FedizContext getContextConfiguration(String contextName) {
        if (this.configurator == null) {
            throw new IllegalStateException("No Fediz configuration available");
        }
        FedizContext config = this.configurator.getFedizContext(contextName);
        if (config == null) {
            throw new IllegalStateException("No Fediz configuration for context :" + contextName);
        }
        String catalinaBase = System.getProperty("catalina.base");
        if (catalinaBase != null && catalinaBase.length() > 0) {
            config.setRelativePath(catalinaBase);
        }
        return config;
    }

    protected void reportError(String code) {
        org.apache.cxf.common.i18n.Message errorMsg = new org.apache.cxf.common.i18n.Message(code, BUNDLE, new Object[0]);
        LOG.warn(errorMsg.toString());
    }

    protected void reportTrace(String code) {
        if (LOG.isDebugEnabled()) {
            org.apache.cxf.common.i18n.Message errorMsg = new org.apache.cxf.common.i18n.Message(code, BUNDLE, new Object[0]);
            LOG.debug(errorMsg.toString());
        }
    }

    protected String getWebAppContext(Message m) {
        if (this.addWebAppContext) {
            if (this.addEndpointAddressToContext) {
                return new UriInfoImpl(m).getBaseUri().getRawPath();
            }
            String httpBasePath = (String)m.get((Object)"http.base.path");
            return URI.create(httpBasePath).getRawPath();
        }
        return "/";
    }

    public void setAddWebAppContext(boolean addWebAppContext) {
        this.addWebAppContext = addWebAppContext;
    }

    public SPStateManager getStateManager() {
        return this.stateManager;
    }

    public void setStateManager(SPStateManager stateManager) {
        this.stateManager = stateManager;
    }

    public String getWebAppDomain() {
        return this.webAppDomain;
    }

    public void setWebAppDomain(String webAppDomain) {
        this.webAppDomain = webAppDomain;
    }

    public long getStateTimeToLive() {
        return this.stateTimeToLive;
    }

    public void setStateTimeToLive(long stateTimeToLive) {
        this.stateTimeToLive = stateTimeToLive;
    }
}

