/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.tiff;

import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.imaging.ImageInfo;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.common.ImageMetadata;
import org.apache.commons.imaging.formats.tiff.AbstractTiffTest;
import org.apache.commons.imaging.formats.tiff.TiffImageParser;
import org.apache.commons.imaging.formats.tiff.TiffImagingParameters;
import org.apache.commons.imaging.internal.Debug;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TiffRoundtripTest
extends AbstractTiffTest {
    @Test
    public void test() throws Exception {
        List<File> images = this.getTiffImages();
        for (File imageFile : images) {
            Debug.debug((String)"imageFile", (Object)imageFile);
            ImageMetadata metadata = Imaging.getMetadata((File)imageFile);
            Assertions.assertNotNull((Object)metadata);
            ImageInfo imageInfo = Imaging.getImageInfo((File)imageFile);
            Assertions.assertNotNull((Object)imageInfo);
            BufferedImage image = Imaging.getBufferedImage((File)imageFile);
            Assertions.assertNotNull((Object)image);
            int[] compressions = new int[]{1, 5, 32773, 8};
            TiffImageParser tiffImageParser = new TiffImageParser();
            for (int compression : compressions) {
                byte[] tempFile;
                TiffImagingParameters params = new TiffImagingParameters();
                params.setCompression(Integer.valueOf(compression));
                try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
                    tiffImageParser.writeImage(image, (OutputStream)bos, params);
                    tempFile = bos.toByteArray();
                }
                BufferedImage image2 = Imaging.getBufferedImage((byte[])tempFile);
                Assertions.assertNotNull((Object)image2);
            }
        }
    }
}

