/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.tiff;

import java.io.File;
import org.apache.commons.imaging.ImageInfo;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.ImagingTestConstants;
import org.apache.commons.imaging.formats.tiff.AbstractTiffTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TiffReadImageInfoTest
extends AbstractTiffTest {
    static final String[][] testSet = new String[][]{{"1/matthew2.tif", "Color Type", "Black and White"}, {"7/Oregon Scientific DS6639 - DSC_0307 - small - CMYK.tiff", "Color Type", "CMYK"}, {"10/Imaging247.TIFF", "Uses Palette", "true"}, {"12/TransparencyTestStripAssociated.tif", "Is Transparent", "true"}, {"14/TestJpegStrips.tiff", "Color Type", "YCbCr"}};

    private File getTiffFile(String name) {
        File tiffFolder = new File(ImagingTestConstants.TEST_IMAGE_FOLDER, "tiff");
        return new File(tiffFolder, name);
    }

    private String getValue(ImageInfo info, String target) {
        String s = info.toString();
        int i = s.indexOf(target);
        if (i < 0) {
            return "";
        }
        int j = s.indexOf(58, i);
        if (j < 0) {
            return "";
        }
        int k = s.indexOf(10, j);
        if (k < j) {
            return "";
        }
        return s.substring(j + 1, k).trim();
    }

    @Test
    public void testImageInfoElements() throws Exception {
        for (String[] testTarget : testSet) {
            File targetFile = this.getTiffFile(testTarget[0]);
            ImageInfo info = Imaging.getImageInfo((File)targetFile);
            String value = this.getValue(info, testTarget[1]);
            String identifier = targetFile.getName() + ": " + testTarget[1];
            Assertions.assertEquals((Object)value.toLowerCase(), (Object)testTarget[2].toLowerCase(), (String)identifier);
        }
    }
}

